/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.quota;

import java.util.concurrent.Callable;
import org.apache.james.cli.quota.GlobalQuotaSizeCommand;
import org.apache.james.util.Size;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Quota counts limit that applies for all users"})
public class SetGlobalQuotaSizeCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    GlobalQuotaSizeCommand parentCommand;
    @CommandLine.Parameters
    String size;

    @Override
    public Integer call() {
        try {
            this.parentCommand.parentCommand.quotaCommand.fullyQualifiedURL().setQuotaSize(Size.parse(this.size).asBytes());
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.parentCommand.parentCommand.quotaCommand.err);
            return 1;
        }
    }
}

