/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli;

import feign.Feign;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Scanner;
import org.apache.james.webadmin.httpclient.WebAdminHTTPClientFactory;

public class WebAdminHTTPClientUtil {
    private final JwtToken jwtToken;

    public WebAdminHTTPClientUtil(JwtToken jwtToken) {
        this.jwtToken = jwtToken;
    }

    public Feign.Builder builder() {
        return this.jwtOptionsHandler();
    }

    private Feign.Builder jwtOptionsHandler() {
        return this.jwtToken.jwtTokenString.map(tokenString -> this.jwtToken.jwtFilePath.map(tokenFile -> this.jwtTokenAndJwtFileAreBothPresentHandler()).orElse(this.jwtTokenIsPresentAndJwtFromFileIsNotPresentHandler((String)tokenString))).orElse(this.jwtToken.jwtFilePath.map(this::jwtTokenIsNotPresentAndJwtFromFileIsPresentHandler).orElse(this.jwtTokenAndJwtFromFileAreNotPresentHandler()));
    }

    private Feign.Builder jwtTokenAndJwtFileAreBothPresentHandler() {
        this.jwtToken.err.println("Cannot specify both --jwt-from-file and --jwt-token options.");
        return WebAdminHTTPClientFactory.feignBuilder();
    }

    private Feign.Builder jwtTokenIsPresentAndJwtFromFileIsNotPresentHandler(String tokenString) {
        return WebAdminHTTPClientFactory.feignBuilder(tokenString);
    }

    private Feign.Builder jwtTokenIsNotPresentAndJwtFromFileIsPresentHandler(String tokenFile) {
        File myObj = new File(tokenFile);
        Scanner myReader = new Scanner(myObj);
        try {
            StringBuilder data = new StringBuilder();
            while (myReader.hasNextLine()) {
                data.append(myReader.nextLine());
            }
            Feign.Builder builder = WebAdminHTTPClientFactory.feignBuilder(data.toString());
            myReader.close();
            return builder;
        }
        catch (Throwable throwable) {
            try {
                try {
                    myReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.jwtToken.err);
                return Feign.builder();
            }
        }
    }

    private Feign.Builder jwtTokenAndJwtFromFileAreNotPresentHandler() {
        return WebAdminHTTPClientFactory.feignBuilder();
    }

    public static class JwtToken {
        final Optional<String> jwtTokenString;
        final Optional<String> jwtFilePath;
        PrintStream err;

        public JwtToken(Optional<String> jwtTokenString, Optional<String> jwtFilePath, PrintStream err) {
            this.jwtTokenString = jwtTokenString;
            this.jwtFilePath = jwtFilePath;
            this.err = err;
        }
    }
}

