/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lmtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.net.smtp.RelayPath;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.lmtp.LMTPClient;
import org.apache.james.protocols.lmtp.LMTPConfigurationImpl;
import org.apache.james.protocols.lmtp.LMTPProtocolHandlerChain;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.AbstractSMTPServerTest;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.protocols.smtp.utils.TestMessageHook;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.jupiter.api.Test;

public abstract class AbstractLMTPServerTest
extends AbstractSMTPServerTest {
    protected Protocol createProtocol(ProtocolHandler ... handlers) throws WiringException {
        LMTPProtocolHandlerChain chain = new LMTPProtocolHandlerChain();
        ArrayList<ProtocolHandler> hList = new ArrayList<ProtocolHandler>();
        for (Object handler : handlers) {
            if (handler instanceof MessageHook) {
                handler = new MessageHookAdapter(this, (MessageHook)handler);
            }
            hList.add((ProtocolHandler)handler);
        }
        chain.addAll(0, hList);
        chain.wireExtensibleHandlers();
        return new SMTPProtocol((ProtocolHandlerChain)chain, (SMTPConfiguration)new LMTPConfigurationImpl());
    }

    @Ignore(value="LMTP can't handle the queue")
    protected void testDeliveryWith4SimultaneousThreads() {
    }

    @Ignore(value="Disable")
    protected void testInvalidNoBracketsEnformance() throws Exception {
    }

    @Ignore(value="Disable")
    protected void testHeloEnforcement() throws Exception {
    }

    @Ignore(value="Disable")
    public void testHeloEnforcementDisabled() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testMailWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("localhost");
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.mail("me@sender");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testRcptWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("localhost");
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.setSender("me@sender");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.rcpt("rpct1@domain");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    protected void testEhloNotSupported() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.sendCommand("HELO localhost");
            Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDeliveryHook() throws Exception {
        TestDeliverHook deliverHook = new TestDeliverHook(this);
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{deliverHook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("localhost");
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.setSender("me@sender");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient("rpct1@domain");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient("rpct2@domain");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)client.sendShortMessageData("Subject: Testmessage\r\n\r\nThis is a message\r\n")).isTrue();
            int[] replies = ((LMTPClient)client).getReplies();
            ((AbstractIntegerAssert)Assertions.assertThat((int)replies.length).describedAs("Expected two replies", new Object[0])).isEqualTo(2);
            Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)replies[0])).isTrue();
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)replies[1])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).describedAs("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = deliverHook.getDelivered().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env = queued.next();
            AbstractLMTPServerTest.checkEnvelope((MailEnvelope)env, (String)"me@sender", Arrays.asList("rpct1@domain", "rpct2@domain"), (String)"Subject: Testmessage\r\n\r\nThis is a message\r\n");
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    protected SMTPClient createClient() {
        return new LMTPClientImpl(this);
    }

    private final class MessageHookAdapter
    implements DeliverToRecipientHook {
        private final MessageHook hook;
        private HookResult result;

        public MessageHookAdapter(AbstractLMTPServerTest abstractLMTPServerTest, MessageHook hook) {
            this.hook = hook;
        }

        public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
            if (this.result == null) {
                this.result = this.hook.onMessage(session, envelope);
            }
            return this.result;
        }
    }

    private final class TestDeliverHook
    implements DeliverToRecipientHook {
        private final List<MailEnvelope> delivered = new ArrayList<MailEnvelope>();

        private TestDeliverHook(AbstractLMTPServerTest abstractLMTPServerTest) {
        }

        public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
            if ("rpct1@domain".equals(recipient.toString())) {
                return HookResult.DENY;
            }
            this.delivered.add(envelope);
            return HookResult.OK;
        }

        public List<MailEnvelope> getDelivered() {
            return this.delivered;
        }
    }

    private final class LMTPClientImpl
    extends SMTPClient
    implements LMTPClient {
        private final List<Integer> replies = new ArrayList<Integer>();
        private int rcptCount = 0;

        private LMTPClientImpl(AbstractLMTPServerTest abstractLMTPServerTest) {
        }

        public boolean addRecipient(String address) throws IOException {
            boolean ok = super.addRecipient(address);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public boolean addRecipient(RelayPath path) throws IOException {
            boolean ok = super.addRecipient(path);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public int helo(String hostname) throws IOException {
            return this.sendCommand("LHLO", hostname);
        }

        @Override
        public int[] getReplies() throws IOException {
            int[] codes = new int[this.replies.size()];
            for (int i = 0; i < codes.length; ++i) {
                codes[i] = this.replies.remove(0);
            }
            return codes;
        }

        public boolean completePendingCommand() throws IOException {
            for (int i = 0; i < this.rcptCount; ++i) {
                this.replies.add(this.getReply());
            }
            return this.replies.stream().mapToInt(code -> code).anyMatch(SMTPReply::isPositiveCompletion);
        }
    }
}

