/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lmtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.smtp.RelayPath;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SMTPSClient;
import org.apache.james.protocols.api.utils.BogusSslContextFactory;
import org.apache.james.protocols.api.utils.BogusTrustManagerFactory;
import org.apache.james.protocols.lmtp.AbstractLMTPServerTest;
import org.apache.james.protocols.lmtp.LMTPClient;

public abstract class AbstractLMTPSServerTest
extends AbstractLMTPServerTest {
    @Override
    protected SMTPClient createClient() {
        LMTPSClient client = new LMTPSClient(this, true, BogusSslContextFactory.getClientContext());
        client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
        return client;
    }

    protected final class LMTPSClient
    extends SMTPSClient
    implements LMTPClient {
        private final List<Integer> replies = new ArrayList<Integer>();
        private int rcptCount = 0;

        public LMTPSClient(AbstractLMTPSServerTest this$0, boolean implicit, SSLContext ctx) {
            super(implicit, ctx);
        }

        public boolean addRecipient(String address) throws IOException {
            boolean ok = super.addRecipient(address);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public boolean addRecipient(RelayPath path) throws IOException {
            boolean ok = super.addRecipient(path);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public int helo(String hostname) throws IOException {
            return this.sendCommand("LHLO", hostname);
        }

        @Override
        public int[] getReplies() throws IOException {
            int[] codes = new int[this.replies.size()];
            for (int i = 0; i < codes.length; ++i) {
                codes[i] = this.replies.remove(0);
            }
            return codes;
        }

        public boolean completePendingCommand() throws IOException {
            for (int i = 0; i < this.rcptCount; ++i) {
                this.replies.add(this.getReply());
            }
            return this.replies.stream().mapToInt(code -> code).anyMatch(SMTPReply::isPositiveCompletion);
        }
    }
}

