/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class Response {
    private final SMTPStatusCode code;
    private final String message;

    @JsonCreator
    public Response(@JsonProperty(value="code") SMTPStatusCode code, @JsonProperty(value="message") String message) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)((Object)code));
        this.code = code;
        this.message = message;
    }

    public String asReplyString() {
        return this.code.getRawCode() + " " + this.message;
    }

    public SMTPStatusCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public final boolean equals(Object o) {
        if (o instanceof Response) {
            Response response = (Response)o;
            return Objects.equals((Object)this.code, (Object)response.code) && Objects.equals(this.message, response.message);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message});
    }

    public static enum SMTPStatusCode {
        OK_200(200),
        SYSTEM_STATUS_211(211),
        HELP_214(214),
        SERVICE_READY(220),
        SERVICE_CLOSING_CHANNEL_221(221),
        ACTION_COMPLETE_250(250),
        USER_NOT_LOCAL_251(251),
        UNKNOW_USER_252(252),
        START_MAIL_INPUT_354(354),
        SERVICE_NOT_AVAILABLE_421(421),
        REQUESTED_MAIL_ACTION_NOT_TAKEN_450(450),
        REQUESTED_ACTION_ABORTED_451(451),
        REQUESTED_ACTION_NOT_TAKEN_452(452),
        SYNTAX_ERROR_500(500),
        SYNTAX_ERROR_IN_PARAMETERS_OR_ARGUMENTS_501(501),
        COMMAND_NOT_IMPLEMENTED_502(502),
        BAD_SEQUENCE_OF_COMMANDS_503(503),
        COMMAND_PARAMETER_NOT_IMPLEMENTED_504(504),
        DOES_NOT_ACCEPT_MAIL_521(521),
        ACCESS_DENIED_530(530),
        REQUESTED_ACTION_NOT_TAKEN_550(550),
        USER_NOT_LOCAL_551(551),
        REQUESTED_MAIL_ACTION_ABORTED_552(552),
        REQUESTED_ACTION_NOT_TAKEN_553(553),
        TRANSACTION_FAILED_554(554);

        private final int code;

        @JsonCreator
        public static SMTPStatusCode of(int code) {
            return Arrays.stream(SMTPStatusCode.values()).filter(value -> value.code == code).findFirst().orElseThrow(() -> new IllegalArgumentException(code + " is not a supported SMTP code"));
        }

        private SMTPStatusCode(int code) {
            this.code = code;
        }

        @JsonValue
        public int getRawCode() {
            return this.code;
        }
    }
}

