/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.mock.smtp.server.model.MockSMTPBehavior;

public class MockSMTPBehaviorInformation {
    private final MockSMTPBehavior behavior;
    private final RemainingAnswersCounter remainingAnswersCounter;

    public static MockSMTPBehaviorInformation from(MockSMTPBehavior behavior) {
        return new MockSMTPBehaviorInformation(behavior, RemainingAnswersCounter.from(behavior.getNumberOfAnswer()));
    }

    MockSMTPBehaviorInformation(MockSMTPBehavior behavior, RemainingAnswersCounter remainingAnswersCounter) {
        Preconditions.checkNotNull((Object)behavior);
        Preconditions.checkNotNull((Object)remainingAnswersCounter);
        this.behavior = behavior;
        this.remainingAnswersCounter = remainingAnswersCounter;
    }

    public void decreaseRemainingAnswers() {
        this.remainingAnswersCounter.decrease();
    }

    public MockSMTPBehavior getBehavior() {
        return this.behavior;
    }

    public boolean hasRemainingAnswers() {
        return this.remainingAnswersCounter.hasRemainingAnswers();
    }

    @VisibleForTesting
    public Optional<Integer> remainingAnswersCounter() {
        return this.remainingAnswersCounter.getValue();
    }

    public final boolean equals(Object o) {
        if (o instanceof MockSMTPBehaviorInformation) {
            MockSMTPBehaviorInformation that = (MockSMTPBehaviorInformation)o;
            return Objects.equals(this.behavior, that.behavior) && Objects.equals(this.remainingAnswersCounter(), that.remainingAnswersCounter());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.behavior, this.remainingAnswersCounter());
    }

    static interface RemainingAnswersCounter {
        public static RemainingAnswersCounter from(MockSMTPBehavior.NumberOfAnswersPolicy answersPolicy) {
            return answersPolicy.getNumberOfAnswers().map(AnswersCounter::new).orElseGet(UnlimitedAnswersCounter::new);
        }

        public void decrease();

        public boolean hasRemainingAnswers();

        public Optional<Integer> getValue();
    }

    static class AnswersCounter
    implements RemainingAnswersCounter {
        private final AtomicInteger remainingCount;

        static AnswersCounter remains(int remainingCount) {
            return new AnswersCounter(remainingCount);
        }

        AnswersCounter(int remainingCount) {
            Preconditions.checkArgument((remainingCount > 0 ? 1 : 0) != 0, (Object)"remainingCount should be positive");
            this.remainingCount = new AtomicInteger(remainingCount);
        }

        @Override
        public void decrease() {
            this.remainingCount.updateAndGet(currentCount -> {
                Preconditions.checkState((currentCount > 0 ? 1 : 0) != 0, (Object)"remainingCount is already being zero, you can not decrease more");
                return currentCount - 1;
            });
        }

        @Override
        public boolean hasRemainingAnswers() {
            return this.remainingCount.get() > 0;
        }

        @Override
        public Optional<Integer> getValue() {
            return Optional.of(this.remainingCount.get());
        }
    }

    static class UnlimitedAnswersCounter
    implements RemainingAnswersCounter {
        UnlimitedAnswersCounter() {
        }

        @Override
        public void decrease() {
        }

        @Override
        public boolean hasRemainingAnswers() {
            return true;
        }

        @Override
        public Optional<Integer> getValue() {
            return Optional.empty();
        }
    }
}

