/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mock.smtp.server.model.Operator;

@JsonDeserialize(builder=Builder.class)
public interface Condition {
    public static final Condition MATCH_ALL = new MatchAllCondition();

    public boolean matches(String var1);

    public static class MatchAllCondition
    implements Condition {
        public Operator.OperatorName getOperator() {
            return Operator.OperatorName.MATCH_ALL;
        }

        @Override
        public boolean matches(String line) {
            return true;
        }

        public final boolean equals(Object o) {
            return o instanceof MatchAllCondition;
        }

        public final int hashCode() {
            return Objects.hash(MatchAllCondition.class);
        }
    }

    public static class OperatorCondition
    implements Condition {
        private final Operator operator;
        private final String matchingValue;

        public OperatorCondition(Operator operator, String matchingValue) {
            Preconditions.checkNotNull((Object)operator);
            Preconditions.checkNotNull((Object)matchingValue);
            this.operator = operator;
            this.matchingValue = matchingValue;
        }

        public Operator.OperatorName getOperator() {
            return this.operator.getOperatorName();
        }

        public String getMatchingValue() {
            return this.matchingValue;
        }

        @Override
        public boolean matches(String line) {
            return this.operator.actual(line).expected(this.matchingValue).matches();
        }

        public final boolean equals(Object o) {
            if (o instanceof OperatorCondition) {
                OperatorCondition condition = (OperatorCondition)o;
                return Objects.equals(this.operator, condition.operator) && Objects.equals(this.matchingValue, condition.matchingValue);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.operator, this.matchingValue);
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Operator.OperatorName operator;
        private Optional<String> matchingValue = Optional.empty();

        public Builder operator(Operator.OperatorName operator) {
            this.operator = operator;
            return this;
        }

        public Builder matchingValue(String matchingValue) {
            this.matchingValue = Optional.of(matchingValue);
            return this;
        }

        public Condition build() {
            Preconditions.checkState((this.operator != null ? 1 : 0) != 0, (Object)"You need to specify an operator");
            return this.operator.getConditionFactory().apply(this.matchingValue);
        }
    }
}

