/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import org.apache.james.mock.smtp.server.model.MockSMTPBehavior;
import org.apache.james.mock.smtp.server.model.MockSMTPBehaviorInformation;
import org.apache.james.mock.smtp.server.model.MockSmtpBehaviors;
import org.apache.james.mock.smtp.server.model.SMTPExtension;

class SMTPBehaviorRepository {
    private final ConcurrentLinkedQueue<MockSMTPBehaviorInformation> behaviorsInformation = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<SMTPExtension> smtpExtensions = new ConcurrentLinkedQueue();

    SMTPBehaviorRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBehaviors() {
        ConcurrentLinkedQueue<MockSMTPBehaviorInformation> concurrentLinkedQueue = this.behaviorsInformation;
        synchronized (concurrentLinkedQueue) {
            this.behaviorsInformation.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExtensions() {
        ConcurrentLinkedQueue<SMTPExtension> concurrentLinkedQueue = this.smtpExtensions;
        synchronized (concurrentLinkedQueue) {
            this.smtpExtensions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSmtpExtensions(Collection<SMTPExtension> extensions) {
        ConcurrentLinkedQueue<SMTPExtension> concurrentLinkedQueue = this.smtpExtensions;
        synchronized (concurrentLinkedQueue) {
            this.clearExtensions();
            this.smtpExtensions.addAll(extensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SMTPExtension> getSMTPExtensions() {
        ConcurrentLinkedQueue<SMTPExtension> concurrentLinkedQueue = this.smtpExtensions;
        synchronized (concurrentLinkedQueue) {
            return ImmutableList.copyOf(this.smtpExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBehaviors(MockSmtpBehaviors behaviors) {
        ConcurrentLinkedQueue<MockSMTPBehaviorInformation> concurrentLinkedQueue = this.behaviorsInformation;
        synchronized (concurrentLinkedQueue) {
            this.clearBehaviors();
            this.behaviorsInformation.addAll((Collection)behaviors.getBehaviorList().stream().map(MockSMTPBehaviorInformation::from).collect(ImmutableList.toImmutableList()));
        }
    }

    void setBehaviors(MockSMTPBehavior ... behaviors) {
        this.setBehaviors(new MockSmtpBehaviors(Arrays.asList(behaviors)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<MockSMTPBehaviorInformation> remainingBehaviors() {
        ConcurrentLinkedQueue<MockSMTPBehaviorInformation> concurrentLinkedQueue = this.behaviorsInformation;
        synchronized (concurrentLinkedQueue) {
            return this.behaviorsInformation.stream().filter(MockSMTPBehaviorInformation::hasRemainingAnswers);
        }
    }

    void decreaseRemainingAnswers(MockSMTPBehavior behavior) {
        this.getBehaviorInformation(behavior).decreaseRemainingAnswers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    MockSMTPBehaviorInformation getBehaviorInformation(MockSMTPBehavior behavior) {
        ConcurrentLinkedQueue<MockSMTPBehaviorInformation> concurrentLinkedQueue = this.behaviorsInformation;
        synchronized (concurrentLinkedQueue) {
            return this.behaviorsInformation.stream().filter(behaviorInformation -> behaviorInformation.getBehavior().equals(behavior)).findFirst().orElseThrow(() -> new RuntimeException("behavior " + String.valueOf(behavior) + " not found"));
        }
    }
}

