/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.james.mock.smtp.server.model.Mail;

public class ReceivedMailRepository {
    private final ConcurrentLinkedQueue<Mail> mails = new ConcurrentLinkedQueue();

    public void store(Mail mail) {
        this.mails.add(mail);
    }

    public List<Mail> list() {
        return ImmutableList.copyOf(this.mails);
    }

    public int count() {
        return this.mails.size();
    }

    public List<Mail> clear() {
        Mail mail;
        ArrayList<Mail> result = new ArrayList<Mail>();
        while ((mail = this.mails.poll()) != null) {
            result.add(mail);
        }
        return result;
    }
}

