/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.james.mock.smtp.server.ReceivedMailRepository;
import org.apache.james.mock.smtp.server.SMTPBehaviorRepository;
import org.apache.james.mock.smtp.server.jackson.MailAddressModule;
import org.apache.james.mock.smtp.server.model.Mails;
import org.apache.james.mock.smtp.server.model.MockSMTPBehaviorInformation;
import org.apache.james.mock.smtp.server.model.MockSmtpBehaviors;
import org.apache.james.mock.smtp.server.model.SMTPExtension;
import org.apache.james.mock.smtp.server.model.SMTPExtensions;
import org.apache.james.util.Port;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class HTTPConfigurationServer {
    public static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPConfigurationServer.class);
    private static final int RANDOM_PORT = 0;
    static final String SMTP_BEHAVIORS = "/smtpBehaviors";
    static final String SMTP_EXTENSIONS = "/smtpExtensions";
    static final String VERSION = "/version";
    static final String SMTP_MAILS = "/smtpMails";
    static final String SMTP_MAILS_COUNT = "/smtpMailsCount";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new GuavaModule()).registerModule((Module)MailAddressModule.MODULE);
    private final SMTPBehaviorRepository smtpBehaviorRepository;
    private final ReceivedMailRepository receivedMailRepository;
    private final Configuration configuration;

    public static HTTPConfigurationServer onRandomPort(SMTPBehaviorRepository smtpBehaviorRepository, ReceivedMailRepository receivedMailRepository) {
        return new HTTPConfigurationServer(smtpBehaviorRepository, receivedMailRepository, Configuration.randomPort());
    }

    public static HTTPConfigurationServer onPort(SMTPBehaviorRepository smtpBehaviorRepository, ReceivedMailRepository receivedMailRepository, Port port) {
        return new HTTPConfigurationServer(smtpBehaviorRepository, receivedMailRepository, Configuration.port(port));
    }

    private HTTPConfigurationServer(SMTPBehaviorRepository smtpBehaviorRepository, ReceivedMailRepository receivedMailRepository, Configuration configuration) {
        this.smtpBehaviorRepository = smtpBehaviorRepository;
        this.receivedMailRepository = receivedMailRepository;
        this.configuration = configuration;
    }

    public RunningStage start() {
        return new RunningStage(HttpServer.create().port(this.configuration.getPort().map(Port::getValue).orElse(0).intValue()).route(routes -> routes.get(SMTP_BEHAVIORS, this::getBehaviors).get(SMTP_EXTENSIONS, this::getExtensions).get(VERSION, this::getVersion).put(SMTP_BEHAVIORS, this::putBehaviors).put(SMTP_EXTENSIONS, this::putExtensions).delete(SMTP_BEHAVIORS, this::deleteBehaviors).delete(SMTP_EXTENSIONS, this::deleteExtensions).get(SMTP_MAILS, this::getMails).get(SMTP_MAILS_COUNT, this::getMailsCount).delete(SMTP_MAILS, this::deleteMails)).bindNow());
    }

    private Publisher<Void> getBehaviors(HttpServerRequest req, HttpServerResponse res) {
        MockSmtpBehaviors mockSmtpBehaviors = new MockSmtpBehaviors((List)this.smtpBehaviorRepository.remainingBehaviors().map(MockSMTPBehaviorInformation::getBehavior).collect(ImmutableList.toImmutableList()));
        try {
            return res.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).sendString((Publisher)Mono.just((Object)OBJECT_MAPPER.writeValueAsString((Object)mockSmtpBehaviors)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not serialize JSON", (Throwable)e);
            return res.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
        }
    }

    private Publisher<Void> getExtensions(HttpServerRequest req, HttpServerResponse res) {
        List<SMTPExtension> extensions = this.smtpBehaviorRepository.getSMTPExtensions();
        try {
            return res.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).sendString((Publisher)Mono.just((Object)OBJECT_MAPPER.writeValueAsString(extensions)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not serialize JSON", (Throwable)e);
            return res.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
        }
    }

    private Publisher<Void> getVersion(HttpServerRequest req, HttpServerResponse res) {
        return res.status(HttpResponseStatus.OK).sendString((Publisher)Mono.just((Object)"0.4"));
    }

    private Publisher<Void> putBehaviors(HttpServerRequest req, HttpServerResponse res) {
        return req.receive().aggregate().asInputStream().flatMap(inputStream -> {
            try {
                MockSmtpBehaviors behaviors = (MockSmtpBehaviors)OBJECT_MAPPER.readValue(inputStream, MockSmtpBehaviors.class);
                this.smtpBehaviorRepository.setBehaviors(behaviors);
                return res.status(HttpResponseStatus.NO_CONTENT).send();
            }
            catch (IOException e) {
                LOGGER.info("Bad request", (Throwable)e);
                return res.status(HttpResponseStatus.BAD_REQUEST).send();
            }
        });
    }

    private Publisher<Void> putExtensions(HttpServerRequest req, HttpServerResponse res) {
        return req.receive().aggregate().asInputStream().flatMap(inputStream -> {
            try {
                List<SMTPExtension> extensions = ((SMTPExtensions)OBJECT_MAPPER.readValue(inputStream, SMTPExtensions.class)).getSmtpExtensions();
                this.smtpBehaviorRepository.setSmtpExtensions(extensions);
                return res.status(HttpResponseStatus.NO_CONTENT).send();
            }
            catch (IOException e) {
                LOGGER.info("Bad request", (Throwable)e);
                return res.status(HttpResponseStatus.BAD_REQUEST).send();
            }
        });
    }

    private Publisher<Void> deleteBehaviors(HttpServerRequest req, HttpServerResponse res) {
        this.smtpBehaviorRepository.clearBehaviors();
        return res.status(HttpResponseStatus.NO_CONTENT).send();
    }

    private Publisher<Void> deleteExtensions(HttpServerRequest req, HttpServerResponse res) {
        this.smtpBehaviorRepository.clearExtensions();
        return res.status(HttpResponseStatus.NO_CONTENT).send();
    }

    private Publisher<Void> deleteMails(HttpServerRequest req, HttpServerResponse res) {
        Mails mailsRemoved = new Mails(this.receivedMailRepository.clear());
        try {
            return res.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).sendString((Publisher)Mono.just((Object)OBJECT_MAPPER.writeValueAsString((Object)mailsRemoved)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not serialize JSON", (Throwable)e);
            return res.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
        }
    }

    private Publisher<Void> getMails(HttpServerRequest req, HttpServerResponse res) {
        Mails mails = new Mails(this.receivedMailRepository.list());
        try {
            return res.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).sendString((Publisher)Mono.just((Object)OBJECT_MAPPER.writeValueAsString((Object)mails)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not serialize JSON", (Throwable)e);
            return res.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
        }
    }

    private Publisher<Void> getMailsCount(HttpServerRequest req, HttpServerResponse res) {
        int count = this.receivedMailRepository.count();
        try {
            return res.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).sendString((Publisher)Mono.just((Object)OBJECT_MAPPER.writeValueAsString((Object)count)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not serialize JSON", (Throwable)e);
            return res.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
        }
    }

    public static class Configuration {
        private final Optional<Port> port;

        static Configuration port(Port port) {
            return new Configuration(Optional.of(port));
        }

        static Configuration randomPort() {
            return new Configuration(Optional.empty());
        }

        Configuration(Optional<Port> port) {
            this.port = port;
        }

        Optional<Port> getPort() {
            return this.port;
        }
    }

    public static class RunningStage {
        private final DisposableServer server;

        private RunningStage(DisposableServer server) {
            this.server = server;
        }

        public Port getPort() {
            return Port.of((int)this.server.port());
        }

        public void stop() {
            this.server.disposeNow();
        }
    }
}

