/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.MetricFactoryContract;
import org.apache.james.metrics.dropwizard.DropWizardMetricFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DropWizardMetricFactoryTest
implements MetricFactoryContract {
    private DropWizardMetricFactory testee;

    DropWizardMetricFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new DropWizardMetricFactory(new MetricRegistry());
    }

    public MetricFactory testee() {
        return this.testee;
    }

    @Test
    void decoratePublisherWithTimerMetricShouldRecordANewValueForEachRetry() {
        Duration duration = Duration.ofMillis(100L);
        Mono.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Mono.delay((Duration)duration))).repeat(5L).blockLast();
        Assertions.assertThat((double)this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isLessThan((double)(duration.get(ChronoUnit.NANOS) * 2L));
    }

    @Test
    void decoratePublisherWithTimerMetricShouldRecordAtLeastTheMonoDelayWhenWrappedInAFlux() {
        Duration duration = Duration.ofMillis(100L);
        Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Mono.delay((Duration)duration))).blockLast();
        Assertions.assertThat((double)this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isGreaterThan((double)duration.get(ChronoUnit.NANOS));
    }

    @Test
    void decoratePublisherWithTimerMetricShouldRecordAtLeastTheMonoDelayWhenWrappedInAMono() {
        Duration duration = Duration.ofMillis(100L);
        Mono.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Mono.delay((Duration)duration))).block();
        Assertions.assertThat((double)this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isGreaterThan((double)duration.get(ChronoUnit.NANOS));
    }

    @Test
    void decoratePublisherWithTimerMetricShouldRecordAtLeastTheFluxDelayWhenWrappedInAFlux() {
        Duration duration = Duration.ofMillis(100L);
        Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Flux.interval((Duration)duration).take(1L))).blockLast();
        Assertions.assertThat((double)this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isGreaterThan((double)duration.get(ChronoUnit.NANOS));
    }

    @Test
    void decoratePublisherWithTimerMetricLogP99ShouldRecordANewValueForEachRetry() {
        Duration duration = Duration.ofMillis(100L);
        Mono.from((Publisher)this.testee.decoratePublisherWithTimerMetricLogP99("any", (Publisher)Mono.delay((Duration)duration))).repeat(5L).blockLast();
        Assertions.assertThat((double)this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isLessThan((double)(duration.get(ChronoUnit.NANOS) * 2L));
    }

    @Test
    void timerShouldAllowRecordingIndividualAndTotalTiming() {
        Duration duration = Duration.ofMillis(100L);
        Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("anyTotal", (Publisher)Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Mono.delay((Duration)duration))).repeat(5L))).blockLast();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(this.testee.timer("any").getTimer().getCount()).isEqualTo(6L);
            softly.assertThat(this.testee.timer("anyTotal").getTimer().getCount()).isEqualTo(1L);
        });
    }

    @Test
    void timerShouldAllowRecordingIndividualAndTotalTimingWithP99() {
        Duration duration = Duration.ofMillis(100L);
        Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("anyTotal", (Publisher)Flux.from((Publisher)this.testee.decoratePublisherWithTimerMetric("any", (Publisher)Mono.delay((Duration)duration))).repeat(5L))).blockLast();
        SoftAssertions.assertSoftly(softly -> {
            ((DoubleAssert)softly.assertThat(this.testee.timer("any").getTimer().getSnapshot().get99thPercentile()).isLessThan((double)(duration.get(ChronoUnit.NANOS) * 2L))).isGreaterThan((double)duration.get(ChronoUnit.NANOS));
            ((DoubleAssert)softly.assertThat(this.testee.timer("anyTotal").getTimer().getSnapshot().get99thPercentile()).isLessThan((double)(duration.get(ChronoUnit.NANOS) * 7L))).isGreaterThan((double)(duration.get(ChronoUnit.NANOS) * 6L));
        });
    }

    @Test
    void recordElapsedTimeManuallyShouldWork() {
        Duration duration = Duration.ofMillis(100L);
        this.testee.timer("manualRecordTimer").record(duration);
        this.testee.timer("manualRecordTimer").record(duration.plusMillis(50L));
        this.testee.timer("manualRecordTimer").record(duration.plusMillis(90L));
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(this.testee.timer("manualRecordTimer").getTimer().getCount()).isEqualTo(3L);
            ((DoubleAssert)softly.assertThat(this.testee.timer("manualRecordTimer").getTimer().getSnapshot().get99thPercentile()).isLessThan((double)(duration.get(ChronoUnit.NANOS) * 2L))).isGreaterThan((double)duration.get(ChronoUnit.NANOS));
        });
    }
}

