/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.api;

import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public interface MetricFactoryContract {
    public static final String NAME_1 = "name 1";
    public static final String NAME_2 = "name 2";

    public MetricFactory testee();

    @Test
    default public void generateWithSameNameShouldReturnMetricsWithCorrelatedCounter() {
        Metric metric1 = this.testee().generate(NAME_1);
        Metric anotherMetric1 = this.testee().generate(NAME_1);
        metric1.add(47);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(metric1.getCount()).isEqualTo(47L);
            softly.assertThat(anotherMetric1.getCount()).isEqualTo(47L);
        });
    }

    @Test
    default public void generateWithDifferentNamesShouldReturnIndependentMetrics() {
        Metric metric1 = this.testee().generate(NAME_1);
        Metric metric2 = this.testee().generate(NAME_2);
        metric1.add(1);
        metric2.add(2);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(metric1.getCount()).isEqualTo(1L);
            softly.assertThat(metric2.getCount()).isEqualTo(2L);
        });
    }
}

