/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.api;

import org.apache.james.metrics.api.Metric;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface MetricContract {
    public Metric testee();

    @Test
    default public void incrementShouldIncreaseCounter() {
        this.testee().increment();
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(1L);
    }

    @Test
    default public void incrementShouldIncreaseCounterAfterMultipleCalls() {
        this.testee().increment();
        this.testee().increment();
        this.testee().increment();
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(3L);
    }

    @Test
    default public void decrementShouldDecreaseCounter() {
        this.testee().add(2);
        this.testee().decrement();
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(1L);
    }

    @Test
    default public void decrementShouldDecreaseCounterAfterMultipleCalls() {
        this.testee().add(6);
        this.testee().decrement();
        this.testee().decrement();
        this.testee().decrement();
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(3L);
    }

    @Test
    default public void addShouldIncreaseCounter() {
        this.testee().add(10);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(10L);
    }

    @Test
    default public void addShouldDecreaseCounterWhenNegativeNumber() {
        this.testee().add(10);
        this.testee().add(-9);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(1L);
    }

    @Test
    default public void addShouldKeepCounterBeTheSameWhenZero() {
        this.testee().add(10);
        this.testee().add(0);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(10L);
    }

    @Test
    default public void removeShouldDecreaseCounter() {
        this.testee().add(10);
        this.testee().remove(9);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(1L);
    }

    @Test
    default public void removeShouldIncreaseCounterWhenNegativeNumber() {
        this.testee().remove(-9);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(9L);
    }

    @Test
    default public void removeShouldKeepCounterBeTheSameWhenZero() {
        this.testee().add(888);
        this.testee().remove(0);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(888L);
    }

    @Test
    default public void getCountShouldReturnZeroWhenNoUpdate() {
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(0L);
    }

    @Test
    default public void getCountShouldReturnValueWhenCounterIsPositive() {
        this.testee().add(19);
        Assertions.assertThat((long)this.testee().getCount()).isEqualTo(19L);
    }
}

