/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Random;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.net.URI;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionProbe;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionSetMethodContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.UpdatableTickingClock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.mockserver.model.RequestDefinition;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u0015u!B\u001d;\u0011\u00039e!B%;\u0011\u0003Q\u0005\"B)\u0002\t\u0003\u0011\u0006bB*\u0002\u0005\u0004%\t\u0001\u0016\u0005\u0007?\u0006\u0001\u000b\u0011B+\u0007\u000f%S\u0004\u0013aA\u0001A\")\u0011-\u0002C\u0001E\"Aa-\u0002EC\u0002\u0013%q\rC\u0003q\u000b\u0011\u0005\u0011\u000fC\u0004\u0002\u001c\u0015!I!!\b\t\r\u0005]R\u0001\"\u0001c\u0011\u0019\t\t%\u0002C\u0001E\"9\u0011QI\u0003\u0005\u0002\u0005\u001d\u0003bBA'\u000b\u0011\u0005\u0011q\n\u0005\b\u0003+*A\u0011AA,\u0011\u001d\ti&\u0002C\u0001\u0003?Ba!!\u001a\u0006\t\u0003\u0011\u0007BBA5\u000b\u0011\u0005!\r\u0003\u0004\u0002n\u0015!\tA\u0019\u0005\b\u0003c*A\u0011AA:\u0011\u001d\tI(\u0002C\u0001\u0003wBq!!!\u0006\t\u0003\t\u0019\tC\u0004\u0002\u001a\u0016!\t!a'\t\u000f\u0005\u0005V\u0001\"\u0001\u0002$\"1\u0011\u0011V\u0003\u0005\u0002\tDq!!,\u0006\t\u0003\ty\u000b\u0003\u0004\u00026\u0016!\tA\u0019\u0005\u0007\u0003s+A\u0011\u00012\t\r\u0005uV\u0001\"\u0001c\u0011\u0019\t\t-\u0002C\u0001E\"1\u0011QY\u0003\u0005\u0002\tDq!!3\u0006\t\u0003\tY\rC\u0004\u0002R\u0016!\t!a5\t\u000f\u0005eW\u0001\"\u0001\u0002\\\"9\u0011\u0011]\u0003\u0005\u0002\u0005\r\bbBAu\u000b\u0011\u0005\u00111\u001e\u0005\b\u0003c,A\u0011AAz\u0011\u0019\tI0\u0002C\u0001E\"9\u0011Q`\u0003\u0005\u0002\u0005}\bb\u0002B\u0003\u000b\u0011\u0005!q\u0001\u0005\b\u0005\u001b)A\u0011\u0001B\b\u0011\u001d\u0011)\"\u0002C\u0001\u0005/AqA!\b\u0006\t\u0003\u0011y\u0002C\u0004\u0003&\u0015!\tAa\n\t\u000f\t5R\u0001\"\u0001\u00030!9!QG\u0003\u0005\u0002\t]\u0002B\u0002B\u001f\u000b\u0011\u0005!\r\u0003\u0004\u0003B\u0015!\tA\u0019\u0005\b\u0005\u000b*A\u0011\u0001B$\u0011\u001d\u0011i%\u0002C\u0001\u0005\u001fBqA!\u0016\u0006\t\u0003\u00119\u0006C\u0004\u0003^\u0015!\tAa\u0018\t\u000f\t\u0015T\u0001\"\u0001\u0003h!9!QN\u0003\u0005\u0002\t=\u0004B\u0002B;\u000b\u0011\u0005!\r\u0003\u0004\u0003z\u0015!\tA\u0019\u0005\b\u0005{*A\u0011\u0001B@\u0003\u0005\u0002Vo\u001d5Tk\n\u001c8M]5qi&|gnU3u\u001b\u0016$\bn\u001c3D_:$(/Y2u\u0015\tYD(\u0001\u0005d_:$(/Y2u\u0015\tid(A\u0004sM\u000eDdGM\u0019\u000b\u0005}\u0002\u0015\u0001\u00026nCBT!!\u0011\"\u0002\u000b)\fW.Z:\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0002\u0001!\tA\u0015!D\u0001;\u0005\u0005\u0002Vo\u001d5Tk\n\u001c8M]5qi&|gnU3u\u001b\u0016$\bn\u001c3D_:$(/Y2u'\t\t1\n\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u000ba\u0002V%N\u000b~3uJU'B)R+%+F\u0001V!\t1V,D\u0001X\u0015\tA\u0016,\u0001\u0004g_Jl\u0017\r\u001e\u0006\u00035n\u000bA\u0001^5nK*\tA,\u0001\u0003kCZ\f\u0017B\u00010X\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0010)&kUi\u0018$P%6\u000bE\u000bV#SAM\u0011QaS\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\r\u0004\"\u0001\u00143\n\u0005\u0015l%\u0001B+oSR\fQ#Y<bSR\fE/T8tiR+gnU3d_:$7/F\u0001i!\tIg.D\u0001k\u0015\tYG.\u0001\u0003d_J,'BA7E\u0003)\tw/Y5uS2LG/_\u0005\u0003_*\u0014\u0001cQ8oI&$\u0018n\u001c8GC\u000e$xN]=\u0002\u000bM,G/\u00169\u0015\u0007\r\u0014\b\u0010C\u0003t\u0011\u0001\u0007A/\u0001\u0004tKJ4XM\u001d\t\u0003kZl\u0011\u0001Q\u0005\u0003o\u0002\u0013\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:\t\u000beD\u0001\u0019\u0001>\u0002\u0015A,8\u000f[*feZ,'\u000fE\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\u0011q\u0010R\u0001\u000b[>\u001c7n]3sm\u0016\u0014\u0018bAA\u0002y\ny1\t\\5f]R\fe\u000eZ*feZ,'\u000fK\u0002\t\u0003\u000f\u0001B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0002ba&TA!!\u0005\u0002\u0014\u00059!.\u001e9ji\u0016\u0014(bAA\u000b\t\u0006)!.\u001e8ji&!\u0011\u0011DA\u0006\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0011O\u0016$\b+^:i'\u0016\u0014h/\u001a:Ve2$B!a\b\u00026A!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u0011\u0007\u0005\u0015R*\u0004\u0002\u0002()\u0019\u0011\u0011\u0006$\u0002\rq\u0012xn\u001c;?\u0013\r\ti#T\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055R\nC\u0003z\u0013\u0001\u0007!0\u0001\u0012tKRlU\r\u001e5pINCw.\u001e7e\u001d>$(+Z9vSJ,\u0017iY2pk:$\u0018\n\u001a\u0015\u0004\u0015\u0005m\u0002\u0003BA\u0005\u0003{IA!a\u0010\u0002\f\t!A+Z:u\u0003!\u001aX\r^'fi\"|Gm\u00155pk2$g)Y5m/\",g.T5tg&twmQ1qC\nLG.\u001b;zQ\rY\u00111H\u0001\u0018kB$\u0017\r^3TQ>,H\u000eZ'pI&4\u0017\u0010V=qKN$2aYA%\u0011\u0015\u0019H\u00021\u0001uQ\ra\u00111H\u0001\u001fkB$\u0017\r^3TQ>,H\u000e\u001a*fU\u0016\u001cG/\u00168l]><h\u000eV=qKN$2aYA)\u0011\u0015\u0019X\u00021\u0001uQ\ri\u00111H\u0001\u001bkB$\u0017\r^3TQ>,H\u000e\u001a*fU\u0016\u001cGOQ1e)f\u0004Xm\u001d\u000b\u0004G\u0006e\u0003\"B:\u000f\u0001\u0004!\bf\u0001\b\u0002<\u0005IR\u000f\u001d3bi\u0016\u001c\u0006n\\;mIJ+'.Z2u\u0005\u0006$G+\u001f9f)\r\u0019\u0017\u0011\r\u0005\u0006g>\u0001\r\u0001\u001e\u0015\u0004\u001f\u0005m\u0012AQ:fi6+G\u000f[8e'\"|W\u000f\u001c3O_R\u001c%/Z1uK\u0012<\u0006.\u001a8NSN\u001c\u0018N\\4UsB,7\u000f\u0015:pa\u0016\u0014H/_%o\u0007J,\u0017\r^5p]J+\u0017/^3ti\"\u001a\u0001#a\u000f\u0002cM,G/T3uQ>$7\u000b[8vY\u0012tu\u000e^\"sK\u0006$X\rZ,iK:$\u0016\u0010]3t!J|\u0007/\u001a:us&\u001bX)\u001c9us\"\u001a\u0011#a\u000f\u00029\u001d,Go\u00155pk2$'+\u001a;ve:,U\u000e\u001d;z/\",gNT8oK\"\u001a!#a\u000f\u00023\u001d,Go\u00155pk2$'+\u001a;ve:\fE\u000e\u001c*fG>\u0014Hm\u001d\u000b\u0004G\u0006U\u0004\"B:\u0014\u0001\u0004!\bfA\n\u0002<\u0005As-\u001a;TQ>,H\u000e\u001a*fiV\u0014hNV1mS\u0012\fG/\u001a3WKJLg-[2bi&|gnQ8eKR\u00191-! \t\u000bM$\u0002\u0019\u0001;)\u0007Q\tY$\u0001\u001ehKR\u001c\u0006n\\;mI:{GOU3ukJtW\t\u001f9je\u0016$7+\u001e2tGJL\u0007\u000f^5p]\u0006sG\r\u0016:jO\u001e,'\u000f\u00165f\t\u0016dW\r^5p]R)1-!\"\u0002\b\")1/\u0006a\u0001i\"9\u0011\u0011R\u000bA\u0002\u0005-\u0015!B2m_\u000e\\\u0007\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E\u0005)A\u0003vi&d7/\u0003\u0003\u0002\u0016\u0006=%!F+qI\u0006$\u0018M\u00197f)&\u001c7.\u001b8h\u00072|7m\u001b\u0015\u0004+\u0005m\u0012AG4fi\nK\u0018\nZ*i_VdGMU3ukJt'+Z2pe\u0012\u001cHcA2\u0002\u001e\")1O\u0006a\u0001i\"\u001aa#a\u000f\u0002C\u001d,GOQ=JINCw.\u001e7e%\u0016$XO\u001d8F[B$\u0018p\u00165f]\u0016k\u0007\u000f^=\u0015\u0007\r\f)\u000bC\u0003t/\u0001\u0007A\u000fK\u0002\u0018\u0003w\t1dZ3u\u0005fLEm\u00155pk2$'+\u001a;ve:tu\u000e\u001e$pk:$\u0007f\u0001\r\u0002<\u0005Ir-\u001a;TQ>,H\u000e\u001a$jYR,'\u000f\u0015:pa\u0016\u0014H/[3t)\r\u0019\u0017\u0011\u0017\u0005\u0006gf\u0001\r\u0001\u001e\u0015\u00043\u0005m\u0012aL:fi6+G\u000f[8e'\"|W\u000f\u001c3O_R\u001c%/Z1uK\u0012<\u0006.\u001a8J]Z\fG.\u001b3V%2\u0003&o\u001c9feRL\bf\u0001\u000e\u0002<\u000595/\u001a;NKRDw\u000eZ*i_VdGMT8u\u0007J,\u0017\r^3e/\",gn\u0011:fCRLwN\u001c*fcV,7\u000f\u001e%bgZ+'/\u001b4jG\u0006$\u0018n\u001c8D_\u0012,\u0007K]8qKJ$\u0018\u0010K\u0002\u001c\u0003w\t\u0011h]3u\u001b\u0016$\bn\u001c3TQ>,H\u000e\u001a(pi\u000e\u0013X-\u0019;fI^CWM\\\"sK\u0006$\u0018n\u001c8SKF,Xm\u001d;ICNLE\r\u0015:pa\u0016\u0014H/\u001f\u0015\u00049\u0005m\u0012aM:fi6+G\u000f[8e'\"|W\u000f\u001c3O_R\u001c%/Z1uK\u0012<\u0006.\u001a8J]Z\u000bG.\u001b3FqBL'/Z:Qe>\u0004XM\u001d;zQ\ri\u00121H\u00012g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mI:{Go\u0011:fCR,Gm\u00165f]&sg+\u00197jIRK\b/Z:Qe>\u0004XM\u001d;zQ\rq\u00121H\u00012g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mI:{Go\u0011:fCR,Gm\u00165f]\u0012+g/[2f\u00072LWM\u001c;JI\u0016C\u0018n\u001d;t)\r\u0019\u0017Q\u001a\u0005\u0006s~\u0001\rA\u001f\u0015\u0004?\u0005m\u0012!K:fi6+G\u000f[8e'\"|W\u000f\u001c3BG\u000e,\u0007\u000f\u001e,bY&$W\t\u001f9je\u0016\u001c\bK]8qKJ$\u0018\u0010F\u0002d\u0003+DQ!\u001f\u0011A\u0002iD3\u0001IA\u001e\u0003\u0019\u001aX\r^'fi\"|Gm\u00155pk2$7I]3bi\u0016$w\u000b[3o-\u0006d\u0017\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004G\u0006u\u0007\"B=\"\u0001\u0004Q\bfA\u0011\u0002<\u0005\t4/\u001a;NKRDw\u000eZ*i_VdGm\u0011:fCR,GmU3wKJ\fGNV1mS\u0012\u001c%/Z1uS>t'+Z9vKN$HcA2\u0002f\")\u0011P\ta\u0001u\"\u001a!%a\u000f\u0002CM,G/T3uQ>$7\u000b[8vY\u0012\u001cVoY2fgN<\u0006.\u001a8NSb\u001c\u0015m]3\u0015\u0007\r\fi\u000fC\u0003zG\u0001\u0007!\u0010K\u0002$\u0003w\tA%\u001e9eCR,7\u000b[8vY\u00124\u0016\r\\5eCR,g+\u001a:jM&\u001c\u0017\r^5p]\u000e{G-\u001a\u000b\u0004G\u0006U\b\"B:%\u0001\u0004!\bf\u0001\u0013\u0002<\u0005y2/\u001a;NKRDw\u000eZ*i_VdGMU3kK\u000e$\u0018J\u001c<bY&$7*Z=)\u0007\u0015\nY$A\u000ftKRlU\r\u001e5pINCw.\u001e7e\u0003\u000e\u001cW\r\u001d;WC2LGmS3z)\r\u0019'\u0011\u0001\u0005\u0006s\u001a\u0002\rA\u001f\u0015\u0004M\u0005m\u0012aC;qI\u0006$X-T5yK\u0012$2a\u0019B\u0005\u0011\u0015\u0019x\u00051\u0001uQ\r9\u00131H\u00011kB$\u0017\r^3TQ>,H\u000e\u001a(piZ\u000bG.\u001b3bi\u00164VM]5gS\u000e\fG/[8o\u0007>$Wm\u00165f]^\u0013xN\\4\u0015\u0007\r\u0014\t\u0002C\u0003tQ\u0001\u0007A\u000fK\u0002)\u0003w\tq$\u001e9eCR,g+\u00197jI\u0016C\b/\u001b:fgNCw.\u001e7e'V\u001c7-Z3e)\r\u0019'\u0011\u0004\u0005\u0006g&\u0002\r\u0001\u001e\u0015\u0004S\u0005m\u0012\u0001J;qI\u0006$X-\u00138wC2LG-\u0012=qSJ,7o\u0015;sS:<7\u000b[8vY\u00124\u0015-\u001b7\u0015\u0007\r\u0014\t\u0003C\u0003tU\u0001\u0007A\u000fK\u0002+\u0003w\t\u0011+\u001e9eCR,w+\u001b;i\u0005&<w-\u001a:FqBL'/Z:UQ\u0006t7+\u001a:wKJd\u0015.\\5u'\"|W\u000f\u001c3TKR$vnU3sm\u0016\u0014H*[7ji\u0006sG-\u0012=qY&\u001c\u0017\u000e\u001e7z%\u0016$XO\u001d8fIR\u00191M!\u000b\t\u000bM\\\u0003\u0019\u0001;)\u0007-\nY$A\u0010va\u0012\fG/Z(vi\u0012\fG/\u001a3FqBL'/Z:TQ>,H\u000e\u001a$bS2$2a\u0019B\u0019\u0011\u0015\u0019H\u00061\u0001uQ\ra\u00131H\u0001$kB$\u0017\r^3TQ>,H\u000e\u001a$bS2<\u0006.\u001a8V].twn\u001e8Qe>\u0004XM\u001d;z)\r\u0019'\u0011\b\u0005\u0006g6\u0002\r\u0001\u001e\u0015\u0004[\u0005m\u0012!H;qI\u0006$Xm\u00155pk2$g)Y5m/\",g.\u00138wC2LG-\u00133)\u00079\nY$\u0001\u000fva\u0012\fG/Z*i_VdGMR1jY^CWM\u001c(pi\u001a{WO\u001c3)\u0007=\nY$A\u0019tKRlU\r\u001e5pI\u000e\u0013X-\u0019;f'\"|W\u000f\u001c3DC2dg+\u001a:jM&\u001c\u0017\r^5p]R{\u0007+^:i'\u0016\u0014h/\u001a:\u0015\u0007\r\u0014I\u0005C\u0003za\u0001\u0007!\u0010K\u00021\u0003w\tqi]3u\u001b\u0016$\bn\u001c3De\u0016\fG/Z*i_VdGMT8u\u0007J,\u0017\r^3e/\",gnQ1mYZ+'/\u001b4jG\u0006$\u0018n\u001c8U_B+8\u000f[*feZ,'\u000fS1t\u000bJ\u0014xN\u001d\u000b\u0004G\nE\u0003\"B=2\u0001\u0004Q\bfA\u0019\u0002<\u0005)6/\u001a;NKRDw\u000eZ\"sK\u0006$Xm\u00155pk2$gj\u001c;TCZ,7+\u001e2tGJL\u0007\u000f^5p]\u0016sGO]=XQ\u0016t7)\u00197m-\u0016\u0014\u0018NZ5dCRLwN\u001c+p!V\u001c\bnU3sm\u0016\u0014\b*Y:FeJ|'\u000fF\u0002d\u00053BQ!\u001f\u001aA\u0002iD3AMA\u001e\u0003y\u0019X\r^'fi\"|Gm\u00155pk2$\u0017iY2faR4\u0016\r\\5e\u0017\u0016L8\u000fF\u0002d\u0005CBQ!_\u001aA\u0002iD3aMA\u001e\u0003\u0019\u0013w\u000eZ=SKF,Xm\u001d;U_B+8\u000f[*feZ,'o\u00155pk2$')Z#oGJL\b\u000f^3e/\",gn\u00117jK:$\u0018i]:jO:,en\u0019:zaRLwN\\&fsN$2a\u0019B5\u0011\u0015IH\u00071\u0001{Q\r!\u00141H\u0001\u0015I\u0016\u001cHO]8z'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3\u0015\u0007\r\u0014\t\bC\u0003tk\u0001\u0007A\u000fK\u00026\u0003w\ta\u0004Z3tiJ|\u0017p\u00155pk2$g)Y5m/\",g.\u00138wC2LG-\u00133)\u0007Y\nY$A\u0011eKN$(o\\=TQ>,H\u000e\u001a(pi\u001a\u000b\u0017\u000e\\,iK:,fn\u001b8po:LE\rK\u00028\u0003w\tQ\u0004Z3tiJ|\u0017p\u00155pk2$\u0007*\u00198eY\u0016l\u0015\u000e_3e\u0007\u0006\u001cXm\u001d\u000b\u0004G\n\u0005\u0005\"B:9\u0001\u0004!\bf\u0001\u001d\u0002<\u0001")
public interface PushSubscriptionSetMethodContract {
    public static DateTimeFormatter TIME_FORMATTER() {
        return PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds$(PushSubscriptionSetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().await().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.setUp(server, pushServer);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server, ClientAndServer pushServer) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/subscribe").withMethod("POST").withHeader(NottableString.string((String)"Content-type"), new NottableString[]{NottableString.string((String)"application/json charset=utf-8")})).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201)));
    }

    private String getPushServerUrl(ClientAndServer pushServer) {
        return "http://127.0.0.1:" + pushServer.getLocalPort() + "/subscribe";
    }

    public static /* synthetic */ void setMethodShouldNotRequireAccountId$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotRequireAccountId();
    }

    @Test
    default public void setMethodShouldNotRequireAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
    }

    public static /* synthetic */ void setMethodShouldFailWhenMissingCapability$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldFailWhenMissingCapability();
    }

    @Test
    default public void setMethodShouldFailWhenMissingCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"unknownMethod\",\n           |                \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldModifyTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldModifyTypes(server);
    }

    @Test
    default public void updateShouldModifyTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Mailbox\", \"Email\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).types()).asJava()).containsExactlyInAnyOrder((Object[])new TypeName[]{MailboxTypeName$.MODULE$, EmailTypeName$.MODULE$});
    }

    public static /* synthetic */ void updateShouldRejectUnknownTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectUnknownTypes(server);
    }

    @Test
    default public void updateShouldRejectUnknownTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Mailbox\", \"Unknown\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Unknown typeName Unknown\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldRejectBadTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadTypes(server);
    }

    @Test
    default public void updateShouldRejectBadTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": 36\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldRejectBadType$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadType(server);
    }

    @Test
    default public void updateShouldRejectBadType(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Email\", 36]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Missing '/types' property\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenTypesPropertyIsEmpty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": []\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"types must not be empty\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnEmptyWhenNone$(PushSubscriptionSetMethodContract $this) {
        $this.getShouldReturnEmptyWhenNone();
    }

    @Test
    default public void getShouldReturnEmptyWhenNone() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnAllRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnAllRecords(server);
    }

    @Test
    default public void getShouldReturnAllRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnValidatedVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnValidatedVerificationCode(server);
    }

    @Test
    default public void getShouldReturnValidatedVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        probe.validatePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"verificationCode\": \"" + pushSubscription1.verificationCode() + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, UpdatableTickingClock clock) {
        $this.getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion(server, clock);
    }

    @Test
    default public void getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion(GuiceJamesServer server, UpdatableTickingClock clock) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        probe.validatePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id());
        clock.setInstant(ZonedDateTime.now().plusDays(100L).toInstant());
        JsonAssertions.assertThatJson((Object)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |    \"using\": [\"urn:ietf:params:jmap:core\"],\n              |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |        [\n             |            \"PushSubscription/get\",\n             |            {\n             |                \"list\": []\n             |            },\n             |            \"c1\"\n             |        ]\n             |    ]\n             |}")));
        Assertions.assertThat((Object)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id())).isNull();
    }

    public static /* synthetic */ void getByIdShouldReturnRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnRecords(server);
    }

    @Test
    default public void getByIdShouldReturnRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d088", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"" + pushSubscription1.id().serialise() + "\", \"" + pushSubscription2.id().serialise() + "\"]\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getByIdShouldReturnEmptyWhenEmpty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnEmptyWhenEmpty(server);
    }

    @Test
    default public void getByIdShouldReturnEmptyWhenEmpty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": []\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getByIdShouldReturnNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.getByIdShouldReturnNotFound();
    }

    @Test
    default public void getByIdShouldReturnNotFound() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"notFound\"]\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"notFound\": [\"notFound\"],\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldFilterProperties$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldFilterProperties(server);
    }

    @Test
    default public void getShouldFilterProperties(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { \"properties\": [\"types\"] }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInvalidURLProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInvalidURLProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInvalidURLProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"invalid\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/url' property is not valid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"verificationCode\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasIdProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"id\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"id\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidExpiresProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidExpiresProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidExpiresProperty() {
        String invalidExpire = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"expires\": \"" + invalidExpire + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`" + invalidExpire + "` expires must be greater than now\",\n           |                        \"properties\": [\"expires\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidTypesProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidTypesProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidTypesProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"types\": [\"invalid\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenDeviceClientIdExists$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldNotCreatedWhenDeviceClientIdExists(pushServer);
    }

    @Test
    default public void setMethodShouldNotCreatedWhenDeviceClientIdExists(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`a889-ffea-910` deviceClientId must be unique\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidExpiresProperty$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidExpiresProperty(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidExpiresProperty(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"expires\": \"" + new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldCreatedWhenValidRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedWhenValidRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedWhenValidRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldCreatedSeveralValidCreationRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedSeveralValidCreationRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedSeveralValidCreationRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Email\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    },\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldSuccessWhenMixCase$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldSuccessWhenMixCase(pushServer);
    }

    @Test
    default public void setMethodShouldSuccessWhenMixCase(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"invalid\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                },\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldValidateVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldValidateVerificationCode(server);
    }

    @Test
    default public void updateShouldValidateVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription.verificationCode() + "\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isTrue();
    }

    public static /* synthetic */ void setMethodShouldRejectInvalidKey$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldRejectInvalidKey();
    }

    @Test
    default public void setMethodShouldRejectInvalidKey() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"QmFkIGtleQo\",\n        |                    \"auth\": \"YXV0aCBzZWNyZXQK\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"java.security.spec.InvalidKeySpecException: java.security.InvalidKeyException: Unable to decode key\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKey$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKey(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKey(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE5ozzvKUAB7GIfJ44eG-sxEcjT1O2jtk9QVD-MzFOH988CAPlSdkitm16NsMxUWksq6qGwu-r6zT7GCM9oGPXtQ==\",\n        |                    \"auth\": \"Z7B0LmM6iTZD85EWtNRwIg==\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateMixed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateMixed(server);
    }

    @Test
    default public void updateMixed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d081", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d082", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d083", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription4 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d084", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription1.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription1.verificationCode() + "\"\n        |                },\n        |                \"" + pushSubscription2.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                },\n        |                \"" + pushSubscription3.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription3.verificationCode() + "\"\n        |                },\n        |                \"" + pushSubscription4.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrongAgain\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription1.id().serialise() + "\": {},\n           |                    \"" + pushSubscription3.id().serialise() + "\": {}\n           |                },\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription2.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    },\n           |                    \"" + pushSubscription4.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription2.id()).validated()).isFalse();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription3.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription4.id()).validated()).isFalse();
        });
    }

    public static /* synthetic */ void updateShouldNotValidateVerificationCodeWhenWrong$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldNotValidateVerificationCodeWhenWrong(server);
    }

    @Test
    default public void updateShouldNotValidateVerificationCodeWhenWrong(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateValidExpiresShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateValidExpiresShouldSucceed(server);
    }

    @Test
    default public void updateValidExpiresShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String validExpiresString = new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + validExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((String)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).isEqualTo(validExpiresString);
    }

    public static /* synthetic */ void updateInvalidExpiresStringShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateInvalidExpiresStringShouldFail(server);
    }

    @Test
    default public void updateInvalidExpiresStringShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = "whatever";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + invalidExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"" + pushSubscription.id().serialise() + "\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"This string can not be parsed to UTCDate\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(server);
    }

    @Test
    default public void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String biggerExpiresString = new UTCDate(ZonedDateTime.now().plusDays(10L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + biggerExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String fixedExpires = probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"expires\": \"" + fixedExpires + "\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateOutdatedExpiresShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateOutdatedExpiresShouldFail(server);
    }

    @Test
    default public void updateOutdatedExpiresShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + invalidExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"" + pushSubscription.id().serialise() + "\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"`" + invalidExpiresString + "` expires must be greater than now\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void updateShouldFailWhenUnknownProperty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldFailWhenUnknownProperty(server);
    }

    @Test
    default public void updateShouldFailWhenUnknownProperty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"unknown\": \"whatever\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"description\":\"unknown property do not exist thus cannot be updated\",\n           |                        \"properties\":[\"unknown\"],\n           |                        \"type\":\"invalidArguments\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenInvalidId();
    }

    @Test
    default public void updateShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"bad\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"bad\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Invalid UUID string: bad\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldFailWhenNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenNotFound();
    }

    @Test
    default public void updateShouldFailWhenNotFound() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + id + "\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + id + "\": {\n           |                        \"type\": \"notFound\",\n           |                        \"description\": null\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodCreateShouldCallVerificationToPushServer$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldCallVerificationToPushServer(pushServer);
    }

    @Test
    default public void setMethodCreateShouldCallVerificationToPushServer(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath("/subscribe"))))).asJava()).anySatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String pushServerUrl = "http://127.0.0.1:" + pushServer.getLocalPort() + "/invalid";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + pushServerUrl + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"serverFail\",\n           |                        \"description\": \"Error when call to Push Server. \"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String deviceId = "a889-ffea-910";
        String invalidPushServerUrl = "http://127.0.0.1:" + pushServer.getLocalPort() + "/invalid";
        ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"" + deviceId + "\",\n           |                  \"url\": \"" + invalidPushServerUrl + "\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"" + deviceId + "\",\n           |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKeys(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = Random.randBytes((int)16);
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"" + p256dh + "\",\n         |                    \"auth\": \"" + auth + "\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(pushServer);
    }

    @Test
    default public void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = "secret123secret1".getBytes();
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"" + p256dh + "\",\n         |                    \"auth\": \"" + auth + "\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"${json-unit.any-string}\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath("/subscribe"))))).asJava()).hasSizeGreaterThanOrEqualTo(1).allSatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void destroyShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldSucceed(server);
    }

    @Test
    default public void destroyShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + pushSubscription.id().value().toString() + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\"" + pushSubscription.id().value().toString() + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((Object)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id())).isNull();
    }

    public static /* synthetic */ void destroyShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldFailWhenInvalidId();
    }

    @Test
    default public void destroyShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldNotFailWhenUnknownId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldNotFailWhenUnknownId();
    }

    @Test
    default public void destroyShouldNotFailWhenUnknownId() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + id + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\":[\"" + id + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldHandleMixedCases$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldHandleMixedCases(server);
    }

    @Test
    default public void destroyShouldHandleMixedCases(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d087").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + pushSubscription1.id().value().toString() + "\", \"" + pushSubscription2.id().value().toString() + "\", \"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\n           |                    \"" + pushSubscription1.id().value().toString() + "\",\n           |                    \"" + pushSubscription2.id().value().toString() + "\"\n           |                ],\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static void $init$(PushSubscriptionSetMethodContract $this) {
    }
}

