/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.MessageIdProbe;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.MDNSendMethodContract$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0015r!B\u0013'\u0011\u0003\u0019d!B\u001b'\u0011\u00031\u0004\"B\u001f\u0002\t\u0003q\u0004bB \u0002\u0005\u0004%\t\u0001\u0011\u0005\u0007\t\u0006\u0001\u000b\u0011B!\u0007\u000fU2\u0003\u0013aA\u0001\u000b\")a)\u0002C\u0001\u000f\"A1*\u0002EC\u0002\u0013%A\n\u0003\u0005V\u000b!\u0015\r\u0011\"\u0003W\u0011!yV\u0001#b\u0001\n\u00131\u0006\"\u00021\u0006\t\u0013\t\u0007\"\u0002>\u0006\t\u0013Y\bbBA\n\u000b\u0011%\u0011Q\u0003\u0005\b\u0003_)a\u0011AA\u0019\u0011\u001d\t\u0019%\u0002C\u0001\u0003\u000bBq!a\u0018\u0006\t\u0003\t\t\u0007C\u0004\u0002n\u0015!\t!a\u001c\t\u000f\u0005UT\u0001\"\u0001\u0002x!9\u0011QP\u0003\u0005\u0002\u0005}\u0004bBAC\u000b\u0011\u0005\u0011q\u0011\u0005\b\u0003\u001b+A\u0011AAH\u0011\u001d\t)*\u0002C\u0001\u0003/Cq!!(\u0006\t\u0003\ty\nC\u0004\u0002&\u0016!\t!a*\t\u000f\u00055V\u0001\"\u0001\u00020\"9\u0011QW\u0003\u0005\u0002\u0005]\u0006bBA_\u000b\u0011\u0005\u0011q\u0018\u0005\b\u0003\u000b,A\u0011AAd\u0011\u001d\ti-\u0002C\u0001\u0003\u001fDq!!6\u0006\t\u0003\t9\u000eC\u0004\u0002^\u0016!\t!a8\t\u000f\u0005\u0015X\u0001\"\u0001\u0002h\"9\u0011Q^\u0003\u0005\u0002\u0005=\bbBA{\u000b\u0011\u0005\u0011q\u001f\u0005\b\u0005\u000f)A\u0011\u0001B\u0005\u0011\u001d\u0011\t\"\u0002C\u0001\u0005'AqAa\u0007\u0006\t\u0003\u0011i\"A\u000bN\t:\u001bVM\u001c3NKRDw\u000eZ\"p]R\u0014\u0018m\u0019;\u000b\u0005\u001dB\u0013\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005%R\u0013a\u0002:gGb2$'\r\u0006\u0003W1\nAA[7ba*\u0011QFL\u0001\u0006U\u0006lWm\u001d\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005Q\nQ\"\u0001\u0014\u0003+5#ejU3oI6+G\u000f[8e\u0007>tGO]1diN\u0011\u0011a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0014A\u0006+B\u000f~kEIT0N\u000bN\u001b\u0016iR#`\r>\u0013V*\u0011+\u0016\u0003\u0005{\u0011AQ\u0011\u0002\u0007\u0006\u0011R\n\u0012(`\u001b\u0016\u001b6+Q$F?\u001a{%+T!U\u0003]!\u0016iR0N\t:{V*R*T\u0003\u001e+uLR(S\u001b\u0006#\u0006e\u0005\u0002\u0006o\u00051A%\u001b8ji\u0012\"\u0012\u0001\u0013\t\u0003q%K!AS\u001d\u0003\tUs\u0017\u000e^\u0001\u0016g2|w\u000fU1dK\u0012\u0004v\u000e\u001c7J]R,'O^1m+\u0005i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011!\u0018.\\3\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\t\tV\u0014\u0018\r^5p]\u0006Y1-\u00197nYf\fu/Y5u+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011\u0019wN]3\u000b\u0005q\u0003\u0014AC1xC&$\u0018\u000e\\5us&\u0011a,\u0017\u0002\u0011\u0007>tG-\u001b;j_:4\u0015m\u0019;pef\fQ#Y<bSR\fE/T8tiR+gnU3d_:$7/\u0001\rhKR4\u0015N]:u\u001b\u0016\u001c8/Y4f\u0013:l\u0015-\u001b7C_b$2AY7t!\rA4-Z\u0005\u0003If\u0012aa\u00149uS>t\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\r!w.\u001c\u0006\u0003U2\na!\\5nKRR\u0017B\u00017h\u0005\u001diUm]:bO\u0016DQA\u001c\u0006A\u0002=\f\u0001cZ;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:\u0011\u0005A\fX\"\u0001\u0017\n\u0005Id#\u0001E$vS\u000e,'*Y7fgN+'O^3s\u0011\u0015!(\u00021\u0001v\u0003!)8/\u001a:oC6,\u0007C\u0001<y\u001b\u00059(B\u0001.-\u0013\tIxO\u0001\u0005Vg\u0016\u0014h.Y7f\u0003Q\u0011W/\u001b7e\u001fJLw-\u001b8bY6+7o]1hKR\u0011Q\r \u0005\u0006{.\u0001\rA`\u0001\u0004i\u0006<\u0007cA@\u0002\u000e9!\u0011\u0011AA\u0005!\r\t\u0019!O\u0007\u0003\u0003\u000bQ1!a\u00023\u0003\u0019a$o\\8u}%\u0019\u00111B\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tY!O\u0001\u001dEVLG\u000e\u001a\"P\u0005J+\u0017/^3tiN\u0003XmY5gS\u000e\fG/[8o)\u0011\t9\"a\u000b\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005i1\u000f]3dS\u001aL7-\u0019;j_:TA!!\t\u0002$\u0005Y!/Z:uCN\u001cXO]3e\u0015\t\t)#\u0001\u0002j_&!\u0011\u0011FA\u000e\u0005Q\u0011V-];fgR\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\"1\u0011Q\u0006\u0007A\u0002=\faa]3sm\u0016\u0014\u0018a\u0004:b]\u0012|W.T3tg\u0006<W-\u00133\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003{a\u0013aB7bS2\u0014w\u000e_\u0005\u0005\u0003\u0003\n9DA\u0005NKN\u001c\u0018mZ3JI\u0006)1/\u001a;VaR\u0019\u0001*a\u0012\t\r\u00055b\u00021\u0001pQ\rq\u00111\n\t\u0005\u0003\u001b\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\r\t\u0007/\u001b\u0006\u0005\u0003+\n9&A\u0004kkBLG/\u001a:\u000b\u0007\u0005e\u0003'A\u0003kk:LG/\u0003\u0003\u0002^\u0005=#A\u0003\"fM>\u0014X-R1dQ\u0006iS\u000e\u001a8TK:$7\u000b[8vY\u0012\u0014UmU;dG\u0016\u001c8/\u00118e'\u0016tG-T1jYN+8mY3tg\u001a,H\u000e\\=\u0015\u0007!\u000b\u0019\u0007\u0003\u0004\u0002.=\u0001\ra\u001c\u0015\u0004\u001f\u0005\u001d\u0004\u0003BA'\u0003SJA!a\u001b\u0002P\t!A+Z:u\u0003UjGM\\*f]\u0012\u001c\u0006n\\;mI\n+7+^2dKN\u001cx\u000b[3o%\u0016\fX/Z:u\u0003N\u001c\u0018n\u001a8GS:\fGNU3dSBLWM\u001c;\u0015\u0007!\u000b\t\b\u0003\u0004\u0002.A\u0001\ra\u001c\u0015\u0004!\u0005\u001d\u0014aM7e]N+g\u000eZ*i_VdGMQ3GC&dw\u000b[3o\t&\u001c\bo\\:ji&|g\u000e\u0015:pa\u0016\u0014H/_%t\u0013:4\u0018\r\\5e)\rA\u0015\u0011\u0010\u0005\u0007\u0003[\t\u0002\u0019A8)\u0007E\t9'\u0001\u0018nI:\u001cVM\u001c3TQ>,H\u000e\u001a\"f\r\u0006LGn\u00165f]\u001aKg.\u00197SK\u000eL\u0007/[3oi&\u001b\u0018J\u001c<bY&$Gc\u0001%\u0002\u0002\"1\u0011Q\u0006\nA\u0002=D3AEA4\u0003yjGM\\*f]\u0012\u001c\u0006n\\;mI\n+g)Y5m/\",g.\u00133f]RLG/_%t\u001d>$\u0018\t\u001c7po\u0016$Gk\\+tK\u001aKg.\u00197SK\u000eL\u0007/[3oiR\u0019\u0001*!#\t\r\u000552\u00031\u0001pQ\r\u0019\u0012qM\u00015S6\u0004H.[2ji\u0016k\u0017-\u001b7TKR\u001c\u0006n\\;mI:{GOQ3BiR,W\u000e\u001d;fI^CWM\\'E\u001d&\u001bhj\u001c;TK:$Hc\u0001%\u0002\u0012\"1\u0011Q\u0006\u000bA\u0002=D3\u0001FA4\u0003\tKW\u000e\u001d7jG&$X)\\1jYN+Go\u00155pk2$gj\u001c;CK\u0006#H/Z7qi\u0016$w\u000b[3o\u001f:\u001cVoY2fgN,\u0006\u000fZ1uK\u0016k\u0017-\u001b7Jg:+H\u000e\u001c\u000b\u0004\u0011\u0006e\u0005BBA\u0017+\u0001\u0007q\u000eK\u0002\u0016\u0003O\nA%\u001c3o'\u0016tGm\u00155pk2$\u0017iY2faR\u001cVM^3sC2lEIT(cU\u0016\u001cGo\u001d\u000b\u0004\u0011\u0006\u0005\u0006BBA\u0017-\u0001\u0007q\u000eK\u0002\u0017\u0003O\nA%\u001c3o'\u0016tG-T5y-\u0006d\u0017\u000eZ!oI:{GOR8v]\u0012\fe\u000eZ%om\u0006d\u0017\u000e\u001a\u000b\u0004\u0011\u0006%\u0006BBA\u0017/\u0001\u0007q\u000eK\u0002\u0018\u0003O\n1&\u001c3o'\u0016tGm\u00155pk2$')\u001a$bS2<\u0006.\u001a8N\t:C\u0015m]!me\u0016\fG-\u001f\"fK:\u001cV\r\u001e\u000b\u0004\u0011\u0006E\u0006BBA\u00171\u0001\u0007q\u000eK\u0002\u0019\u0003O\n\u0001(\u001c3o'\u0016tGm\u00155pk2$'+\u001a;ve:,fn\u001b8po:lU\r\u001e5pI^CWM\\'jgNLgnZ(oK\u000e\u000b\u0007/\u00192jY&$\u0018\u0010F\u0002I\u0003sCa!!\f\u001a\u0001\u0004y\u0007fA\r\u0002h\u0005QT\u000e\u001a8TK:$7\u000b[8vY\u0012\u0014V\r^;s]Vs7N\\8x]6+G\u000f[8e/\",g.T5tg&tw-\u00117m\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u000b\u0004\u0011\u0006\u0005\u0007BBA\u00175\u0001\u0007q\u000eK\u0002\u001b\u0003O\n1'\u001c3o'\u0016tGm\u00155pk2$'+\u001a;ve:tu\u000e\u001e$pk:$w\u000b[3o\r>\u0014X)\\1jY&#\u0017j\u001d(pi\u0016C\u0018n\u001d;\u0015\u0007!\u000bI\r\u0003\u0004\u0002.m\u0001\ra\u001c\u0015\u00047\u0005\u001d\u0014aS7e]N+g\u000eZ*i_VdGMU3ukJtgj\u001c;G_VtGm\u00165f]6+7o]1hKJ+G.\u0019;f\u0011\u0006\u001chj\u001c;ESN\u0004xn]5uS>tgj\u001c;jM&\u001c\u0017\r^5p]R{Gc\u0001%\u0002R\"1\u0011Q\u0006\u000fA\u0002=D3\u0001HA4\u0003IjGM\\*f]\u0012\u001c\u0006n\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e/\",g.\u00133f]RLG/\u001f#pKNtu\u000e^#ySN$Hc\u0001%\u0002Z\"1\u0011QF\u000fA\u0002=D3!HA4\u0003\u0015jGM\\*f]\u0012\u001c\u0006n\\;mI\n+g)Y5m/\",gn\u0016:p]\u001e\f5mY8v]RLE\rF\u0002I\u0003CDa!!\f\u001f\u0001\u0004y\u0007f\u0001\u0010\u0002h\u0005\u0019U\u000e\u001a8TK:$7\u000b[8vY\u0012\u0014UMR1jY^CWM\\(o'V\u001c7-Z:t+B$\u0017\r^3F[\u0006LG.T5tg\u0016\u001cH\u000b[3De\u0016\fG/[8o\u0013\u0012\u001c\u0006.\u0019:q)\rA\u0015\u0011\u001e\u0005\u0007\u0003[y\u0002\u0019A8)\u0007}\t9'\u0001*nI:\u001cVM\u001c3TQ>,H\u000e\u001a\"f\r\u0006LGn\u00165f]>s7+^2dKN\u001cX\u000b\u001d3bi\u0016,U.Y5m\t>,7OT8u%\u00164WM]3oG\u0016\f5I]3bi&|gnV5uQ&tG\u000b[5t\u0007\u0006dG\u000eF\u0002I\u0003cDa!!\f!\u0001\u0004y\u0007f\u0001\u0011\u0002h\u0005iS\u000e\u001a8TK:$7\u000b[8vY\u0012\u0014V\r^;s]N+(M[3di^CWM\u001c*fcV,7\u000f\u001e#p\u001d>$8+\u001a;\u0015\u0007!\u000bI\u0010\u0003\u0004\u0002.\u0005\u0002\ra\u001c\u0015\u0007C\u0005u(1\u0001\"\u0011\t\u00055\u0013q`\u0005\u0005\u0005\u0003\tyEA\u0002UC\u001e\fQA^1mk\u0016D3!IA4\u00039jGM\\*f]\u0012\u001c\u0006n\\;mIJ+G/\u001e:o)\u0016DHOQ8es^CWM\u001c*fcV,7\u000f\u001e#p\u001d>$8+\u001a;\u0015\u0007!\u0013Y\u0001\u0003\u0004\u0002.\t\u0002\ra\u001c\u0015\u0007E\u0005u(1\u0001\")\u0007\t\n9'\u0001%nI:\u001cVM\u001c3TQ>,H\u000e\u001a*fiV\u0014hn\u0014:jO&t\u0017\r\\'fgN\fw-Z%e/\",gNU3mCR,G-T3tg\u0006<W\rS1t\u001b\u0016\u001c8/Y4f\u0013\u0012CU-\u00193feR\u0019\u0001J!\u0006\t\r\u000552\u00051\u0001pQ\u0019\u0019\u0013Q B\u0002\u0005\"\u001a1%a\u001a\u0002\u00016$g.T3tg\u0006<Wm\u00155pk2$\u0007*Y:UQ&\u0014HMQ8esB\u000b'\u000f^,iK:Len\u00197vI\u0016|%/[4j]\u0006dW*Z:tC\u001e,\u0017j\u001d+sk\u0016$2\u0001\u0013B\u0010\u0011\u0019\ti\u0003\na\u0001_\"2A%!@\u0003\u0004\tC3\u0001JA4\u0001")
public interface MDNSendMethodContract {
    public static String TAG_MDN_MESSAGE_FORMAT() {
        return MDNSendMethodContract$.MODULE$.TAG_MDN_MESSAGE_FORMAT();
    }

    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$slowPacedPollInterval$(MDNSendMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$calmlyAwait$(MDNSendMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$awaitAtMostTenSeconds$(MDNSendMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    private Option<Message> getFirstMessageInMailBox(GuiceJamesServer guiceJamesServer, Username username) {
        MultimailboxesSearchQuery searchByRFC822MessageId = MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()})).build();
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return CollectionConverters$.MODULE$.CollectionHasAsScala(((MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class)).searchMessage(searchByRFC822MessageId, username.asString(), 100L)).asScala().headOption().flatMap((Function1 & Serializable)messageId -> CollectionConverters$.MODULE$.ListHasAsScala(((MessageIdProbe)guiceJamesServer.getProbe(MessageIdProbe.class)).getMessages(messageId, username)).asScala().headOption()).map((Function1 & Serializable)messageResult -> defaultMessageBuilder.parseMessage(messageResult.getFullContent().getInputStream()));
    }

    private Message buildOriginalMessage(String tag) {
        return Message.Builder.of().setSubject("Subject of original message" + tag).setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).addField((Field)new RawField("Disposition-Notification-To", "Bob <" + Fixture$.MODULE$.BOB().asString() + ">")).setBody("Body of mail" + tag + ", that mdn related", StandardCharsets.UTF_8).build();
    }

    private RequestSpecification buildBOBRequestSpecification(GuiceJamesServer server) {
        return Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void setUp$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).addUser(Fixture$.MODULE$.DAVID().asString(), Fixture$.MODULE$.DAVID().asString());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public static /* synthetic */ void mdnSendShouldBeSuccessAndSendMailSuccessfully$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeSuccessAndSendMailSuccessfully(server);
    }

    @Test
    default public void mdnSendShouldBeSuccessAndSendMailSuccessfully(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId bobInboxId = mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            },\n         |            \"extensionFields\": {\n         |              \"X-EXTENSION-EXAMPLE\": \"example.com\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).whenIgnoringPaths(new String[]{"methodResponses[1][1].newState", "methodResponses[1][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"MDN/send\",\n           |            {\n           |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |                \"sent\": {\n           |                    \"k1546\": {\n           |                        \"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |                        \"includeOriginalMessage\": false,\n           |                        \"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ],\n           |        [\n           |            \"Email/set\",\n           |            {\n           |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |                \"oldState\": \"23\",\n           |                \"newState\": \"42\",\n           |                \"updated\": {\n           |                    \"" + relatedEmailId.serialize() + "\": null\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        String requestQueryMDNMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\": {\"inMailbox\": \"" + bobInboxId.serialize() + "\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(requestQueryMDNMessage).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].ids").isArray().hasSize(1);
        });
    }

    public static /* synthetic */ void mdnSendShouldBeSuccessWhenRequestAssignFinalRecipient$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeSuccessWhenRequestAssignFinalRecipient(server);
    }

    @Test
    default public void mdnSendShouldBeSuccessWhenRequestAssignFinalRecipient(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("david", "domain.tld", "andre@domain.tld");
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).whenIgnoringPaths(new String[]{"methodResponses[1][1].newState", "methodResponses[1][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"MDN/send\",\n           |            {\n           |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |                \"sent\": {\n           |                    \"k1546\": {\n           |                        \"includeOriginalMessage\": false,\n           |                        \"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ],\n           |        [\n           |            \"Email/set\",\n           |            {\n           |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |                \"oldState\": \"23\",\n           |                \"newState\": \"42\",\n           |                \"updated\": {\n           |                    \"" + relatedEmailId.serialize() + "\": null\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenDispositionPropertyIsInvalid$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenDispositionPropertyIsInvalid(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenDispositionPropertyIsInvalid(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"disposition\": {\n         |              \"actionMode\": \"invalidAction\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"k1546\": {\n                   |        \"type\": \"invalidArguments\",\n                   |        \"description\": \"Disposition \\\"ActionMode\\\" is invalid.\",\n                   |        \"properties\":[\"disposition\"]\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenFinalRecipientIsInvalid$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenFinalRecipientIsInvalid(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenFinalRecipientIsInvalid(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"finalRecipient\" : \"invalid\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"k1546\": {\n                   |        \"type\": \"invalidArguments\",\n                   |        \"description\": \"FinalRecipient can't be parse.\",\n                   |        \"properties\": [\n                   |            \"finalRecipient\"\n                   |        ]\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenIdentityIsNotAllowedToUseFinalRecipient$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenIdentityIsNotAllowedToUseFinalRecipient(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenIdentityIsNotAllowedToUseFinalRecipient(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"finalRecipient\" : \"rfc822; " + Fixture$.MODULE$.CEDRIC().asString() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"k1546\": {\n                   |        \"type\": \"forbiddenFrom\",\n                   |        \"description\": \"The user is not allowed to use the given \\\"finalRecipient\\\" property\"\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void implicitEmailSetShouldNotBeAttemptedWhenMDNIsNotSent$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.implicitEmailSetShouldNotBeAttemptedWhenMDNIsNotSent(server);
    }

    @Test
    default public void implicitEmailSetShouldNotBeAttemptedWhenMDNIsNotSent(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"finalRecipient\" : \"invalid\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[1]").isAbsent();
    }

    public static /* synthetic */ void implicitEmailSetShouldNotBeAttemptedWhenOnSuccessUpdateEmailIsNull$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.implicitEmailSetShouldNotBeAttemptedWhenOnSuccessUpdateEmailIsNull(server);
    }

    @Test
    default public void implicitEmailSetShouldNotBeAttemptedWhenOnSuccessUpdateEmailIsNull(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).whenIgnoringPaths(new String[]{"methodResponses[1][1].newState", "methodResponses[1][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"MDN/send\",\n           |            {\n           |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |                \"sent\": {\n           |                    \"k1546\": {\n           |                        \"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |                        \"includeOriginalMessage\": false,\n           |                        \"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void mdnSendShouldAcceptSeveralMDNObjects$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldAcceptSeveralMDNObjects(server);
    }

    @Test
    default public void mdnSendShouldAcceptSeveralMDNObjects(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        MessageId relatedEmailId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("2"))).getMessageId();
        MessageId relatedEmailId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("3"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId1.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          },\n         |          \"k1547\": {\n         |            \"forEmailId\": \"" + relatedEmailId2.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          },\n         |          \"k1548\": {\n         |            \"forEmailId\": \"" + relatedEmailId3.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          },\n         |          \"#k1547\": {\n         |            \"keywords/$mdnsent\": true\n         |          },\n         |          \"#k1548\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).whenIgnoringPaths(new String[]{"methodResponses[1][1].newState", "methodResponses[1][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"MDN/send\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |\t\t\t\t\"sent\": {\n           |\t\t\t\t\t\"k1546\": {\n           |\t\t\t\t\t\t\"subject\": \"[Received] Subject of original message1\",\n           |\t\t\t\t\t\t\"textBody\": \"The email has been displayed on your recipient's computer\",\n           |\t\t\t\t\t\t\"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"includeOriginalMessage\": false\n           |\t\t\t\t\t},\n           |\t\t\t\t\t\"k1547\": {\n           |\t\t\t\t\t\t\"subject\": \"[Received] Subject of original message2\",\n           |\t\t\t\t\t\t\"textBody\": \"The email has been displayed on your recipient's computer\",\n           |\t\t\t\t\t\t\"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"includeOriginalMessage\": false\n           |\t\t\t\t\t},\n           |\t\t\t\t\t\"k1548\": {\n           |\t\t\t\t\t\t\"subject\": \"[Received] Subject of original message3\",\n           |\t\t\t\t\t\t\"textBody\": \"The email has been displayed on your recipient's computer\",\n           |\t\t\t\t\t\t\"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n           |\t\t\t\t\t\t\"includeOriginalMessage\": false\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t],\n           |\t\t[\n           |\t\t\t\"Email/set\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |\t\t\t\t\"oldState\": \"3be4a1bc-0b41-4e33-aaf0-585e567a5af5\",\n           |\t\t\t\t\"newState\": \"3e1d5c70-9ca4-4c02-a35c-f54a51d253e3\",\n           |\t\t\t\t\"updated\": {\n           |\t\t\t\t\t\"" + relatedEmailId1.serialize() + "\": null,\n           |\t\t\t\t\t\"" + relatedEmailId2.serialize() + "\": null,\n           |\t\t\t\t\t\"" + relatedEmailId3.serialize() + "\": null\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void mdnSendMixValidAndNotFoundAndInvalid$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendMixValidAndNotFoundAndInvalid(server);
    }

    @Test
    default public void mdnSendMixValidAndNotFoundAndInvalid(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId validEmailId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        MessageId validEmailId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("2"))).getMessageId();
        String serializedRandomId = this.randomMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + validEmailId1.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          },\n         |          \"k1547\": {\n         |            \"forEmailId\": \"" + validEmailId2.serialize() + "\",\n         |            \"badProperty\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          },\n         |          \"k1548\": {\n         |            \"forEmailId\": \"" + serializedRandomId + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          },\n         |          \"#k1547\": {\n         |            \"keywords/$mdnsent\": true\n         |          },\n         |          \"#k1548\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).whenIgnoringPaths(new String[]{"methodResponses[1][1].newState", "methodResponses[1][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n                   |    \"methodResponses\": [\n                   |        [\n                   |            \"MDN/send\",\n                   |            {\n                   |                \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n                   |                \"sent\": {\n                   |                    \"k1546\": {\n                   |                        \"subject\": \"[Received] Subject of original message1\",\n                   |                        \"textBody\": \"The email has been displayed on your recipient's computer\",\n                   |                        \"originalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n                   |                        \"finalRecipient\": \"rfc822; " + Fixture$.MODULE$.ANDRE().asString() + "\",\n                   |                        \"includeOriginalMessage\": false\n                   |                    }\n                   |                },\n                   |                \"notSent\": {\n                   |                    \"k1547\": {\n                   |                        \"type\": \"invalidArguments\",\n                   |                        \"description\": \"Some unknown properties were specified\",\n                   |                        \"properties\": [\n                   |                            \"badProperty\"\n                   |                        ]\n                   |                    },\n                   |                    \"k1548\": {\n                   |                        \"type\": \"notFound\",\n                   |                        \"description\": \"The reference \\\"forEmailId\\\" " + serializedRandomId + " cannot be found for user andre@domain.tld.\"\n                   |                    }\n                   |                }\n                   |            },\n                   |            \"c1\"\n                   |        ],\n                   |        [\n                   |            \"Email/set\",\n                   |            {\n                   |                \"accountId\": \"1e8584548eca20f26faf6becc1704a0f352839f12c208a47fbd486d60f491f7c\",\n                   |                \"oldState\": \"eda83b09-6aca-4215-b493-2b4af19c50f0\",\n                   |                \"newState\": \"8bd671b2-e9fd-4ce3-b9b2-c3e1f35cc8ee\",\n                   |                \"updated\": {\n                   |                    \"" + validEmailId1.serialize() + "\": null\n                   |                }\n                   |            },\n                   |            \"c1\"\n                   |        ]\n                   |    ]\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenMDNHasAlreadyBeenSet$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenMDNHasAlreadyBeenSet(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenMDNHasAlreadyBeenSet(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON);
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"k1546\": {\n                   |        \"type\": \"mdnAlreadySent\",\n                   |        \"description\": \"The message has the $mdnsent keyword already set.\"\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnUnknownMethodWhenMissingOneCapability$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnUnknownMethodWhenMissingOneCapability(server);
    }

    @Test
    default public void mdnSendShouldReturnUnknownMethodWhenMissingOneCapability(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"ue150411c\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"Md45b47b4877521042cec0938\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mdn\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnUnknownMethodWhenMissingAllCapabilities$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnUnknownMethodWhenMissingAllCapabilities(server);
    }

    @Test
    default public void mdnSendShouldReturnUnknownMethodWhenMissingAllCapabilities(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"ue150411c\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"Md45b47b4877521042cec0938\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mdn, urn:ietf:params:jmap:mail, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnNotFoundWhenForEmailIdIsNotExist$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnNotFoundWhenForEmailIdIsNotExist(server);
    }

    @Test
    default public void mdnSendShouldReturnNotFoundWhenForEmailIdIsNotExist(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId randomMessageId1 = this.randomMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + randomMessageId1.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"k1546\": {\n                   |        \"type\": \"notFound\",\n                   |        \"description\": \"The reference \\\"forEmailId\\\" " + randomMessageId1.serialize() + " cannot be found for user bob@domain.tld.\"\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnNotFoundWhenMessageRelateHasNotDispositionNotificationTo$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnNotFoundWhenMessageRelateHasNotDispositionNotificationTo(server);
    }

    @Test
    default public void mdnSendShouldReturnNotFoundWhenMessageRelateHasNotDispositionNotificationTo(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).setBody("Body of mail, that mdn related", StandardCharsets.UTF_8).build();
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(message)).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].notSent").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                    |    \"k1546\": {\n                    |        \"type\": \"notFound\",\n                    |        \"description\": \"Invalid \\\"Disposition-Notification-To\\\" header field.\"\n                    |    }\n                    |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnInvalidWhenIdentityDoesNotExist$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnInvalidWhenIdentityDoesNotExist(server);
    }

    @Test
    default public void mdnSendShouldReturnInvalidWhenIdentityDoesNotExist(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).setBody("Body of mail, that mdn related", StandardCharsets.UTF_8).build();
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(message)).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"notFound\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n                   |    \"methodResponses\": [\n                   |        [\n                   |            \"error\",\n                   |            {\n                   |                \"type\": \"invalidArguments\",\n                   |                \"description\": \"The IdentityId cannot be found\"\n                   |            },\n                   |            \"c1\"\n                   |        ]\n                   |    ]\n                   |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenWrongAccountId$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenWrongAccountId(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenWrongAccountId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"unknownAccountId\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [[\n         |            \"error\",\n         |            {\n         |                \"type\": \"accountNotFound\"\n         |            },\n         |            \"c1\"\n         |        ]]\n         |}")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenOnSuccessUpdateEmailMissesTheCreationIdSharp$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenOnSuccessUpdateEmailMissesTheCreationIdSharp(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenOnSuccessUpdateEmailMissesTheCreationIdSharp(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"notStored\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |    \"error\",\n           |    {\n           |        \"type\": \"invalidArguments\",\n           |        \"description\": \"notStored cannot be retrieved as storage for MDNSend is not yet implemented\"\n           |    },\n           |    \"c1\"\n           |]")));
    }

    public static /* synthetic */ void mdnSendShouldBeFailWhenOnSuccessUpdateEmailDoesNotReferenceACreationWithinThisCall$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldBeFailWhenOnSuccessUpdateEmailDoesNotReferenceACreationWithinThisCall(server);
    }

    @Test
    default public void mdnSendShouldBeFailWhenOnSuccessUpdateEmailDoesNotReferenceACreationWithinThisCall(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#notReference\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)this.buildBOBRequestSpecification(server)).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"#notReference cannot be referenced in current method call\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void mdnSendShouldReturnSubjectWhenRequestDoNotSet$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnSubjectWhenRequestDoNotSet(server);
    }

    @Tag(value="MDN_MESSAGE_FORMAT")
    @Test
    default public void mdnSendShouldReturnSubjectWhenRequestDoNotSet(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].sent.k1546.subject").asString().isEqualTo("[Received] Subject of original message1");
    }

    public static /* synthetic */ void mdnSendShouldReturnTextBodyWhenRequestDoNotSet$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnTextBodyWhenRequestDoNotSet(server);
    }

    @Tag(value="MDN_MESSAGE_FORMAT")
    @Test
    default public void mdnSendShouldReturnTextBodyWhenRequestDoNotSet(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].sent.k1546.textBody").asString().isEqualTo("The email has been displayed on your recipient's computer");
    }

    public static /* synthetic */ void mdnSendShouldReturnOriginalMessageIdWhenRelatedMessageHasMessageIDHeader$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnSendShouldReturnOriginalMessageIdWhenRelatedMessageHasMessageIDHeader(server);
    }

    @Tag(value="MDN_MESSAGE_FORMAT")
    @Test
    default public void mdnSendShouldReturnOriginalMessageIdWhenRelatedMessageHasMessageIDHeader(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Subject of original message").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).addField((Field)new RawField("Disposition-Notification-To", "Bob <" + Fixture$.MODULE$.BOB().asString() + ">")).addField((Field)new RawField("Message-Id", "<199509192301.23456@example.org>")).setBody("Body of mail, that mdn related", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        String mdnSendResponse = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)mdnSendResponse).inPath("methodResponses[0][1].sent.k1546.originalMessageId").asString().isEqualTo("<199509192301.23456@example.org>");
    }

    public static /* synthetic */ void mdnMessageShouldHasThirdBodyPartWhenIncludeOriginalMessageIsTrue$(MDNSendMethodContract $this, GuiceJamesServer server) {
        $this.mdnMessageShouldHasThirdBodyPartWhenIncludeOriginalMessageIsTrue(server);
    }

    @Tag(value="MDN_MESSAGE_FORMAT")
    @Test
    default public void mdnMessageShouldHasThirdBodyPartWhenIncludeOriginalMessageIsTrue(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath bobMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        mailboxProbe.createMailbox(bobMailBoxPath);
        MailboxPath andreMailBoxPath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        mailboxProbe.createMailbox(andreMailBoxPath);
        MessageId relatedEmailId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), andreMailBoxPath, MessageManager.AppendCommand.builder().build(this.buildOriginalMessage("1"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:mdn\"\n         |  ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"MDN/send\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |        \"identityId\": \"" + Fixture$.MODULE$.ANDRE_IDENTITY_ID() + "\",\n         |        \"send\": {\n         |          \"k1546\": {\n         |            \"forEmailId\": \"" + relatedEmailId.serialize() + "\",\n         |            \"subject\": \"Read receipt for: World domination\",\n         |            \"textBody\": \"This receipt shows that the email has been displayed on your recipient's computer. \",\n         |            \"reportingUA\": \"joes-pc.cs.example.com; Foomail 97.1\",\n         |            \"disposition\": {\n         |              \"actionMode\": \"manual-action\",\n         |              \"sendingMode\": \"mdn-sent-manually\",\n         |              \"type\": \"displayed\"\n         |            },\n         |            \"includeOriginalMessage\": true,\n         |            \"extensionFields\": {\n         |              \"X-EXTENSION-EXAMPLE\": \"example.com\"\n         |            }\n         |          }\n         |        },\n         |        \"onSuccessUpdateEmail\": {\n         |          \"#k1546\": {\n         |            \"keywords/$mdnsent\": true\n         |          }\n         |        }\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        this.org$apache$james$jmap$rfc8621$contract$MDNSendMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Option mdnBodyPartCounter = this.getFirstMessageInMailBox(server, Fixture$.MODULE$.BOB()).filter((Function1 & Serializable)msg -> BoxesRunTime.boxToBoolean((boolean)msg.isMultipart())).map((Function1 & Serializable)msg -> ((Multipart)msg.getBody()).getBodyParts());
            Predef$.MODULE$.assert(mdnBodyPartCounter.isDefined() && ((List)mdnBodyPartCounter.get()).size() == 3);
        });
    }

    public static void $init$(MDNSendMethodContract $this) {
    }
}

