/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityCreationRequest$;
import org.apache.james.jmap.api.identity.IdentityHtmlSignatureUpdate;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest$;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.EmailerName;
import org.apache.james.jmap.api.model.HtmlSignature;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.IdentityName;
import org.apache.james.jmap.api.model.TextSignature;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.IdentityProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\r4qa\u0004\t\u0011\u0002\u0007\u0005Q\u0004C\u0003%\u0001\u0011\u0005Q\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003=\u0001\u0011\u0005Q\u0005C\u0003B\u0001\u0011\u0005!\tC\u0003F\u0001\u0011\u0005a\tC\u0003J\u0001\u0011\u0005!\nC\u0003N\u0001\u0011\u0005a\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003V\u0001\u0011\u0005Q\u0005C\u0003X\u0001\u0011\u0005Q\u0005C\u0003Z\u0001\u0011\u0005Q\u0005C\u0003\\\u0001\u0011\u0005Q\u0005C\u0003^\u0001\u0011\u0005Q\u0005C\u0003`\u0001\u0011\u0005\u0001MA\nJI\u0016tG/\u001b;z\u000f\u0016$8i\u001c8ue\u0006\u001cGO\u0003\u0002\u0012%\u0005A1m\u001c8ue\u0006\u001cGO\u0003\u0002\u0014)\u00059!OZ29mI\n$BA\u000b\u0017\u0003\u0011QW.\u00199\u000b\u0005]A\u0012!\u00026b[\u0016\u001c(BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0014\u0011\u0005}9\u0013B\u0001\u0015!\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005\u0019Z\u0003\"\u0002\u0017\u0003\u0001\u0004i\u0013AB:feZ,'\u000f\u0005\u0002/_5\ta#\u0003\u00021-\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0005I\u0002\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u00028q\u00059!.\u001e9ji\u0016\u0014(BA\u001d\u001b\u0003\u0015QWO\\5u\u0013\tYDG\u0001\u0006CK\u001a|'/Z#bG\"\faeZ3u\u0013\u0012,g\u000e^5usNCw.\u001e7e%\u0016$XO\u001d8EK\u001a\fW\u000f\u001c;JI\u0016tG/\u001b;zQ\t\u0019a\b\u0005\u00024\u007f%\u0011\u0001\t\u000e\u0002\u0005)\u0016\u001cH/A\u0013hKRLE-\u001a8uSRL8\u000b[8vY\u0012\u0014V\r^;s]\u000e+8\u000f^8n\u0013\u0012,g\u000e^5usR\u0011ae\u0011\u0005\u0006Y\u0011\u0001\r!\f\u0015\u0003\ty\nadZ3u\u0013\u0012,g\u000e^5usNCw.\u001e7e%\u0016$XO\u001d8BY&\f7/Z:\u0015\u0005\u0019:\u0005\"\u0002\u0017\u0006\u0001\u0004i\u0003FA\u0003?\u0003\u0001:W\r^%eK:$\u0018\u000e^=TQ>,H\u000eZ*vaB|'\u000f^%eg\u001aKW\r\u001c3\u0015\u0005\u0019Z\u0005\"\u0002\u0017\u0007\u0001\u0004i\u0003F\u0001\u0004?\u0003\u0011:W\r^%eK:$\u0018\u000e^=TQ>,H\u000e\u001a*fiV\u0014h\u000eR8nC&t\u0017\t\\5bg\u0016\u001cHC\u0001\u0014P\u0011\u0015as\u00011\u0001.Q\t9a(\u0001\u0011hKRLE-\u001a8uSRL8\u000b[8vY\u0012\u0014V\r^;s]N{'\u000f^(sI\u0016\u0014HC\u0001\u0014T\u0011\u0015a\u0003\u00021\u0001.Q\tAa(A\u000eqe>\u0004XM\u001d;jKN\u001c\u0006n\\;mI\n+7+\u001e9q_J$X\r\u001a\u0015\u0003\u0013y\n!\u0004\u001d:pa\u0016\u0014H/[3t'\"|W\u000f\u001c3CK\u001aKG\u000e^3sK\u0012D#A\u0003 \u0002;\t\fG\r\u0015:pa\u0016\u0014H/[3t'\"|W\u000f\u001c3CKJ+'.Z2uK\u0012D#a\u0003 \u00029\t\fG-Q2d_VtG/\u00133TQ>,H\u000e\u001a\"f%\u0016TWm\u0019;fI\"\u0012ABP\u0001\u0019O\u0016$(+\u00198e_6LEm\u00155pk2$gj\u001c;GC&d\u0007FA\u0007?\u0003Uj\u0017-\u001f#fY\u0016$Xm\u00155pk2$'+\u001a;ve:4\u0015\r\\:f/\",g.\u00169eCR,7+\u001a:wKJ\u001cV\r^%eK:$\u0018\u000e^=\u0015\u0005\u0019\n\u0007\"\u0002\u0017\u000f\u0001\u0004i\u0003F\u0001\b?\u0001")
public interface IdentityGetContract {
    public static /* synthetic */ void setUp$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void getIdentityShouldReturnDefaultIdentity$(IdentityGetContract $this) {
        $this.getIdentityShouldReturnDefaultIdentity();
    }

    @Test
    default public void getIdentityShouldReturnDefaultIdentity() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |  \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n        |  \"list\": [\n        |      {\n        |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |          \"name\": \"bob@domain.tld\",\n        |          \"email\": \"bob@domain.tld\",\n        |          \"mayDelete\": false,\n        |          \"textSignature\":\"\",\n        |          \"htmlSignature\":\"\"\n        |      }\n        |  ]\n        |}")));
    }

    public static /* synthetic */ void getIdentityShouldReturnCustomIdentity$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnCustomIdentity(server);
    }

    @Test
    default public void getIdentityShouldReturnCustomIdentity(GuiceJamesServer server) {
        Some x$1 = new Some((Object)new IdentityName("Bob (custom address)"));
        MailAddress x$2 = Fixture$.MODULE$.BOB().asMailAddress();
        Some x$3 = new Some((Object)new .colon.colon((Object)new EmailAddress((Option)new Some((Object)new EmailerName("My Boss")), new MailAddress("boss@domain.tld")), (List)Nil$.MODULE$));
        Some x$4 = new Some((Object)new .colon.colon((Object)new EmailAddress((Option)new Some((Object)new EmailerName("My Boss 2")), new MailAddress("boss2@domain.tld")), (List)Nil$.MODULE$));
        Some x$5 = new Some((Object)new TextSignature("text signature"));
        Some x$6 = new Some((Object)new HtmlSignature("html signature"));
        Option x$7 = IdentityCreationRequest$.MODULE$.apply$default$5();
        boolean x$8 = IdentityCreationRequest$.MODULE$.apply$default$8();
        SMono qual$1 = SMono$.MODULE$.apply(((IdentityProbe)server.getProbe(IdentityProbe.class)).save(Fixture$.MODULE$.BOB(), new IdentityCreationRequest((Option)x$1, x$2, (Option)x$3, (Option)x$4, x$7, (Option)x$5, (Option)x$6, x$8)));
        Duration x$9 = qual$1.block$default$1();
        String id = ((Identity)qual$1.block(x$9)).id().id().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + id + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"bcc\": [{\n         |\t\t\"email\": \"boss2@domain.tld\",\n         |\t\t\"name\": \"My Boss 2\"\n         |\t}],\n         |\t\"email\": \"bob@domain.tld\",\n         |\t\"htmlSignature\": \"html signature\",\n         |\t\"id\": \"" + id + "\",\n         |\t\"mayDelete\": true,\n         |\t\"name\": \"Bob (custom address)\",\n         |\t\"replyTo\": [{\n         |\t\t\"email\": \"boss@domain.tld\",\n         |\t\t\"name\": \"My Boss\"\n         |\t}],\n         |\t\"textSignature\": \"text signature\"\n         |}")));
    }

    public static /* synthetic */ void getIdentityShouldReturnAliases$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnAliases(server);
    }

    @Test
    default public void getIdentityShouldReturnAliases(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(net.javacrumbs.jsonunit.core.Option.IGNORING_ARRAY_ORDER, new net.javacrumbs.jsonunit.core.Option[0]).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |            \"name\": \"bob@domain.tld\",\n        |            \"email\": \"bob@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ]\n        |}")));
    }

    public static /* synthetic */ void getIdentityShouldSupportIdsField$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldSupportIdsField(server);
    }

    @Test
    default public void getIdentityShouldSupportIdsField(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"idNotFound\", \"3739a34e-cd8c-3a42-bf28-578ba24da9da\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ],\n        |    \"notFound\": [\"idNotFound\"]\n        |}")));
    }

    public static /* synthetic */ void getIdentityShouldReturnDomainAliases$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnDomainAliases(server);
    }

    @Test
    default public void getIdentityShouldReturnDomainAliases(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addDomainAliasMapping("domain-alias.tld", "domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(net.javacrumbs.jsonunit.core.Option.IGNORING_ARRAY_ORDER, new net.javacrumbs.jsonunit.core.Option[0]).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |            \"name\": \"bob@domain.tld\",\n        |            \"email\": \"bob@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"b025b9f1-95c6-30fb-a9d4-0fddfcc3a92c\",\n        |            \"name\": \"bob@domain-alias.tld\",\n        |            \"email\": \"bob@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"d2e1e9d2-78ef-3967-87c6-cdc2e0f1541d\",\n        |            \"name\": \"bob-alias@domain-alias.tld\",\n        |            \"email\": \"bob-alias@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ]\n        |}")));
    }

    public static /* synthetic */ void getIdentityShouldReturnSortOrder$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnSortOrder(server);
    }

    @Test
    default public void getIdentityShouldReturnSortOrder(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addDomainAliasMapping("domain-alias.tld", "domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\", \"urn:apache:james:params:jmap:mail:identity:sortorder\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(net.javacrumbs.jsonunit.core.Option.IGNORING_ARRAY_ORDER, new net.javacrumbs.jsonunit.core.Option[0]).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |            \"name\": \"bob@domain.tld\",\n        |            \"email\": \"bob@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\",\n        |            \"sortOrder\": 100\n        |        },\n        |        {\n        |            \"id\": \"b025b9f1-95c6-30fb-a9d4-0fddfcc3a92c\",\n        |            \"name\": \"bob@domain-alias.tld\",\n        |            \"email\": \"bob@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\",\n        |            \"sortOrder\": 100\n        |        },\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\",\n        |            \"sortOrder\": 100\n        |        },\n        |        {\n        |            \"id\": \"d2e1e9d2-78ef-3967-87c6-cdc2e0f1541d\",\n        |            \"name\": \"bob-alias@domain-alias.tld\",\n        |            \"email\": \"bob-alias@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\",\n        |            \"sortOrder\": 100\n        |        }\n        |    ]\n        |}")));
    }

    public static /* synthetic */ void propertiesShouldBeSupported$(IdentityGetContract $this) {
        $this.propertiesShouldBeSupported();
    }

    @Test
    default public void propertiesShouldBeSupported() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"name\", \"email\", \"replyTo\", \"bcc\", \"textSignature\", \"htmlSignature\", \"mayDelete\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"list\": [\n          |      {\n          |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n          |          \"name\": \"bob@domain.tld\",\n          |          \"email\": \"bob@domain.tld\",\n          |          \"mayDelete\": false,\n          |          \"textSignature\":\"\",\n          |          \"htmlSignature\":\"\"\n          |      }\n          |  ]\n          |}")));
    }

    public static /* synthetic */ void propertiesShouldBeFiltered$(IdentityGetContract $this) {
        $this.propertiesShouldBeFiltered();
    }

    @Test
    default public void propertiesShouldBeFiltered() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"email\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"list\": [\n          |      {\n          |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n          |          \"email\": \"bob@domain.tld\"\n          |      }\n          |  ]\n          |}")));
    }

    public static /* synthetic */ void badPropertiesShouldBeRejected$(IdentityGetContract $this) {
        $this.badPropertiesShouldBeRejected();
    }

    @Test
    default public void badPropertiesShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"bad\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"invalidArguments\",\n          |                \"description\": \"The following properties [bad] do not exist.\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static /* synthetic */ void badAccountIdShouldBeRejected$(IdentityGetContract $this) {
        $this.badAccountIdShouldBeRejected();
    }

    @Test
    default public void badAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"accountNotFound\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static /* synthetic */ void getRandomIdShouldNotFail$(IdentityGetContract $this) {
        $this.getRandomIdShouldNotFail();
    }

    @Test
    default public void getRandomIdShouldNotFail() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + id + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Identity/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"notFound\": [\n           |\t\t\t\t\t\"" + id + "\"\n           |\t\t\t\t],\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": []\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void mayDeleteShouldReturnFalseWhenUpdateServerSetIdentity$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.mayDeleteShouldReturnFalseWhenUpdateServerSetIdentity(server);
    }

    @Test
    default public void mayDeleteShouldReturnFalseWhenUpdateServerSetIdentity(GuiceJamesServer server) {
        String serverSetIdentityId = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n                |  \"methodCalls\": [[\n                |    \"Identity/get\",\n                |    {\n                |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n                |      \"ids\": null\n                |    },\n                |    \"c1\"]]\n                |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().jsonPath().get("methodResponses[0][1].list[0].id");
        Some x$1 = new Some((Object)new IdentityHtmlSignatureUpdate("html signature"));
        Option x$2 = IdentityUpdateRequest$.MODULE$.apply$default$1();
        Option x$3 = IdentityUpdateRequest$.MODULE$.apply$default$2();
        Option x$4 = IdentityUpdateRequest$.MODULE$.apply$default$3();
        Option x$5 = IdentityUpdateRequest$.MODULE$.apply$default$4();
        Option x$6 = IdentityUpdateRequest$.MODULE$.apply$default$5();
        SMono<BoxedUnit> qual$1 = ((IdentityProbe)server.getProbe(IdentityProbe.class)).update(Fixture$.MODULE$.BOB(), new IdentityId(UUID.fromString(serverSetIdentityId)), new IdentityUpdateRequest(x$2, x$3, x$4, x$5, x$6, (Option)x$1));
        Duration x$7 = qual$1.block$default$1();
        qual$1.block(x$7);
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n                |  \"methodCalls\": [[\n                |    \"Identity/get\",\n                |    {\n                |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n                |      \"ids\": [ \"" + serverSetIdentityId + "\" ],\n                |      \"properties\": [\"id\", \"mayDelete\"]\n                |    },\n                |    \"c1\"]]\n                |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"id\": \"" + serverSetIdentityId + "\",\n           |    \"mayDelete\": false\n           |}")));
    }

    public static void $init$(IdentityGetContract $this) {
    }
}

