/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Validatable;
import jakarta.mail.internet.SharedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DownloadContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rv!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%\t!\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002 \u0007\u000fI\u001a\u0003\u0013aA\u0001\u000f\")\u0001*\u0002C\u0001\u0013\")Q*\u0002C\u0001\u001d\")\u0001-\u0002D\u0001C\")!.\u0002C\u0001W\")\u0011/\u0002C\u0001e\")Q/\u0002C\u0001m\")\u00110\u0002C\u0001u\")Q0\u0002C\u0001}\"9\u00111A\u0003\u0005\u0002\u0005\u0015\u0001bBA\u0006\u000b\u0011\u0005\u0011Q\u0002\u0005\b\u0003')A\u0011AA\u000b\u0011\u001d\tY\"\u0002C\u0001\u0003;Aq!a\t\u0006\t\u0003\t)\u0003C\u0004\u0002,\u0015!\t!!\f\t\u000f\u0005MR\u0001\"\u0001\u00026!9\u00111H\u0003\u0005\u0002\u0005u\u0002bBA\"\u000b\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017*A\u0011AA'\u0011\u001d\t\u0019&\u0002C\u0001\u0003+Bq!a\u0017\u0006\t\u0003\ti\u0006C\u0004\u0002d\u0015!\t!!\u001a\t\u000f\u0005-T\u0001\"\u0001\u0002n!9\u00111O\u0003\u0005\u0002\u0005U\u0004bBA>\u000b\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0007+A\u0011AAC\u0011\u001d\tY)\u0002C\u0001\u0003\u001bCq!a%\u0006\t\u0003\t)\nC\u0004\u0002\u001c\u0016!\t!!(\u0002!\u0011{wO\u001c7pC\u0012\u001cuN\u001c;sC\u000e$(B\u0001\u0013&\u0003!\u0019wN\u001c;sC\u000e$(B\u0001\u0014(\u0003\u001d\u0011hm\u0019\u001d7eER!\u0001K\u0015\u0002\t)l\u0017\r\u001d\u0006\u0003U-\nQA[1nKNT!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005\u0019#\u0001\u0005#po:dw.\u00193D_:$(/Y2u'\t\tA\u0007\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\n\u0011\"Y2d_VtG/\u00133\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgnZ\u0001\u000bC\u000e\u001cw.\u001e8u\u0013\u0012\u00043CA\u00035\u0003\u0019!\u0013N\\5uIQ\t!\n\u0005\u00026\u0017&\u0011AJ\u000e\u0002\u0005+:LG/A\u0003tKR,\u0006\u000f\u0006\u0002K\u001f\")\u0001k\u0002a\u0001#\u000611/\u001a:wKJ\u0004\"AU*\u000e\u0003%J!\u0001V\u0015\u0003!\u001d+\u0018nY3KC6,7oU3sm\u0016\u0014\bFA\u0004W!\t9f,D\u0001Y\u0015\tI&,A\u0002ba&T!a\u0017/\u0002\u000f),\b/\u001b;fe*\u0011Q,L\u0001\u0006UVt\u0017\u000e^\u0005\u0003?b\u0013!BQ3g_J,W)Y2i\u0003=\u0011\u0018M\u001c3p[6+7o]1hK&#W#\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!B7pI\u0016d'BA4*\u0003\u001di\u0017-\u001b7c_bL!!\u001b3\u0003\u00135+7o]1hK&#\u0017a\u00043po:dw.\u00193NKN\u001c\u0018mZ3\u0015\u0005)c\u0007\"\u0002)\n\u0001\u0004\t\u0006FA\u0005o!\t9v.\u0003\u0002q1\n!A+Z:u\u0003-\"wn\u001e8m_\u0006$W*Z:tC\u001e,7\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tWK\\1vi\",g\u000e^5gS\u0016$GC\u0001&t\u0011\u0015\u0001&\u00021\u0001RQ\tQa.A\u0017e_^tGn\\1e\u001b\u0016\u001c8/Y4f'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016t\u0017\t\u001a3fIJKw\r\u001b;B\u00072#\"AS<\t\u000bA[\u0001\u0019A))\u0005-q\u0017a\n3po:dw.\u00193j]\u001e|E\u000f[3s!\u0016|\u0007\u000f\\3NKN\u001c\u0018mZ3TQ>,H\u000e\u001a$bS2$\"AS>\t\u000bAc\u0001\u0019A))\u00051q\u0017\u0001\n3po:dw.\u00193j]\u001eLen\u0014;iKJ\f5mY8v]R\u001c8\u000b[8vY\u00124\u0015-\u001b7\u0015\u0005){\b\"\u0002)\u000e\u0001\u0004\t\u0006FA\u0007o\u0003)\"wn\u001e8m_\u0006$\u0007+\u0019:u'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016t\u0017\t\u001a3fIJKw\r\u001b;B\u00072#2ASA\u0004\u0011\u0015\u0001f\u00021\u0001RQ\tqa.A\u0016e_^tGn\\1eS:<w\n\u001e5feB+w\u000e\u001d7f\u001b\u0016\u001c8/Y4f!\u0006\u0014Ho\u00155pk2$g)Y5m)\rQ\u0015q\u0002\u0005\u0006!>\u0001\r!\u0015\u0015\u0003\u001f9\fA\u0002Z8x]2|\u0017\r\u001a)beR$2ASA\f\u0011\u0015\u0001\u0006\u00031\u0001RQ\t\u0001b.A\u0018vg\u0016\u00148)\u00198Ta\u0016\u001c\u0017NZ=D_:$XM\u001c;UsB,w\u000b[3o\t><h\u000e\\8bI&tw-T3tg\u0006<W\rF\u0002K\u0003?AQ\u0001U\tA\u0002EC#!\u00058\u0002YU\u001cXM]\"b]N\u0003XmY5gs\u000e{g\u000e^3oiRK\b/Z,iK:$un\u001e8m_\u0006$\u0017N\\4QCJ$Hc\u0001&\u0002(!)\u0001K\u0005a\u0001#\"\u0012!C\\\u00018I><h\u000e\\8bIB\u000b'\u000f^*i_VdG\rR5tG\u0006\u0014HMT1nK^CWM\u001c(piN+\b\u000f\u001d7jK\u0012\u0014\u0015\u0010\u00165f\u00072LWM\u001c;\u0015\u0007)\u000by\u0003C\u0003Q'\u0001\u0007\u0011\u000b\u000b\u0002\u0014]\u0006)So]3s\u0007\u0006t7\u000b]3dS\u001aLh*Y7f/\",g\u000eR8x]2|\u0017\rZ5oOB\u000b'\u000f\u001e\u000b\u0004\u0015\u0006]\u0002\"\u0002)\u0015\u0001\u0004\t\u0006F\u0001\u000bo\u0003i\"wn\u001e8m_\u0006$W*Z:tC\u001e,7\u000b[8vY\u0012$\u0015n]2be\u0012t\u0015-\\3XQ\u0016tgj\u001c;TkB\u0004H.[3e\u0005f$\u0006.Z\"mS\u0016tG\u000fF\u0002K\u0003\u007fAQ\u0001U\u000bA\u0002EC#!\u00068\u0002QU\u001cXM]\"b]N\u0003XmY5gs:\u000bW.Z,iK:$un\u001e8m_\u0006$\u0017N\\4NKN\u001c\u0018mZ3\u0015\u0007)\u000b9\u0005C\u0003Q-\u0001\u0007\u0011\u000b\u000b\u0002\u0017]\u00069Bm\\<oY>\fGMT8u\u000bbL7\u000f^5oOB\u000b'\u000f\u001e\u000b\u0004\u0015\u0006=\u0003\"\u0002)\u0018\u0001\u0004\t\u0006FA\fo\u0003M!wn\u001e8m_\u0006$\u0017J\u001c<bY&$\u0007+\u0019:u)\rQ\u0015q\u000b\u0005\u0006!b\u0001\r!\u0015\u0015\u000319\fQ\u0003Z8x]2|\u0017\rZ,ji\"LeN^1mS\u0012LE\rF\u0002K\u0003?BQ\u0001U\rA\u0002EC#!\u00078\u0002-\u0011|wO\u001c7pC\u0012<\u0016\u000e\u001e5O_R4u.\u001e8e\u0013\u0012$2ASA4\u0011\u0015\u0001&\u00041\u0001RQ\tQb.A\u0010e_^tGn\\1e!\u0006\u0014Ho\u00165f]6+7o]1hK:{GOR8v]\u0012$2ASA8\u0011\u0015\u00016\u00041\u0001RQ\tYb.A\re_^tGn\\1e!\u0006\u0014Ho\u00165f]6+H\u000e^5qCJ$Hc\u0001&\u0002x!)\u0001\u000b\ba\u0001#\"\u0012AD\\\u0001\"I><h\u000e\\8bIB\u000b'\u000f^,iK:$vn\\'vG\",f\u000eZ3sg\u000e|'/\u001a\u000b\u0004\u0015\u0006}\u0004\"\u0002)\u001e\u0001\u0004\t\u0006FA\u000fo\u0003A\"wn\u001e8m_\u0006$W*Z:tC\u001e,7\u000b[8vY\u0012\u001cVoY2fK\u0012<\u0006.\u001a8EK2,w-\u0019;fI\u0006\u001b7m\\;oiR\u0019!*a\"\t\u000bAs\u0002\u0019A))\u0005yq\u0017\u0001\r3po:dw.\u00193NKN\u001c\u0018mZ3TQ>,H\u000e\u001a$bS2<\u0006.\u001a8O_R$U\r\\3hCR,G-Q2d_VtG\u000fF\u0002K\u0003\u001fCQ\u0001U\u0010A\u0002EC#a\b8\u0002i\u0011|wO\u001c7pC\u0012\u0004\u0016M\u001d;NKN\u001c\u0018mZ3TQ>,H\u000eZ*vG\u000e,W\rZ,iK:$U\r\\3hCR,G-Q2d_VtG\u000fF\u0002K\u0003/CQ\u0001\u0015\u0011A\u0002EC#\u0001\t8\u0002M\u0011|wO\u001c7pC\u0012\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:,U.Y5m!\u0006\u0014H/\u00138wC2LG\rF\u0002K\u0003?CQ\u0001U\u0011A\u0002EC#!\t8")
public interface DownloadContract {
    public static String accountId() {
        return DownloadContract$.MODULE$.accountId();
    }

    public static /* synthetic */ void setUp$(DownloadContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.CEDRIC().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void downloadMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessage(server);
    }

    @Test
    default public void downloadMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadMessageShouldFailWhenUnauthentified$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldFailWhenUnauthentified(server);
    }

    @Test
    default public void downloadMessageShouldFailWhenUnauthentified(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().auth().none().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    public static /* synthetic */ void downloadMessageShouldSucceedWhenAddedRightACL$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldSucceedWhenAddedRightACL(server);
    }

    @Test
    default public void downloadMessageShouldSucceedWhenAddedRightACL(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessageShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessageShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessageShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadingInOtherAccountsShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingInOtherAccountsShouldFail(server);
    }

    @Test
    default public void downloadingInOtherAccountsShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ALICE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartShouldSucceedWhenAddedRightACL$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldSucceedWhenAddedRightACL(server);
    }

    @Test
    default public void downloadPartShouldSucceedWhenAddedRightACL(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessagePartShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessagePartShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessagePartShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPart(server);
    }

    @Test
    default public void downloadPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/plain"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("text/plain");
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/markdown"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/markdown");
    }

    public static /* synthetic */ void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.txt"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.txt\""));
    }

    public static /* synthetic */ void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.eml"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.eml\""));
    }

    public static /* synthetic */ void downloadNotExistingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadNotExistingPart(server);
    }

    @Test
    default public void downloadNotExistingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_333", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadInvalidPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadInvalidPart(server);
    }

    @Test
    default public void downloadInvalidPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_invalid", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithInvalidId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithInvalidId(server);
    }

    @Test
    default public void downloadWithInvalidId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/invalid", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithNotFoundId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithNotFoundId(server);
    }

    @Test
    default public void downloadWithNotFoundId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMessageNotFound$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMessageNotFound(server);
    }

    @Test
    default public void downloadPartWhenMessageNotFound(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize() + "_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMultipart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMultipart(server);
    }

    @Test
    default public void downloadPartWhenMultipart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize() + "_2", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenTooMuchUnderscore$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenTooMuchUnderscore(server);
    }

    @Test
    default public void downloadPartWhenTooMuchUnderscore(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadMessageShouldSucceedWhenDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldSucceedWhenDelegatedAccount(server);
    }

    @Test
    default public void downloadMessageShouldSucceedWhenDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadMessageShouldFailWhenNotDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldFailWhenNotDelegatedAccount(server);
    }

    @Test
    default public void downloadMessageShouldFailWhenNotDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.CEDRIC());
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartMessageShouldSucceedWhenDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartMessageShouldSucceedWhenDelegatedAccount(server);
    }

    @Test
    default public void downloadPartMessageShouldSucceedWhenDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadShouldFailWhenEmailPartInvalid$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadShouldFailWhenEmailPartInvalid(server);
    }

    @Test
    default public void downloadShouldFailWhenEmailPartInvalid(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        String messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageAndInvalidPart = messageId + "_";
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageAndInvalidPart, new Object[0])).then().statusCode(404).body(Matchers.containsString((String)"The resource could not be found"), new Matcher[0]);
    }

    public static void $init$(DownloadContract $this) {
    }
}

