/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ConsumerChainer;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepository;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryStore;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryUrlStore;
import org.apache.james.mailrepository.memory.SimpleMailRepositoryLoader;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.memory.MemoryMailQueueFactory;
import org.apache.james.util.MimeMessageUtil;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.james.webadmin.service.ReprocessingService;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReprocessingServiceTest {
    private static final String MEMORY_PROTOCOL = "memory";
    private static final MailRepositoryPath PATH = MailRepositoryPath.from((String)"path");
    private static final String NAME_1 = "key-1";
    private static final String NAME_2 = "key-2";
    private static final String NAME_3 = "key-3";
    private static final MailKey KEY_1 = new MailKey("key-1");
    private static final MailKey KEY_2 = new MailKey("key-2");
    private static final MailKey KEY_3 = new MailKey("key-3");
    private static final MailQueueName SPOOL = MailQueueName.of((String)"spool");
    private static final Consumer<MailKey> NOOP_CONSUMER = key -> {};
    private static final Optional<String> NO_TARGET_PROCESSOR = Optional.empty();
    private static final Optional<Integer> NO_MAX_RETRIES = Optional.empty();
    private static final byte[] MESSAGE_BYTES = "header: value \r\n".getBytes(StandardCharsets.UTF_8);
    public static final boolean CONSUME = true;
    private ReprocessingService reprocessingService;
    private MemoryMailRepositoryStore mailRepositoryStore;
    private MailQueueFactory<? extends ManageableMailQueue> queueFactory;
    private FakeMail mail1;
    private FakeMail mail2;
    private FakeMail mail3;

    ReprocessingServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.mailRepositoryStore = this.createMemoryMailRepositoryStore();
        this.queueFactory = new MemoryMailQueueFactory((MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory());
        this.reprocessingService = new ReprocessingService(this.queueFactory, new MailRepositoryStoreService((MailRepositoryStore)this.mailRepositoryStore));
        this.queueFactory.createQueue(SPOOL);
        this.mail1 = FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build();
        this.mail2 = FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build();
        this.mail3 = FakeMail.builder().name(NAME_3).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build();
    }

    @Test
    void reprocessingOneShouldEnqueueMail() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        repository.store((Mail)this.mail2);
        repository.store((Mail)this.mail3);
        this.reprocessingService.reprocess(PATH, KEY_2, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, Optional.empty(), true, Limit.unlimited()));
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> item.getMail().getName()).containsOnly((Object[])new String[]{NAME_2});
    }

    @Test
    void reprocessingOneShouldRemoveMailFromRepository() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        repository.store((Mail)this.mail2);
        repository.store((Mail)this.mail3);
        this.reprocessingService.reprocess(PATH, KEY_2, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, Optional.empty(), true, Limit.unlimited()));
        Assertions.assertThat((Iterator)repository.list()).toIterable().containsOnly((Object[])new MailKey[]{KEY_1, KEY_3});
    }

    @Test
    void reprocessingShouldEmptyRepository() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        repository.store((Mail)this.mail2);
        repository.store((Mail)this.mail3);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)repository.list()).toIterable().isEmpty();
    }

    @Test
    void reprocessingShouldEnqueueAllMails() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        repository.store((Mail)this.mail2);
        repository.store((Mail)this.mail3);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> item.getMail().getName()).containsOnly((Object[])new String[]{NAME_1, NAME_2, NAME_3});
    }

    @Test
    void reprocessingShouldSupportMaxRetries() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        this.mail1.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)1)));
        repository.store((Mail)this.mail1);
        this.mail2.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)2)));
        repository.store((Mail)this.mail2);
        this.mail3.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)3)));
        repository.store((Mail)this.mail3);
        Optional<Integer> maxRetries = Optional.of(2);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, maxRetries, true, Limit.unlimited()), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> item.getMail().getName()).containsOnly((Object[])new String[]{NAME_1});
    }

    @Test
    void reprocessingShouldCombineMaxRetriesAndLimit() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        this.mail1.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)3)));
        repository.store((Mail)this.mail1);
        this.mail2.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)2)));
        repository.store((Mail)this.mail2);
        this.mail3.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)1)));
        repository.store((Mail)this.mail3);
        Optional<Integer> maxRetries = Optional.of(2);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, maxRetries, true, Limit.limit((int)2)), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> item.getMail().getName()).containsOnly((Object[])new String[]{NAME_3});
    }

    @Test
    void reprocessingShouldSetRetries() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> (int)((Integer)((Attribute)item.getMail().getAttribute(AttributeName.of((String)"mailRepository-reprocessing")).get()).getValue().getValue())).containsOnly((Object[])new Integer[]{1});
    }

    @Test
    void reprocessingShouldIncrementRetries() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        this.mail1.setAttribute(new Attribute(AttributeName.of((String)"mailRepository-reprocessing"), AttributeValue.of((Integer)1)));
        repository.store((Mail)this.mail1);
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), NOOP_CONSUMER).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().extracting(item -> (int)((Integer)((Attribute)item.getMail().getAttribute(AttributeName.of((String)"mailRepository-reprocessing")).get()).getValue().getValue())).containsOnly((Object[])new Integer[]{2});
    }

    @Test
    void reprocessingShouldNotFailOnConcurrentDeletion() throws Exception {
        MailRepository repository = this.mailRepositoryStore.select(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)PATH, (String)MEMORY_PROTOCOL));
        repository.store((Mail)this.mail1);
        repository.store((Mail)this.mail2);
        repository.store((Mail)this.mail3);
        AtomicBoolean shouldPerformRemove = new AtomicBoolean(true);
        ConsumerChainer concurrentRemoveConsumer = Throwing.consumer(key -> {
            if (shouldPerformRemove.get()) {
                shouldPerformRemove.set(false);
                MailKey toRemove = ImmutableList.of((Object)NAME_1, (Object)NAME_2, (Object)NAME_3).stream().map(MailKey::new).filter(candidateForRemoval -> !candidateForRemoval.equals(key)).findFirst().get();
                repository.remove(toRemove);
            }
        });
        this.reprocessingService.reprocessAll(PATH, new ReprocessingService.Configuration(SPOOL, NO_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), (Consumer)concurrentRemoveConsumer).block();
        Assertions.assertThat((Iterator)((ManageableMailQueue)this.queueFactory.getQueue(SPOOL).get()).browse()).toIterable().hasSize(2);
    }

    private MemoryMailRepositoryStore createMemoryMailRepositoryStore() throws Exception {
        MemoryMailRepositoryUrlStore urlStore = new MemoryMailRepositoryUrlStore();
        MailRepositoryStoreConfiguration configuration = MailRepositoryStoreConfiguration.forItems((MailRepositoryStoreConfiguration.Item[])new MailRepositoryStoreConfiguration.Item[]{new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol(MEMORY_PROTOCOL)), MemoryMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration())});
        MemoryMailRepositoryStore mailRepositoryStore = new MemoryMailRepositoryStore((MailRepositoryUrlStore)urlStore, (MailRepositoryLoader)new SimpleMailRepositoryLoader(), configuration);
        mailRepositoryStore.init();
        return mailRepositoryStore;
    }
}

