/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.ReprocessingOneMailTask;
import org.apache.james.webadmin.service.ReprocessingOneMailTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ReprocessingOneMailTaskDTO;
import org.apache.james.webadmin.service.ReprocessingService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class ReprocessingOneMailTaskTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final Clock CLOCK = Clock.fixed(TIMESTAMP, ZoneId.of("UTC"));
    private static final ReprocessingService REPROCESSING_SERVICE = (ReprocessingService)Mockito.mock(ReprocessingService.class);
    private static final String SERIALIZED_TASK_1 = "{\"type\":\"reprocessing-one\",\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\",\"targetProcessor\":\"targetProcessor\", \"consume\":true}";
    private static final String SERIALIZED_TASK_1_ADDITIONAL_INFORMATION = "{\"type\":\"reprocessing-one\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\",\"targetProcessor\":\"targetProcessor\", \"timestamp\":\"2018-11-13T12:00:55Z\", \"consume\":true}";
    private static final String SERIALIZED_TASK_OLD = "{\"type\":\"reprocessing-one\",\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\",\"targetProcessor\":\"targetProcessor\"}";
    private static final String SERIALIZED_TASK_OLD_ADDITIONAL_INFORMATION = "{\"type\":\"reprocessing-one\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\",\"targetProcessor\":\"targetProcessor\", \"timestamp\":\"2018-11-13T12:00:55Z\"}";
    private static final MailRepositoryPath REPOSITORY_PATH = MailRepositoryPath.from((String)"a");
    private static final MailQueueName TARGET_QUEUE = MailQueueName.of((String)"queue");
    private static final MailKey MAIL_KEY = new MailKey("myMail");
    private static final Optional<String> TARGET_PROCESSOR = Optional.of("targetProcessor");
    public static final boolean CONSUME = true;
    private static final Optional<Integer> NO_MAX_RETRIES = Optional.empty();
    private static final Optional<String> NO_PROCESSOR = Optional.empty();

    ReprocessingOneMailTaskTest() {
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        ReprocessingOneMailTask taskWithTargetProcessor = new ReprocessingOneMailTask(REPROCESSING_SERVICE, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), MAIL_KEY, CLOCK);
        ReprocessingOneMailTask taskWithoutTargetProcessor = new ReprocessingOneMailTask(REPROCESSING_SERVICE, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, NO_PROCESSOR, NO_MAX_RETRIES, false, Limit.unlimited()), MAIL_KEY, CLOCK);
        JsonSerializationVerifier.dtoModule((DTOModule)ReprocessingOneMailTaskDTO.module((Clock)CLOCK, (ReprocessingService)REPROCESSING_SERVICE)).testCase((Object)taskWithTargetProcessor, SERIALIZED_TASK_1).testCase((Object)taskWithoutTargetProcessor, "{\"type\":\"reprocessing-one\",\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\", \"consume\":false}").verify();
    }

    @Test
    void taskShouldBeDeserializable() throws Exception {
        JsonTaskSerializer serializer = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingOneMailTaskDTO.module((Clock)CLOCK, (ReprocessingService)REPROCESSING_SERVICE)});
        Assertions.assertThat((Object)serializer.deserialize("{\"type\":\"reprocessing-one\",\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\", \"consume\":false}")).usingRecursiveComparison().isEqualTo((Object)new ReprocessingOneMailTask(REPROCESSING_SERVICE, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, NO_PROCESSOR, NO_MAX_RETRIES, false, Limit.unlimited()), MAIL_KEY, CLOCK));
    }

    @ParameterizedTest
    @ValueSource(strings={"{\"type\":\"reprocessing-one\",\"repositoryPath\":\"%\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\",\"targetProcessor\":\"targetProcessor\"}", "{\"type\":\"reprocessing-one\",\"repositoryPath\":\"%\",\"targetQueue\":\"queue\",\"mailKey\": \"myMail\"}"})
    void taskShouldThrowOnDeserializationUrlDecodingError(String serialized) {
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingOneMailTaskDTO.module((Clock)CLOCK, (ReprocessingService)REPROCESSING_SERVICE)});
        Assertions.assertThatThrownBy(() -> testee.deserialize(serialized)).isInstanceOf(ReprocessingOneMailTask.InvalidMailRepositoryPathDeserializationException.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws IOException {
        ReprocessingOneMailTask.AdditionalInformation details = new ReprocessingOneMailTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, TARGET_PROCESSOR, Optional.empty(), true, Limit.unlimited()), MAIL_KEY, TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)ReprocessingOneMailTaskAdditionalInformationDTO.module()).bean((Object)details).json(SERIALIZED_TASK_1_ADDITIONAL_INFORMATION).verify();
    }

    @Test
    void shouldDeserializePreviousTaskFormat() throws Exception {
        ReprocessingOneMailTask taskWithTargetProcessor = new ReprocessingOneMailTask(REPROCESSING_SERVICE, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), MAIL_KEY, CLOCK);
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingOneMailTaskDTO.module((Clock)CLOCK, (ReprocessingService)REPROCESSING_SERVICE)});
        Assertions.assertThat((Object)testee.deserialize(SERIALIZED_TASK_OLD)).isEqualToComparingFieldByFieldRecursively((Object)taskWithTargetProcessor);
    }

    @Test
    void shouldDeserializePreviousAdditionalInformationFormat() throws Exception {
        ReprocessingOneMailTask.AdditionalInformation details = new ReprocessingOneMailTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, TARGET_PROCESSOR, Optional.empty(), true, Limit.unlimited()), MAIL_KEY, TIMESTAMP);
        JsonTaskAdditionalInformationSerializer testee = JsonTaskAdditionalInformationSerializer.of((AdditionalInformationDTOModule[])new AdditionalInformationDTOModule[]{ReprocessingOneMailTaskAdditionalInformationDTO.module()});
        Assertions.assertThat((Object)testee.deserialize(SERIALIZED_TASK_OLD_ADDITIONAL_INFORMATION)).isEqualToComparingFieldByFieldRecursively((Object)details);
    }
}

