/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import java.util.Optional;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingAllMailsTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ReprocessingAllMailsTaskDTO;
import org.apache.james.webadmin.service.ReprocessingService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class ReprocessingAllMailsTaskTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final ReprocessingService REPROCESSING_SERVICE = (ReprocessingService)Mockito.mock(ReprocessingService.class);
    private static final long REPOSITORY_SIZE = 5L;
    private static final MailRepositoryPath REPOSITORY_PATH = MailRepositoryPath.from((String)"a");
    private static final MailQueueName TARGET_QUEUE = MailQueueName.of((String)"queue");
    private static final Optional<String> SOME_TARGET_PROCESSOR = Optional.of("targetProcessor");
    private static final Optional<Integer> NO_MAX_RETRIES = Optional.empty();
    private static final Optional<String> NO_PROCESSOR = Optional.empty();
    private static final long REMAINING_COUNT = 3L;
    private static final boolean CONSUME = true;
    private static final String SERIALIZED_TASK_WITH_TARGET_PROCESSOR = "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"consume\":true}";
    private static final String SERIALIZED_TASK_WITHOUT_TARGET_PROCESSOR = "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"consume\":false}";
    private static final String SERIALIZED_TASK_ADDITIONAL_INFORMATION_WITH_TARGET_PROCESSOR = "{\"type\":\"reprocessing-all\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\",\"consume\":true}";
    private static final String SERIALIZED_TASK_ADDITIONAL_INFORMATION_WITHOUT_TARGET_PROCESSOR = "{\"type\":\"reprocessing-all\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\", \"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\",\"consume\":false}";
    private static final String OLD_SERIALIZED_TASK = "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\"}";
    private static final String OLD_SERIALIZED_TASK_ADDITIONAL_INFORMATION = "{\"type\":\"reprocessing-all\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\"}";

    ReprocessingAllMailsTaskTest() {
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        ReprocessingAllMailsTask taskWithTargetProcessor = new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()));
        ReprocessingAllMailsTask taskWithoutTargetProcessor = new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, NO_PROCESSOR, NO_MAX_RETRIES, false, Limit.unlimited()));
        ReprocessingAllMailsTask taskWithLimit = new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.limit((int)10)));
        JsonSerializationVerifier.dtoModule((DTOModule)ReprocessingAllMailsTaskDTO.module((ReprocessingService)REPROCESSING_SERVICE)).testCase((Object)taskWithTargetProcessor, SERIALIZED_TASK_WITH_TARGET_PROCESSOR).testCase((Object)taskWithoutTargetProcessor, SERIALIZED_TASK_WITHOUT_TARGET_PROCESSOR).testCase((Object)taskWithLimit, "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"consume\":true, \"limit\":10}").verify();
    }

    @ParameterizedTest
    @ValueSource(strings={"{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"%\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\"}", "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"%\",\"targetQueue\":\"queue\"}"})
    void taskShouldThrowOnDeserializationUrlDecodingError(String serialized) {
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingAllMailsTaskDTO.module((ReprocessingService)REPROCESSING_SERVICE)});
        Assertions.assertThatThrownBy(() -> testee.deserialize(serialized)).isInstanceOf(ReprocessingAllMailsTask.InvalidMailRepositoryPathDeserializationException.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        ReprocessingAllMailsTask.AdditionalInformation details = new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), 5L, 3L, TIMESTAMP);
        ReprocessingAllMailsTask.AdditionalInformation detailsWithoutProcessor = new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, NO_PROCESSOR, NO_MAX_RETRIES, false, Limit.unlimited()), 5L, 3L, TIMESTAMP);
        ReprocessingAllMailsTask.AdditionalInformation detailWithLimit = new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.limit((int)10)), 5L, 3L, TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)ReprocessingAllMailsTaskAdditionalInformationDTO.module()).testCase((Object)details, SERIALIZED_TASK_ADDITIONAL_INFORMATION_WITH_TARGET_PROCESSOR).testCase((Object)detailsWithoutProcessor, SERIALIZED_TASK_ADDITIONAL_INFORMATION_WITHOUT_TARGET_PROCESSOR).testCase((Object)detailWithLimit, "{\"type\":\"reprocessing-all\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\",\"consume\":true, \"limit\": 10}").verify();
    }

    @Test
    void additionalInformationShouldBeSerializableWithMaxRetries() throws Exception {
        ReprocessingAllMailsTask.AdditionalInformation details = new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, Optional.of(6), true, Limit.limit((int)10)), 5L, 3L, TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)ReprocessingAllMailsTaskAdditionalInformationDTO.module()).testCase((Object)details, "{\"type\":\"reprocessing-all\", \"maxRetries\":6, \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\",\"consume\":true, \"limit\": 10}").verify();
    }

    @Test
    void shouldDeserializePreviousTaskFormat() throws Exception {
        ReprocessingAllMailsTask taskWithTargetProcessor = new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()));
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingAllMailsTaskDTO.module((ReprocessingService)REPROCESSING_SERVICE)});
        Assertions.assertThat((Object)testee.deserialize(OLD_SERIALIZED_TASK)).isEqualToComparingFieldByFieldRecursively((Object)taskWithTargetProcessor);
        String serializedTaskWithLimit = "{\"type\":\"reprocessing-all\",\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\", \"limit\":10}";
        Assertions.assertThat((Object)testee.deserialize(serializedTaskWithLimit)).isEqualToComparingFieldByFieldRecursively((Object)new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.limit((int)10))));
    }

    @Test
    void shouldDeserializeMaxRetries() throws Exception {
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ReprocessingAllMailsTaskDTO.module((ReprocessingService)REPROCESSING_SERVICE)});
        String serializedTaskWithLimit = "{\"type\":\"reprocessing-all\", \"maxRetries\":6,\"repositorySize\":5,\"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\", \"limit\":10}";
        Assertions.assertThat((Object)testee.deserialize(serializedTaskWithLimit)).isEqualToComparingFieldByFieldRecursively((Object)new ReprocessingAllMailsTask(REPROCESSING_SERVICE, 5L, REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, Optional.of(6), true, Limit.limit((int)10))));
    }

    @Test
    void shouldDeserializePreviousAdditionalInformationFormat() throws Exception {
        ReprocessingAllMailsTask.AdditionalInformation details = new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.unlimited()), 5L, 3L, TIMESTAMP);
        JsonTaskAdditionalInformationSerializer testee = JsonTaskAdditionalInformationSerializer.of((AdditionalInformationDTOModule[])new AdditionalInformationDTOModule[]{ReprocessingAllMailsTaskAdditionalInformationDTO.module()});
        Assertions.assertThat((Object)testee.deserialize(OLD_SERIALIZED_TASK_ADDITIONAL_INFORMATION)).isEqualToComparingFieldByFieldRecursively((Object)details);
        String serializedTaskAdditionalInformation = "{\"type\":\"reprocessing-all\", \"repositoryPath\":\"a\",\"targetQueue\":\"queue\",\"targetProcessor\":\"targetProcessor\",\"initialCount\":5,\"remainingCount\":3, \"timestamp\":\"2018-11-13T12:00:55Z\", \"limit\": 10}";
        Assertions.assertThat((Object)testee.deserialize(serializedTaskAdditionalInformation)).isEqualToComparingFieldByFieldRecursively((Object)new ReprocessingAllMailsTask.AdditionalInformation(REPOSITORY_PATH, new ReprocessingService.Configuration(TARGET_QUEUE, SOME_TARGET_PROCESSOR, NO_MAX_RETRIES, true, Limit.limit((int)10)), 5L, 3L, TIMESTAMP));
    }
}

