/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.memory.MemoryMailRepository;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.util.streams.Limit;
import org.apache.james.util.streams.Offset;
import org.apache.james.webadmin.dto.MailKeyDTO;
import org.apache.james.webadmin.dto.SingleMailRepositoryResponse;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MailRepositoryStoreServiceTest {
    private static final MailRepositoryPath FIRST_REPOSITORY_PATH = MailRepositoryPath.from((String)"repository");
    private static final MailRepositoryPath SECOND_REPOSITORY_PATH = MailRepositoryPath.from((String)"repository2");
    private static final MailKey NAME_1 = new MailKey("name1");
    private static final MailKey NAME_2 = new MailKey("name2");
    private MailRepositoryStore mailRepositoryStore;
    private MailRepositoryStoreService testee;
    private MemoryMailRepository repository;

    MailRepositoryStoreServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.mailRepositoryStore = (MailRepositoryStore)Mockito.mock(MailRepositoryStore.class);
        this.repository = new MemoryMailRepository();
        this.testee = new MailRepositoryStoreService(this.mailRepositoryStore);
    }

    @Test
    void listMailRepositoriesShouldReturnEmptyWhenEmpty() {
        Mockito.when((Object)this.mailRepositoryStore.getPaths()).thenReturn(Stream.empty());
        Assertions.assertThat((Stream)this.testee.listMailRepositories()).isEmpty();
    }

    @Test
    void listMailRepositoriesShouldReturnOneRepositoryWhenOne() {
        Mockito.when((Object)this.mailRepositoryStore.getPaths()).thenReturn(Stream.of(FIRST_REPOSITORY_PATH));
        Assertions.assertThat((Stream)this.testee.listMailRepositories()).extracting(SingleMailRepositoryResponse::getRepository).containsOnly((Object[])new String[]{FIRST_REPOSITORY_PATH.asString()});
    }

    @Test
    void listMailRepositoriesShouldReturnTwoRepositoriesWhentwo() {
        Mockito.when((Object)this.mailRepositoryStore.getPaths()).thenReturn(Stream.of(FIRST_REPOSITORY_PATH, SECOND_REPOSITORY_PATH));
        Assertions.assertThat((Stream)this.testee.listMailRepositories()).extracting(SingleMailRepositoryResponse::getRepository).containsOnly((Object[])new String[]{FIRST_REPOSITORY_PATH.asString(), SECOND_REPOSITORY_PATH.asString()});
    }

    @Test
    void listMailsShouldThrowWhenMailRepositoryStoreThrows() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenThrow(new Throwable[]{new MailRepositoryStore.MailRepositoryStoreException("message")});
        Assertions.assertThatThrownBy(() -> this.testee.listMails(FIRST_REPOSITORY_PATH, Offset.none(), Limit.unlimited())).isInstanceOf(MailRepositoryStore.MailRepositoryStoreException.class);
    }

    @Test
    void listMailsShouldReturnEmptyWhenMailRepositoryIsEmpty() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(this.repository));
        Assertions.assertThat((List)((List)this.testee.listMails(FIRST_REPOSITORY_PATH, Offset.none(), Limit.unlimited()).get())).isEmpty();
    }

    @Test
    void listMailsShouldReturnContainedMailKeys() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(this.repository));
        this.repository.store((Mail)FakeMail.builder().name(NAME_1.asString()).build());
        this.repository.store((Mail)FakeMail.builder().name(NAME_2.asString()).build());
        Assertions.assertThat((List)((List)this.testee.listMails(FIRST_REPOSITORY_PATH, Offset.none(), Limit.unlimited()).get())).containsOnly((Object[])new MailKeyDTO[]{new MailKeyDTO(NAME_1), new MailKeyDTO(NAME_2)});
    }

    @Test
    void listMailsShouldApplyLimitAndOffset() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(this.repository));
        this.repository.store((Mail)FakeMail.builder().name(NAME_1.asString()).build());
        this.repository.store((Mail)FakeMail.builder().name(NAME_2.asString()).build());
        this.repository.store((Mail)FakeMail.builder().name("name3").build());
        Assertions.assertThat((List)((List)this.testee.listMails(FIRST_REPOSITORY_PATH, Offset.from((int)1), Limit.from((int)1)).get())).containsOnly((Object[])new MailKeyDTO[]{new MailKeyDTO(NAME_2)});
    }

    @Test
    void retrieveMessageShouldThrownWhenUnknownRepository() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(new MailRepository[0]));
        Assertions.assertThatThrownBy(() -> this.testee.retrieveMessage(FIRST_REPOSITORY_PATH, NAME_1)).isNotInstanceOf(NullPointerException.class);
    }

    @Test
    void retrieveMessageShouldThrowWhenMailRepositoryStoreThrows() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenThrow(new Throwable[]{new MailRepositoryStore.MailRepositoryStoreException("message")});
        Assertions.assertThatThrownBy(() -> this.testee.retrieveMessage(FIRST_REPOSITORY_PATH, NAME_1)).isInstanceOf(MailRepositoryStore.MailRepositoryStoreException.class);
    }

    @Test
    void retrieveMessageShouldReturnEmptyWhenMailNotFound() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(this.repository));
        Assertions.assertThat((Optional)this.testee.retrieveMessage(FIRST_REPOSITORY_PATH, NAME_1)).isEmpty();
    }

    @Test
    void retrieveMessageShouldReturnTheMessageWhenMailExists() throws Exception {
        Mockito.when((Object)this.mailRepositoryStore.getByPath(FIRST_REPOSITORY_PATH)).thenReturn(Stream.of(this.repository));
        FakeMail mail = FakeMail.builder().name(NAME_1.asString()).fileName("mail.eml").build();
        this.repository.store((Mail)mail);
        Optional mimeMessage = this.testee.retrieveMessage(FIRST_REPOSITORY_PATH, NAME_1);
        Assertions.assertThat((Optional)mimeMessage).isNotEmpty();
        String eml = IOUtils.toString((InputStream)new MimeMessageInputStream((MimeMessage)mimeMessage.get()), (Charset)StandardCharsets.UTF_8);
        String expectedContent = ClassLoaderUtils.getSystemResourceAsString((String)"mail.eml");
        Assertions.assertThat((String)eml).isEqualToNormalizingNewlines((CharSequence)expectedContent);
    }
}

