/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ClearMailRepositoryTask;
import org.apache.james.webadmin.service.ClearMailRepositoryTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ClearMailRepositoryTaskDTO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ClearMailRepositoryTaskTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final String SERIALIZED = "{\"type\":\"clear-mail-repository\",\"mailRepositoryPath\":\"a\"}";
    private static final String SERIALIZED_TASK_ADDITIONAL_INFORMATION = "{\"type\":\"clear-mail-repository\", \"mailRepositoryPath\":\"a\", \"initialCount\": 0, \"remainingCount\": 10, \"timestamp\":\"2018-11-13T12:00:55Z\"}";
    private static final MailRepositoryStore MAIL_REPOSITORY_STORE = (MailRepositoryStore)Mockito.mock(MailRepositoryStore.class);
    private static final ClearMailRepositoryTask.Factory FACTORY = new ClearMailRepositoryTask.Factory(MAIL_REPOSITORY_STORE);
    private static final MailRepositoryPath MAIL_REPOSITORY_PATH = MailRepositoryPath.from((String)"a");
    private static final ClearMailRepositoryTask TASK = new ClearMailRepositoryTask(MAIL_REPOSITORY_STORE, MAIL_REPOSITORY_PATH);
    private static final long INITIAL_COUNT = 0L;
    private static final long REMAINING_COUNT = 10L;

    ClearMailRepositoryTaskTest() {
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)ClearMailRepositoryTaskDTO.module((ClearMailRepositoryTask.Factory)FACTORY)).bean((Object)TASK).json(SERIALIZED).verify();
    }

    @Test
    void taskShouldThrowOnDeserializationUrlDecodingError() {
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ClearMailRepositoryTaskDTO.module((ClearMailRepositoryTask.Factory)FACTORY)});
        Assertions.assertThatThrownBy(() -> testee.deserialize("{\"type\":\"clear-mail-repository\",\"mailRepositoryPath\":\"%\"}")).isInstanceOf(ClearMailRepositoryTask.InvalidMailRepositoryPathDeserializationException.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)ClearMailRepositoryTaskAdditionalInformationDTO.module()).bean((Object)new ClearMailRepositoryTask.AdditionalInformation(MAIL_REPOSITORY_PATH, 0L, 10L, TIMESTAMP)).json(SERIALIZED_TASK_ADDITIONAL_INFORMATION).verify();
    }
}

