/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.internet.MimeMessage;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepository;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryStore;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryUrlStore;
import org.apache.james.mailrepository.memory.SimpleMailRepositoryLoader;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.memory.MemoryMailQueueFactory;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.util.MimeMessageUtil;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.MailRepositoriesRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.service.ClearMailRepositoryTask;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingAllMailsTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ReprocessingOneMailTask;
import org.apache.james.webadmin.service.ReprocessingOneMailTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ReprocessingService;
import org.apache.james.webadmin.service.WebAdminClearMailRepositoryTaskAdditionalInformationDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailRepositoriesRoutesTest {
    private static final MailRepositoryUrl URL_MY_REPO = MailRepositoryUrl.from((String)"memory://myRepo");
    private static final MailRepositoryUrl URL_MY_REPO_OTHER = MailRepositoryUrl.from((String)"other://myRepo");
    private static final MailRepositoryPath PATH_MY_REPO = MailRepositoryPath.from((String)"myRepo");
    private static final String PATH_ESCAPED_MY_REPO = "myRepo";
    private static final String MY_REPO_MAILS = "myRepo/mails";
    private static final MailQueueName CUSTOM_QUEUE = MailQueueName.of((String)"customQueue");
    private static final String NAME_1 = "name1";
    private static final String NAME_2 = "name2";
    private static final byte[] MESSAGE_BYTES = "header: value \r\n".getBytes(StandardCharsets.UTF_8);
    private WebAdminServer webAdminServer;
    private MemoryMailRepositoryStore mailRepositoryStore;
    private ManageableMailQueue spoolQueue;
    private ManageableMailQueue customQueue;

    MailRepositoriesRoutesTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.createMailRepositoryStore();
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        MemoryMailQueueFactory queueFactory = new MemoryMailQueueFactory((MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory());
        this.spoolQueue = (ManageableMailQueue)queueFactory.createQueue(MailQueueFactory.SPOOL);
        this.customQueue = (ManageableMailQueue)queueFactory.createQueue(CUSTOM_QUEUE);
        MailRepositoryStoreService repositoryStoreService = new MailRepositoryStoreService((MailRepositoryStore)this.mailRepositoryStore);
        ReprocessingService reprocessingService = new ReprocessingService((MailQueueFactory)queueFactory, repositoryStoreService);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new MailRepositoriesRoutes(repositoryStoreService, jsonTransformer, reprocessingService, (TaskManager)taskManager), new TasksRoutes((TaskManager)taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{ReprocessingOneMailTaskAdditionalInformationDTO.module(), ReprocessingAllMailsTaskAdditionalInformationDTO.module(), WebAdminClearMailRepositoryTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("mailRepositories").build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void putMailRepositoryShouldReturnOkWhenRepositoryIsCreated() {
        ((ValidatableResponse)((Response)RestAssured.given().params("protocol", (Object)"memory", new Object[0]).when().put(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(204);
        ((OptionalAssert)Assertions.assertThat((Optional)this.mailRepositoryStore.get(URL_MY_REPO)).isNotEmpty()).containsInstanceOf(MemoryMailRepository.class);
    }

    @Test
    void putMailRepositoryShouldReturnOkWhenRepositoryAlreadyExists() {
        ((ValidatableResponse)((Response)RestAssured.given().params("protocol", (Object)"memory", new Object[0]).when().put(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().params("protocol", (Object)"memory", new Object[0]).when().put(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(204);
        ((OptionalAssert)Assertions.assertThat((Optional)this.mailRepositoryStore.get(URL_MY_REPO)).isNotEmpty()).containsInstanceOf(MemoryMailRepository.class);
        Assertions.assertThat((Stream)this.mailRepositoryStore.getByPath(PATH_MY_REPO)).hasSize(1);
    }

    @Test
    void putMailRepositoryShouldReturnInvalidArgumentWhenProtocolIsUnsupported() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().params("protocol", (Object)"unsupported", new Object[0]).when().put(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"'unsupported' is an unsupported protocol"), new Object[0]);
        Assertions.assertThat((Optional)this.mailRepositoryStore.get(URL_MY_REPO)).isEmpty();
    }

    @Test
    void getMailRepositoriesShouldReturnEmptyWhenEmpty() {
        List mailRepositories = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
        Assertions.assertThat((List)mailRepositories).isEmpty();
    }

    @Test
    void getMailRepositoriesShouldReturnRepositoryWhenOne() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("[0].repository", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("[0].path", Matchers.is((Object)PATH_ESCAPED_MY_REPO), new Object[0]);
    }

    @Test
    void getMailRepositoriesShouldDeduplicateAccordingToPath() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("[0].repository", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("[0].path", Matchers.is((Object)PATH_ESCAPED_MY_REPO), new Object[0]);
    }

    @Test
    void getMailRepositoriesShouldReturnTwoRepositoriesWhenTwo() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        this.mailRepositoryStore.create(MailRepositoryUrl.from((String)"memory://mySecondRepo"));
        List mailRepositories = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList("repository");
        Assertions.assertThat((List)mailRepositories).containsOnly((Object[])new String[]{PATH_ESCAPED_MY_REPO, "mySecondRepo"});
    }

    @Test
    void listingKeysShouldReturnNotFoundWhenNoRepository() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(404)).body("message", Matchers.is((Object)"myRepo does not exist"), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnEmptyWhenNoMail() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnContainedKeys() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)2), new Object[0])).body("", Matchers.containsInAnyOrder((Object[])new String[]{NAME_1, NAME_2}), new Object[0]);
    }

    @Test
    void listingKeysShouldMergeRepositoryContentWhenSamePath() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository2.store((Mail)FakeMail.builder().name(NAME_2).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)2), new Object[0])).body("", Matchers.containsInAnyOrder((Object[])new String[]{NAME_1, NAME_2}), new Object[0]);
    }

    @Test
    void listingKeysShouldApplyLimitAndOffset() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        mailRepository.store((Mail)FakeMail.builder().name("name3").build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"1"}).param("offset", new Object[]{"1"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("", Matchers.contains((Object[])new String[]{NAME_2}), new Object[0]);
    }

    @Test
    void listingKeysShouldApplyLimitWhenSeveralRepositories() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_2).build());
        mailRepository2.store((Mail)FakeMail.builder().name("name3").build());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"1"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnErrorOnInvalidOffset() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{"invalid"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Can not parse offset"), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnErrorOnNegativeOffset() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{"-1"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"offset can not be negative"), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnEmptyWhenOffsetExceedsSize() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        mailRepository.store((Mail)FakeMail.builder().name("name3").build());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{"5"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void offsetShouldBeAplliedOnTheMergedViewOfMailRepositories() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository2.store((Mail)FakeMail.builder().name(NAME_2).build());
        mailRepository1.store((Mail)FakeMail.builder().name("name3").build());
        mailRepository2.store((Mail)FakeMail.builder().name("name4").build());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{"2"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)2), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnErrorOnInvalidLimit() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"invalid"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Can not parse limit"), new Object[0]);
    }

    @Test
    void listingKeysShouldReturnErrorOnNegativeLimit() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"-1"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"limit can not be negative"), new Object[0]);
    }

    @Test
    void listingKeysShouldIgnoreZeroedOffset() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{"0"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)2), new Object[0])).body("", Matchers.containsInAnyOrder((Object[])new String[]{NAME_1, NAME_2}), new Object[0]);
    }

    @Test
    void zeroLimitShouldNotBeValid() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"0"}).when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"limit can not be equal to zero"), new Object[0]);
    }

    @Test
    void retrievingRepositoryShouldReturnNotFoundWhenNone() {
        ((ValidatableResponse)((Response)RestAssured.given().get(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(404);
    }

    @Test
    void retrievingRepositoryShouldReturnBasicInformation() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("repository", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("path", Matchers.is((Object)PATH_ESCAPED_MY_REPO), new Object[0]);
    }

    @Test
    void retrievingRepositorySizeShouldReturnZeroWhenEmpty() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("size", Matchers.equalTo((Object)0), new Object[0]);
    }

    @Test
    void retrievingRepositorySizeShouldReturnNumberOfContainedMails() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("size", Matchers.equalTo((Object)1), new Object[0]);
    }

    @Test
    void retrievingRepositorySizeShouldReturnNumberOfContainedMailsWhenSeveralRepositoryWithSamePath() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository2.store((Mail)FakeMail.builder().name(NAME_2).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get(PATH_ESCAPED_MY_REPO, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("size", Matchers.equalTo((Object)2), new Object[0]);
    }

    @Test
    void retrievingAMailShouldDisplayItsInformation() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        String sender = "sender@domain";
        String recipient1 = "recipient1@domain";
        String recipient2 = "recipient2@domain";
        String state = "state";
        String errorMessage = "Error: why this mail is stored";
        String remoteHost = "smtp.domain";
        String remoteAddr = "66.66.66.66";
        Date lastUpdated = new Date(487563735169L);
        mailRepository.store((Mail)FakeMail.builder().name(name).sender(sender).recipients(new String[]{recipient1, recipient2}).state(state).errorMessage(errorMessage).remoteHost(remoteHost).remoteAddr(remoteAddr).lastUpdated(lastUpdated).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("myRepo/mails/" + name, new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)name), new Object[0])).body("sender", Matchers.is((Object)sender), new Object[0])).body("recipients", Matchers.containsInAnyOrder((Object[])new String[]{recipient1, recipient2}), new Object[0])).body("state", Matchers.is((Object)state), new Object[0])).body("error", Matchers.is((Object)errorMessage), new Object[0])).body("remoteHost", Matchers.is((Object)remoteHost), new Object[0])).body("remoteAddr", Matchers.is((Object)remoteAddr), new Object[0])).body("lastUpdated", Matchers.is((Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(ZonedDateTime.ofInstant(lastUpdated.toInstant(), ZoneId.of("UTC")))), new Object[0]);
    }

    @Test
    void retrievingAMailShouldDisplayAllAdditionalFieldsWhenRequested() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        MimeMessageBuilder.BodyPartBuilder textMessage = MimeMessageBuilder.bodyPartBuilder().addHeader("Content-type", "text/plain").data("My awesome body!!");
        MimeMessageBuilder.BodyPartBuilder htmlMessage = MimeMessageBuilder.bodyPartBuilder().addHeader("Content-type", "text/html").data("My awesome <em>body</em>!!");
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader("headerName3", "value5").addHeader("headerName3", "value8").addHeader("headerName4", "value6").addHeader("headerName4", "value7").setContent(MimeMessageBuilder.multipartBuilder().subType("alternative").addBody(textMessage).addBody(htmlMessage)).build();
        MailAddress recipientHeaderAddress = new MailAddress("third@party");
        FakeMail mail = FakeMail.builder().name(name).attribute(Attribute.convertToAttribute((String)NAME_1, (Object)"value1")).attribute(Attribute.convertToAttribute((String)NAME_2, (Object)"value2")).mimeMessage(mimeMessage).size(42424242L).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("headerName1").value("value1").build(), recipientHeaderAddress).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("headerName1").value("value2").build(), recipientHeaderAddress).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("headerName2").value("value3").build(), recipientHeaderAddress).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("headerName2").value("value4").build(), recipientHeaderAddress).build();
        mailRepository.store((Mail)mail);
        String jsonAsString = ((ValidatableResponse)((Response)RestAssured.given().params("additionalFields", (Object)"attributes,headers,textBody,htmlBody,messageSize,perRecipientsHeaders", new Object[0]).when().get("myRepo/mails/name1", new Object[0])).then()).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonAsString).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_FIELDS, new Option[0]).isEqualTo((Object)"{  \"name\": \"name1\",  \"sender\": null,  \"recipients\": [],  \"error\": null,  \"state\": null,  \"remoteHost\": \"111.222.333.444\",  \"remoteAddr\": \"127.0.0.1\",  \"lastUpdated\": null,  \"attributes\": {    \"name2\": \"value2\",    \"name1\": \"value1\"  },  \"perRecipientsHeaders\": {    \"third@party\": {      \"headerName1\": [        \"value1\",        \"value2\"      ],      \"headerName2\": [        \"value3\",        \"value4\"      ]    }  },  \"headers\": {    \"headerName4\": [      \"value6\",      \"value7\"    ],    \"headerName3\": [      \"value5\",      \"value8\"    ]  },  \"textBody\": \"My awesome body!!\",  \"htmlBody\": \"My awesome <em>body</em>!!\",  \"messageSize\": 42424242}");
    }

    @Test
    void retrievingAMailShouldDisplayAllValidAdditionalFieldsWhenRequested() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        String sender = "sender@domain";
        String recipient1 = "recipient1@domain";
        int messageSize = 42424242;
        mailRepository.store((Mail)FakeMail.builder().name(name).sender(sender).recipients(new String[]{recipient1}).size((long)messageSize).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().params("additionalFields", (Object)",,,messageSize", new Object[0]).when().get("myRepo/mails/name1", new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)name), new Object[0])).body("sender", Matchers.is((Object)sender), new Object[0])).body("headers", Matchers.nullValue(), new Object[0])).body("textBody", Matchers.nullValue(), new Object[0])).body("htmlBody", Matchers.nullValue(), new Object[0])).body("messageSize", Matchers.is((Object)messageSize), new Object[0])).body("attributes", Matchers.nullValue(), new Object[0])).body("perRecipientsHeaders", Matchers.nullValue(), new Object[0]);
    }

    @Test
    void retrievingAMailShouldDisplayCorrectlyEncodedHeadersInValidAdditionalFieldsWhenRequested() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        String sender = "sender@domain";
        String recipient1 = "recipient1@domain";
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader("friend", "=?UTF-8?B?RnLDqWTDqXJpYyBNQVJUSU4=?= <fred.martin@linagora.com>").build();
        mailRepository.store((Mail)FakeMail.builder().name(name).sender(sender).recipients(new String[]{recipient1}).mimeMessage(mimeMessage).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().params("additionalFields", (Object)"headers", new Object[0]).when().get("myRepo/mails/name1", new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)name), new Object[0])).body("sender", Matchers.is((Object)sender), new Object[0])).body("headers.friend", Matchers.is(Arrays.asList("Fr\u00e9d\u00e9ric MARTIN <fred.martin@linagora.com>")), new Object[0]);
    }

    @Test
    void retrievingAMailShouldDisplayAllValidAdditionalFieldsEvenTheDuplicatedOnesWhenRequested() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        String sender = "sender@domain";
        String recipient1 = "recipient1@domain";
        int messageSize = 42424242;
        mailRepository.store((Mail)FakeMail.builder().name(name).sender(sender).recipients(new String[]{recipient1}).size((long)messageSize).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().params("additionalFields", (Object)"messageSize,messageSize", new Object[0]).when().get("myRepo/mails/name1", new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)name), new Object[0])).body("sender", Matchers.is((Object)sender), new Object[0])).body("headers", Matchers.nullValue(), new Object[0])).body("textBody", Matchers.nullValue(), new Object[0])).body("htmlBody", Matchers.nullValue(), new Object[0])).body("messageSize", Matchers.is((Object)messageSize), new Object[0])).body("attributes", Matchers.nullValue(), new Object[0])).body("perRecipientsHeaders", Matchers.nullValue(), new Object[0]);
    }

    @Test
    void retrievingAMailShouldFailWhenAnUnknownFieldIsRequested() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        String sender = "sender@domain";
        String recipient1 = "recipient1@domain";
        int messageSize = 42424242;
        mailRepository.store((Mail)FakeMail.builder().name(name).sender(sender).recipients(new String[]{recipient1}).size((long)messageSize).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().params("additionalFields", (Object)"nonExistingField", new Object[0]).when().get("myRepo/mails/name1", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"The field 'nonExistingField' can't be requested in additionalFields parameter"), new Object[0]);
    }

    @Test
    void retrievingAMailShouldNotFailWhenOnlyNameProperty() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("myRepo/mails/name1", new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)NAME_1), new Object[0])).body("sender", Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("state", Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("error", Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("recipients", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void retrievingAMailShouldFailWhenUnknown() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        String name = "name";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("myRepo/mails/" + name, new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)("Could not retrieve " + name)), new Object[0]);
    }

    @Test
    void downloadingAMailShouldReturnTheEml() throws Exception {
        RestAssured.requestSpecification = new RequestSpecBuilder().setPort(this.webAdminServer.getPort().getValue()).setBasePath("mailRepositories").build();
        RestAssured.registerParser((String)"message/rfc822", (Parser)Parser.TEXT);
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name = NAME_1;
        FakeMail mail = FakeMail.builder().name(name).fileName("mail.eml").build();
        mailRepository.store((Mail)mail);
        String expectedContent = ClassLoaderUtils.getSystemResourceAsString((String)"mail.eml", (Charset)StandardCharsets.UTF_8);
        String actualContent = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("message/rfc822").when().get("myRepo/mails/" + name, new Object[0])).then()).statusCode(200)).header("Content-Length", "471")).contentType("message/rfc822")).extract().body().asString();
        Assertions.assertThat((String)actualContent).isEqualToNormalizingNewlines((CharSequence)expectedContent);
    }

    @Test
    void downloadingAMailShouldFailWhenUnknown() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        RestAssured.requestSpecification = new RequestSpecBuilder().setPort(this.webAdminServer.getPort().getValue()).setBasePath("mailRepositories").build();
        RestAssured.registerParser((String)"message/rfc822", (Parser)Parser.TEXT);
        String name = "name";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("message/rfc822").when().get("myRepo/mails/" + name, new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)("Could not retrieve " + name)), new Object[0]);
    }

    @Test
    void deletingAMailShouldRemoveIt() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        RestAssured.given().delete("myRepo/mails/name1", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("", Matchers.contains((Object[])new String[]{NAME_2}), new Object[0]);
    }

    @Test
    void deletingAMailShouldReturnOkWhenExist() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((Response)RestAssured.when().delete("myRepo/mails/name1", new Object[0])).then()).statusCode(204);
    }

    @Test
    void deletingAMailShouldReturnOkWhenNotExist() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((Response)RestAssured.when().delete("myRepo/mails/name", new Object[0])).then()).statusCode(204);
    }

    @Test
    void deletingAllMailsShouldCreateATask() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(MY_REPO_MAILS, new Object[0])).then()).statusCode(201)).header("Location", Matchers.is((Matcher)Matchers.notNullValue()))).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void clearTaskShouldHaveDetails() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().delete(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ClearMailRepositoryTask.TYPE.asString()), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void clearTaskShouldRemoveAllTheMailsFromTheMailRepository() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().delete(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.given().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MY_REPO_MAILS, new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void patchShouldReturnNotFoundWhenNoMailRepository() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(MY_REPO_MAILS, new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)(PATH_MY_REPO.asString() + " does not exist")), new Object[0]);
    }

    @Test
    void deleteShouldReturnNotFoundWhenNoMailRepository() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("myRepo/mails/any", new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)(PATH_MY_REPO.asString() + " does not exist")), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldCreateATask() throws Exception {
        this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("action", new Object[]{"reprocess"}).when().patch(MY_REPO_MAILS, new Object[0])).then()).statusCode(201)).header("Location", Matchers.is((Matcher)Matchers.notNullValue()))).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldRejectInvalidActions() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("action", new Object[]{"invalid"}).when().patch(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [reprocess]"), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldRequireAction() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().patch(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter is compulsory. Supported values are [reprocess]"), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldIncludeDetailsWhenDefaultValues() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ReprocessingAllMailsTask.TYPE.asString()), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Object)MailQueueFactory.SPOOL.asString()), new Object[0])).body("additionalInformation.consume", Matchers.is((Object)true), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldIncludeDetails() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).param("consume", new Object[]{false}).param("limit", new Object[]{100}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ReprocessingAllMailsTask.TYPE.asString()), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Object)transport), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Object)CUSTOM_QUEUE.asString()), new Object[0])).body("additionalInformation.consume", Matchers.is((Object)false), new Object[0])).body("additionalInformation.limit", Matchers.is((Object)100), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldNotFailWhenSeveralRepositoriesWithSamePath() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldClearMailRepository() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)mailRepository.list()).toIterable().isEmpty();
    }

    @Test
    void reprocessingAllTaskShouldClearMailInLimitedWhenProvideLimitParameter() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("limit", new Object[]{1}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ReprocessingAllMailsTask.TYPE.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.limit", Matchers.is((Object)1), new Object[0]);
        Assertions.assertThat((Iterator)mailRepository.list()).toIterable().hasSize(1);
    }

    @Test
    void reprocessingAllTaskShouldFailWhenInvalidLimitParameter() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("limit", new Object[]{"invalid"}).patch(MY_REPO_MAILS, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Can not parse limit"), new Object[0]);
    }

    @Test
    void reprocessingAllTaskShouldNotClearMailRepositoryWhenNotConsume() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).param("consume", new Object[]{false}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)mailRepository.list()).toIterable().hasSize(2);
    }

    @Test
    void reprocessingAllTaskShouldClearBothMailRepositoriesWhenSamePath() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository1.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository2.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)mailRepository1.list()).toIterable().isEmpty();
        Assertions.assertThat((Iterator)mailRepository2.list()).toIterable().isEmpty();
    }

    @Test
    void reprocessingAllTaskShouldEnqueueMailsOnDefaultQueue() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsOnly((Object[])new String[]{NAME_1, NAME_2});
    }

    @Test
    void reprocessingAllTaskShouldEnqueueMailsOfBothRepositoriesOnDefaultQueueWhenSamePath() throws Exception {
        MailRepository mailRepository1 = this.mailRepositoryStore.create(URL_MY_REPO);
        MailRepository mailRepository2 = this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        mailRepository1.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository2.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsOnly((Object[])new String[]{NAME_1, NAME_2});
    }

    @Test
    void reprocessingAllTaskShouldPreserveStateWhenProcessorIsNotSpecified() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String state1 = "state1";
        String state2 = "state2";
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).state(state1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).state(state2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getState).containsOnly((Object[])new String[]{state1, state2});
    }

    @Test
    void reprocessingAllTaskShouldOverWriteStateWhenProcessorSpecified() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String state1 = "state1";
        String state2 = "state2";
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).state(state1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).state(state2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("processor", new Object[]{transport}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getState).containsOnly((Object[])new String[]{transport, transport});
    }

    @Test
    void reprocessingAllTaskShouldEnqueueMailsOnSpecifiedQueue() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).patch(MY_REPO_MAILS, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.customQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsOnly((Object[])new String[]{NAME_1, NAME_2});
    }

    @Test
    void reprocessingOneTaskShouldCreateATask() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("action", new Object[]{"reprocess"}).when().patch("myRepo/mails/name1", new Object[0])).then()).statusCode(201)).header("Location", Matchers.is((Matcher)Matchers.notNullValue()))).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldRejectInvalidActions() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("action", new Object[]{"invalid"}).when().patch("myRepo/mails/name1", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [reprocess]"), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldRequireAction() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().patch("myRepo/mails/name1", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'action' query parameter is compulsory. Supported values are [reprocess]"), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldIncludeDetailsWhenDefaultValues() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ReprocessingOneMailTask.TYPE.asString()), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("additionalInformation.mailKey", Matchers.is((Object)NAME_1), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Object)MailQueueFactory.SPOOL.asString()), new Object[0])).body("additionalInformation.consume", Matchers.is((Object)true), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldIncludeDetails() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).param("consume", new Object[]{false}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ReprocessingOneMailTask.TYPE.asString()), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)PATH_MY_REPO.asString()), new Object[0])).body("additionalInformation.mailKey", Matchers.is((Object)NAME_1), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Object)transport), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Object)CUSTOM_QUEUE.asString()), new Object[0])).body("additionalInformation.consume", Matchers.is((Object)false), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldNotFailWhenSeveralRepositoryWithSamePath() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        this.mailRepositoryStore.create(URL_MY_REPO_OTHER);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void reprocessingOneTaskShouldRemoveMailFromRepository() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String name1 = NAME_1;
        String name2 = NAME_2;
        mailRepository.store((Mail)FakeMail.builder().name(name1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(name2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("processor", new Object[]{transport}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)mailRepository.list()).toIterable().containsOnly((Object[])new MailKey[]{new MailKey(NAME_2)});
    }

    @Test
    void reprocessingOneTaskShouldEnqueueMailsOnDefaultQueue() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsOnly((Object[])new String[]{NAME_1});
    }

    @Test
    void reprocessingOneTaskShouldPreserveStateWhenProcessorIsNotSpecified() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String state1 = "state1";
        String state2 = "state2";
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).state(state1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).state(state2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getState).containsOnly((Object[])new String[]{state1});
    }

    @Test
    void reprocessingOneTaskShouldOverWriteStateWhenProcessorSpecified() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        String state1 = "state1";
        String state2 = "state2";
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).state(state1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).state(state2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String transport = "transport";
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("processor", new Object[]{transport}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.spoolQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getState).containsOnly((Object[])new String[]{transport});
    }

    @Test
    void reprocessingOneTaskShouldEnqueueMailsOnSpecifiedQueue() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.customQueue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsOnly((Object[])new String[]{NAME_1});
    }

    @Test
    void reprocessingOneTaskShouldNotEnqueueUnknownMailKey() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).patch("myRepo/mails/unknown", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((Iterator)this.customQueue.browse()).toIterable().isEmpty();
    }

    @Test
    void reprocessingOneTaskShouldNotRemoveEmailWhenNotConsume() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("consume", new Object[]{false}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((long)mailRepository.size()).isEqualTo(2L);
    }

    @Test
    void reprocessingOneTaskShouldRemoveEmailWhenConsume() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).param("consume", new Object[]{true}).patch("myRepo/mails/name1", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((long)mailRepository.size()).isEqualTo(1L);
    }

    @Test
    void reprocessingOneTaskShouldNotRemoveMailFromRepositoryWhenUnknownMailKey() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).patch("myRepo/mails/unknown", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((long)mailRepository.size()).isEqualTo(2L);
    }

    @Test
    void reprocessingOneTaskShouldFailWhenUnknownMailKey() throws Exception {
        MailRepository mailRepository = this.mailRepositoryStore.create(URL_MY_REPO);
        mailRepository.store((Mail)FakeMail.builder().name(NAME_1).build());
        mailRepository.store((Mail)FakeMail.builder().name(NAME_2).build());
        String taskId = (String)((Response)RestAssured.with().param("action", new Object[]{"reprocess"}).param("queue", new Object[]{CUSTOM_QUEUE.asString()}).patch("myRepo/mails/unknown", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"failed"), new Object[0]);
    }

    private void createMailRepositoryStore() throws Exception {
        MemoryMailRepositoryUrlStore urlStore = new MemoryMailRepositoryUrlStore();
        MailRepositoryStoreConfiguration configuration = MailRepositoryStoreConfiguration.forItems((MailRepositoryStoreConfiguration.Item[])new MailRepositoryStoreConfiguration.Item[]{new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol("memory")), MemoryMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration()), new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol("other")), MemoryMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration())});
        this.mailRepositoryStore = new MemoryMailRepositoryStore((MailRepositoryUrlStore)urlStore, (MailRepositoryLoader)new SimpleMailRepositoryLoader(), configuration);
        this.mailRepositoryStore.init();
    }
}

