/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dropwizard;

import com.codahale.metrics.MetricRegistry;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.dropwizard.MetricsRoutes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MetricsRoutesTest {
    WebAdminServer webAdminServer;
    MetricRegistry registry;

    MetricsRoutesTest() {
    }

    @BeforeEach
    void setUp() {
        this.registry = new MetricRegistry();
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new MetricsRoutes(this.registry)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    void getShouldReturnSeveralMetric() {
        this.registry.counter("easy").inc();
        this.registry.counter("hard").inc();
        this.registry.counter("hard").inc();
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"# HELP hard Generated from Dropwizard metric import (metric=hard, type=com.codahale.metrics.Counter)\n# TYPE hard gauge\nhard 2.0\n# HELP easy Generated from Dropwizard metric import (metric=easy, type=com.codahale.metrics.Counter)\n# TYPE easy gauge\neasy 1.0"});
    }
}

