/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.webadmin.service.UsernameChangeService;
import org.apache.james.webadmin.service.UsernameChangeTask;
import org.apache.james.webadmin.service.UsernameChangeTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.UsernameChangeTaskDTO;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class UsernameChangeTaskSerializationTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final Username OLD_USERNAME = Username.of((String)"user");
    private static final Username NEW_USERNAME = Username.of((String)"geraldine");
    private static final UsernameChangeTaskStep.StepName STEP_A = new UsernameChangeTaskStep.StepName("A");
    private static final UsernameChangeTaskStep.StepName STEP_B = new UsernameChangeTaskStep.StepName("B");
    private static final UsernameChangeTaskStep.StepName STEP_C = new UsernameChangeTaskStep.StepName("C");
    private static final UsernameChangeTaskStep.StepName STEP_D = new UsernameChangeTaskStep.StepName("D");
    private static final UsernameChangeTaskStep A = UsernameChangeTaskSerializationTest.asStep(STEP_A);
    private static final UsernameChangeTaskStep B = UsernameChangeTaskSerializationTest.asStep(STEP_B);
    private static final UsernameChangeTaskStep C = UsernameChangeTaskSerializationTest.asStep(STEP_C);
    private static final UsernameChangeTaskStep D = UsernameChangeTaskSerializationTest.asStep(STEP_D);
    private static final String SERIALIZED_TASK = "{\"newUser\":\"geraldine\",\"oldUser\":\"user\",\"type\":\"UsernameChangeTask\"}";
    private static final String SERIALIZED_TASK_WITH_FROM_STEP = "{\"newUser\":\"geraldine\",\"fromStep\":\"B\",\"oldUser\":\"user\",\"type\":\"UsernameChangeTask\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION = "{  \"newUser\":\"geraldine\",  \"oldUser\":\"user\",  \"status\":{    \"A\":\"DONE\",    \"B\":\"WAITING\",    \"C\":\"FAILED\",    \"D\":\"ABORTED\"},  \"timestamp\":\"2018-11-13T12:00:55Z\",  \"type\":\"UsernameChangeTask\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION_WITH_STEP_NAME = "{  \"newUser\":\"geraldine\",  \"oldUser\":\"user\",  \"fromStep\":\"B\",  \"status\":{    \"A\":\"DONE\",    \"B\":\"WAITING\",    \"C\":\"FAILED\",    \"D\":\"ABORTED\"},  \"timestamp\":\"2018-11-13T12:00:55Z\",  \"type\":\"UsernameChangeTask\"}";
    private static final UsernameChangeService SERVICE = new UsernameChangeService((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D));

    UsernameChangeTaskSerializationTest() {
    }

    private static UsernameChangeTaskStep asStep(final UsernameChangeTaskStep.StepName name) {
        return new UsernameChangeTaskStep(){

            public UsernameChangeTaskStep.StepName name() {
                return name;
            }

            public int priority() {
                return 0;
            }

            public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
                return Mono.empty();
            }
        };
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)UsernameChangeTaskDTO.module((UsernameChangeService)SERVICE)).bean((Object)new UsernameChangeTask(SERVICE, OLD_USERNAME, NEW_USERNAME, Optional.empty())).json(SERIALIZED_TASK).verify();
    }

    @Test
    void taskShouldBeSerializableWithFromStep() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)UsernameChangeTaskDTO.module((UsernameChangeService)SERVICE)).bean((Object)new UsernameChangeTask(SERVICE, OLD_USERNAME, NEW_USERNAME, Optional.of(STEP_B))).json(SERIALIZED_TASK_WITH_FROM_STEP).verify();
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)UsernameChangeTaskAdditionalInformationDTO.module()).bean((Object)new UsernameChangeTask.AdditionalInformation(TIMESTAMP, OLD_USERNAME, NEW_USERNAME, (Map)ImmutableMap.of((Object)STEP_A, (Object)UsernameChangeService.StepState.DONE, (Object)STEP_B, (Object)UsernameChangeService.StepState.WAITING, (Object)STEP_C, (Object)UsernameChangeService.StepState.FAILED, (Object)STEP_D, (Object)UsernameChangeService.StepState.ABORTED), Optional.empty())).json(SERIALIZED_ADDITIONAL_INFORMATION).verify();
    }

    @Test
    void additionalInformationShouldBeSerializableWithStepName() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)UsernameChangeTaskAdditionalInformationDTO.module()).bean((Object)new UsernameChangeTask.AdditionalInformation(TIMESTAMP, OLD_USERNAME, NEW_USERNAME, (Map)ImmutableMap.of((Object)STEP_A, (Object)UsernameChangeService.StepState.DONE, (Object)STEP_B, (Object)UsernameChangeService.StepState.WAITING, (Object)STEP_C, (Object)UsernameChangeService.StepState.FAILED, (Object)STEP_D, (Object)UsernameChangeService.StepState.ABORTED), Optional.of(STEP_B))).json(SERIALIZED_ADDITIONAL_INFORMATION_WITH_STEP_NAME).verify();
    }
}

