/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Set;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.task.Task;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTask;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DeleteUsersDataOfDomainTaskTest {
    private static final Domain DOMAIN_1 = Domain.of((String)"domain1.tld");
    private static final Domain DOMAIN_2 = Domain.of((String)"domain2.tld");
    private DeleteUserDataService service;
    private MemoryUsersRepository usersRepository;

    DeleteUsersDataOfDomainTaskTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        Mockito.when((Object)dnsService.getHostName((InetAddress)ArgumentMatchers.any())).thenReturn((Object)"localhost");
        Mockito.when((Object)dnsService.getLocalHost()).thenReturn((Object)InetAddress.getByName("localhost"));
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
        domainList.addDomain(DOMAIN_1);
        domainList.addDomain(DOMAIN_2);
        this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
    }

    @Test
    void shouldCountSuccessfulUsers() throws UsersRepositoryException {
        this.usersRepository.addUser(Username.of((String)"user1@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user2@domain1.tld"), "password");
        this.service = new DeleteUserDataService(Set.of());
        DeleteUsersDataOfDomainTask task = new DeleteUsersDataOfDomainTask(this.service, DOMAIN_1, (UsersRepository)this.usersRepository);
        Task.Result result = task.run();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
            softly.assertThat(task.getContext().getSuccessfulUsersCount()).isEqualTo(2L);
            softly.assertThat(task.getContext().getFailedUsersCount()).isEqualTo(0L);
        });
    }

    @Test
    void shouldCountOnlySuccessfulUsersOfRequestedDomain() throws UsersRepositoryException {
        this.usersRepository.addUser(Username.of((String)"user1@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user2@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user3@domain2.tld"), "password");
        this.service = new DeleteUserDataService(Set.of());
        DeleteUsersDataOfDomainTask task = new DeleteUsersDataOfDomainTask(this.service, DOMAIN_1, (UsersRepository)this.usersRepository);
        Task.Result result = task.run();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
            softly.assertThat(task.getContext().getSuccessfulUsersCount()).isEqualTo(2L);
            softly.assertThat(task.getContext().getFailedUsersCount()).isEqualTo(0L);
        });
    }

    @Test
    void shouldCountFailedUsers() throws UsersRepositoryException {
        this.usersRepository.addUser(Username.of((String)"user1@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user2@domain1.tld"), "password");
        Set<Username> usersTobeFailed = Set.of(Username.of((String)"user1@domain1.tld"), Username.of((String)"user2@domain1.tld"));
        this.service = new DeleteUserDataService(Set.of(new FailureStepUponUser(usersTobeFailed)));
        DeleteUsersDataOfDomainTask task = new DeleteUsersDataOfDomainTask(this.service, DOMAIN_1, (UsersRepository)this.usersRepository);
        Task.Result result = task.run();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)result).isEqualTo((Object)Task.Result.PARTIAL);
            softly.assertThat(task.getContext().getSuccessfulUsersCount()).isEqualTo(0L);
            softly.assertThat(task.getContext().getFailedUsersCount()).isEqualTo(2L);
            softly.assertThat((Collection)task.getContext().getFailedUsers()).containsExactlyInAnyOrder((Object[])new Username[]{Username.of((String)"user1@domain1.tld"), Username.of((String)"user2@domain1.tld")});
        });
    }

    @Test
    void shouldCountOnlyFailedUsersOfRequestedDomain() throws UsersRepositoryException {
        this.usersRepository.addUser(Username.of((String)"user1@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user2@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user3@domain2.tld"), "password");
        Set<Username> usersTobeFailed = Set.of(Username.of((String)"user1@domain1.tld"), Username.of((String)"user2@domain1.tld"), Username.of((String)"user3@domain2.tld"));
        this.service = new DeleteUserDataService(Set.of(new FailureStepUponUser(usersTobeFailed)));
        DeleteUsersDataOfDomainTask task = new DeleteUsersDataOfDomainTask(this.service, DOMAIN_1, (UsersRepository)this.usersRepository);
        Task.Result result = task.run();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)result).isEqualTo((Object)Task.Result.PARTIAL);
            softly.assertThat(task.getContext().getSuccessfulUsersCount()).isEqualTo(0L);
            softly.assertThat(task.getContext().getFailedUsersCount()).isEqualTo(2L);
            softly.assertThat((Collection)task.getContext().getFailedUsers()).containsExactlyInAnyOrder((Object[])new Username[]{Username.of((String)"user1@domain1.tld"), Username.of((String)"user2@domain1.tld")});
        });
    }

    @Test
    void mixedSuccessfulAndFailedUsersCase() throws UsersRepositoryException {
        this.usersRepository.addUser(Username.of((String)"user1@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user2@domain1.tld"), "password");
        this.usersRepository.addUser(Username.of((String)"user3@domain1.tld"), "password");
        Set<Username> usersTobeFailed = Set.of(Username.of((String)"user1@domain1.tld"));
        this.service = new DeleteUserDataService(Set.of(new FailureStepUponUser(usersTobeFailed)));
        DeleteUsersDataOfDomainTask task = new DeleteUsersDataOfDomainTask(this.service, DOMAIN_1, (UsersRepository)this.usersRepository);
        Task.Result result = task.run();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)result).isEqualTo((Object)Task.Result.PARTIAL);
            softly.assertThat(task.getContext().getSuccessfulUsersCount()).isEqualTo(2L);
            softly.assertThat(task.getContext().getFailedUsersCount()).isEqualTo(1L);
            softly.assertThat((Collection)task.getContext().getFailedUsers()).containsExactly((Object[])new Username[]{Username.of((String)"user1@domain1.tld")});
        });
    }

    public static class FailureStepUponUser
    implements DeleteUserDataTaskStep {
        private final Set<Username> usersToBeFailed;

        public FailureStepUponUser(Set<Username> usersToBeFailed) {
            this.usersToBeFailed = usersToBeFailed;
        }

        public DeleteUserDataTaskStep.StepName name() {
            return new DeleteUserDataTaskStep.StepName("FailureStepUponUser");
        }

        public int priority() {
            return 0;
        }

        public Publisher<Void> deleteUserData(Username username) {
            if (this.usersToBeFailed.contains(username)) {
                return Mono.error((Throwable)new RuntimeException());
            }
            return Mono.empty();
        }
    }
}

