/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Set;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTask;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTaskDTO;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DeleteUsersDataOfDomainTaskSerializationTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final Domain DOMAIN = Domain.of((String)"domain");
    private static final long SUCCESSFUL_USERS_COUNT = 99L;
    private static final long FAILED_USERS_COUNT = 1L;
    private static final Set<Username> FAILED_USERS = Set.of(Username.of((String)"faileduser@domain"));
    private static final DeleteUserDataTaskStep.StepName STEP_A = new DeleteUserDataTaskStep.StepName("A");
    private static final DeleteUserDataTaskStep.StepName STEP_B = new DeleteUserDataTaskStep.StepName("B");
    private static final DeleteUserDataTaskStep.StepName STEP_C = new DeleteUserDataTaskStep.StepName("C");
    private static final DeleteUserDataTaskStep.StepName STEP_D = new DeleteUserDataTaskStep.StepName("D");
    private static final DeleteUserDataTaskStep A = DeleteUsersDataOfDomainTaskSerializationTest.asStep(STEP_A);
    private static final DeleteUserDataTaskStep B = DeleteUsersDataOfDomainTaskSerializationTest.asStep(STEP_B);
    private static final DeleteUserDataTaskStep C = DeleteUsersDataOfDomainTaskSerializationTest.asStep(STEP_C);
    private static final DeleteUserDataTaskStep D = DeleteUsersDataOfDomainTaskSerializationTest.asStep(STEP_D);
    private static final String SERIALIZED_TASK = "{\"type\":\"DeleteUsersDataOfDomainTask\",\"domain\":\"domain\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION = "{\n  \"type\": \"DeleteUsersDataOfDomainTask\",\n  \"domain\": \"domain\",\n  \"successfulUsersCount\": 99,\n  \"failedUsersCount\": 1,\n  \"failedUsers\": [\"faileduser@domain\"],\n  \"timestamp\": \"2018-11-13T12:00:55Z\"\n}";
    private static final DeleteUserDataService SERVICE = new DeleteUserDataService((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D));

    DeleteUsersDataOfDomainTaskSerializationTest() {
    }

    private static DeleteUserDataTaskStep asStep(final DeleteUserDataTaskStep.StepName name) {
        return new DeleteUserDataTaskStep(){

            public DeleteUserDataTaskStep.StepName name() {
                return name;
            }

            public int priority() {
                return 0;
            }

            public Publisher<Void> deleteUserData(Username username) {
                return Mono.empty();
            }
        };
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        UsersRepository usersRepository = (UsersRepository)Mockito.mock(UsersRepository.class);
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUsersDataOfDomainTaskDTO.module((DeleteUserDataService)SERVICE, (UsersRepository)usersRepository)).bean((Object)new DeleteUsersDataOfDomainTask(SERVICE, DOMAIN, usersRepository)).json(SERIALIZED_TASK).verify();
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUsersDataOfDomainTaskAdditionalInformationDTO.module()).bean((Object)new DeleteUsersDataOfDomainTask.AdditionalInformation(TIMESTAMP, DOMAIN, 99L, 1L, FAILED_USERS)).json(SERIALIZED_ADDITIONAL_INFORMATION).verify();
    }
}

