/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUserDataTask;
import org.apache.james.webadmin.service.DeleteUserDataTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.DeleteUserDataTaskDTO;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DeleteUserDataTaskSerializationTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final Username USERNAME = Username.of((String)"user");
    private static final DeleteUserDataTaskStep.StepName STEP_A = new DeleteUserDataTaskStep.StepName("A");
    private static final DeleteUserDataTaskStep.StepName STEP_B = new DeleteUserDataTaskStep.StepName("B");
    private static final DeleteUserDataTaskStep.StepName STEP_C = new DeleteUserDataTaskStep.StepName("C");
    private static final DeleteUserDataTaskStep.StepName STEP_D = new DeleteUserDataTaskStep.StepName("D");
    private static final DeleteUserDataTaskStep A = DeleteUserDataTaskSerializationTest.asStep(STEP_A);
    private static final DeleteUserDataTaskStep B = DeleteUserDataTaskSerializationTest.asStep(STEP_B);
    private static final DeleteUserDataTaskStep C = DeleteUserDataTaskSerializationTest.asStep(STEP_C);
    private static final DeleteUserDataTaskStep D = DeleteUserDataTaskSerializationTest.asStep(STEP_D);
    private static final String SERIALIZED_TASK = "{\"username\":\"user\",\"type\":\"DeleteUserDataTask\"}";
    private static final String SERIALIZED_TASK_WITH_FROM_STEP = "{\"fromStep\":\"B\",\"username\":\"user\",\"type\":\"DeleteUserDataTask\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION = "{  \"username\":\"user\",  \"status\":{    \"A\":\"DONE\",    \"B\":\"WAITING\",    \"C\":\"FAILED\",    \"D\":\"ABORTED\"},  \"timestamp\":\"2018-11-13T12:00:55Z\",  \"type\":\"DeleteUserDataTask\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION_WITH_STEP_NAME = "{  \"username\":\"user\",  \"fromStep\":\"B\",  \"status\":{    \"A\":\"DONE\",    \"B\":\"WAITING\",    \"C\":\"FAILED\",    \"D\":\"ABORTED\"},  \"timestamp\":\"2018-11-13T12:00:55Z\",  \"type\":\"DeleteUserDataTask\"}";
    private static final DeleteUserDataService SERVICE = new DeleteUserDataService((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D));

    DeleteUserDataTaskSerializationTest() {
    }

    private static DeleteUserDataTaskStep asStep(final DeleteUserDataTaskStep.StepName name) {
        return new DeleteUserDataTaskStep(){

            public DeleteUserDataTaskStep.StepName name() {
                return name;
            }

            public int priority() {
                return 0;
            }

            public Publisher<Void> deleteUserData(Username username) {
                return Mono.empty();
            }
        };
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUserDataTaskDTO.module((DeleteUserDataService)SERVICE)).bean((Object)new DeleteUserDataTask(SERVICE, USERNAME, Optional.empty())).json(SERIALIZED_TASK).verify();
    }

    @Test
    void taskShouldBeSerializableWithFromStep() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUserDataTaskDTO.module((DeleteUserDataService)SERVICE)).bean((Object)new DeleteUserDataTask(SERVICE, USERNAME, Optional.of(STEP_B))).json(SERIALIZED_TASK_WITH_FROM_STEP).verify();
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUserDataTaskAdditionalInformationDTO.module()).bean((Object)new DeleteUserDataTask.AdditionalInformation(TIMESTAMP, USERNAME, (Map)ImmutableMap.of((Object)STEP_A, (Object)DeleteUserDataService.StepState.DONE, (Object)STEP_B, (Object)DeleteUserDataService.StepState.WAITING, (Object)STEP_C, (Object)DeleteUserDataService.StepState.FAILED, (Object)STEP_D, (Object)DeleteUserDataService.StepState.ABORTED), Optional.empty())).json(SERIALIZED_ADDITIONAL_INFORMATION).verify();
    }

    @Test
    void additionalInformationShouldBeSerializableWithStepName() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteUserDataTaskAdditionalInformationDTO.module()).bean((Object)new DeleteUserDataTask.AdditionalInformation(TIMESTAMP, USERNAME, (Map)ImmutableMap.of((Object)STEP_A, (Object)DeleteUserDataService.StepState.DONE, (Object)STEP_B, (Object)DeleteUserDataService.StepState.WAITING, (Object)STEP_C, (Object)DeleteUserDataService.StepState.FAILED, (Object)STEP_D, (Object)DeleteUserDataService.StepState.ABORTED), Optional.of(STEP_B))).json(SERIALIZED_ADDITIONAL_INFORMATION_WITH_STEP_NAME).verify();
    }
}

