/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.james.DefaultVacationService;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.mock.SimpleDomainList;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.util.date.DefaultZonedDateTimeProvider;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.api.VacationService;
import org.apache.james.vacation.memory.MemoryNotificationRegistry;
import org.apache.james.vacation.memory.MemoryVacationRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.VacationRoutes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class VacationRoutesTest {
    private static final String BOB = "bob@example.org";
    private static final String ALICE = "alice@example.org";
    private static final String CAROL = "carol@example.org";
    private static final Domain DOMAIN = Domain.of((String)"example.org");
    private static final Vacation VACATION = Vacation.builder().enabled(false).fromDate(Optional.of(ZonedDateTime.parse("2021-09-13T10:00:00Z"))).toDate(Optional.of(ZonedDateTime.parse("2021-09-20T19:00:00Z"))).subject(Optional.of("I am on vacation")).textBody(Optional.of("I am on vacation, will be back soon.")).htmlBody(Optional.of("<p>I am on vacation, will be back soon.</p>")).build();
    private WebAdminServer webAdminServer;
    private VacationService vacationService;

    VacationRoutesTest() {
    }

    private static String isoString(ZonedDateTime date) {
        return date.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.vacationService = new DefaultVacationService((VacationRepository)new MemoryVacationRepository(), (NotificationRegistry)new MemoryNotificationRegistry((ZonedDateTimeProvider)new DefaultZonedDateTimeProvider()));
        SimpleDomainList domainList = new SimpleDomainList();
        domainList.addDomain(DOMAIN);
        MemoryUsersRepository usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
        VacationRoutes vacationRoutes = new VacationRoutes(this.vacationService, (UsersRepository)usersRepository, new JsonTransformer(new JsonTransformerModule[0]));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{vacationRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        usersRepository.addUser(Username.of((String)BOB), "secret");
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void getVacation() {
        this.vacationService.modifyVacation(AccountId.fromString((String)BOB), VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/vacation/bob@example.org", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("enabled", Matchers.equalTo((Object)VACATION.isEnabled()), new Object[0])).body("fromDate", Matchers.equalTo((Object)VacationRoutesTest.isoString((ZonedDateTime)VACATION.getFromDate().get())), new Object[0])).body("toDate", Matchers.equalTo((Object)VacationRoutesTest.isoString((ZonedDateTime)VACATION.getToDate().get())), new Object[0])).body("subject", Matchers.equalTo((Object)((String)VACATION.getSubject().get())), new Object[0])).body("textBody", Matchers.equalTo((Object)((String)VACATION.getTextBody().get())), new Object[0])).body("htmlBody", Matchers.equalTo((Object)((String)VACATION.getHtmlBody().get())), new Object[0]);
    }

    @Test
    void getVacationFails() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/vacation/carol@example.org", new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)"The user 'carol@example.org' does not exist"), new Object[0]);
    }

    @Test
    void postVacationCreates() {
        AccountId bob = AccountId.fromString((String)BOB);
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"enabled\":true,\"fromDate\":\"2021-09-20T10:00:00Z\",\"toDate\":\"2021-09-27T18:00:00Z\",\"subject\":\"On vacation again\",\"textBody\":\"Need more vacation!\",\"htmlBody\":\"<p>Need more vacation!</p>\"}").when().post("/vacation/bob@example.org", new Object[0])).then()).statusCode(204);
        Vacation vacation = (Vacation)this.vacationService.retrieveVacation(bob).block();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)vacation).isNotNull();
            softly.assertThat(vacation.isEnabled()).isTrue();
            softly.assertThat(vacation.getFromDate()).isEqualTo(Optional.of(ZonedDateTime.parse("2021-09-20T10:00:00Z")));
            softly.assertThat(vacation.getToDate()).isEqualTo(Optional.of(ZonedDateTime.parse("2021-09-27T18:00:00Z")));
            softly.assertThat(vacation.getSubject()).isEqualTo(Optional.of("On vacation again"));
            softly.assertThat(vacation.getTextBody()).isEqualTo(Optional.of("Need more vacation!"));
            softly.assertThat(vacation.getHtmlBody()).isEqualTo(Optional.of("<p>Need more vacation!</p>"));
        });
    }

    @Test
    void postVacationUpdatesAll() throws Exception {
        AccountId bob = AccountId.fromString((String)BOB);
        RecipientId alice = RecipientId.fromMailAddress((MailAddress)new MailAddress(ALICE));
        this.vacationService.modifyVacation(bob, VacationPatch.builderFrom((Vacation)VACATION).build()).then(this.vacationService.registerNotification(bob, alice, Optional.empty())).block();
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"enabled\":true,\"fromDate\":\"2021-09-20T10:00:00Z\",\"toDate\":\"2021-09-27T18:00:00Z\",\"subject\":\"On vacation again\",\"textBody\":\"Need more vacation!\",\"htmlBody\":\"<p>Need more vacation!</p>\"}").when().post("/vacation/bob@example.org", new Object[0])).then()).statusCode(204);
        Vacation vacation = (Vacation)this.vacationService.retrieveVacation(bob).block();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)vacation).isNotNull();
            softly.assertThat(vacation.isEnabled()).isTrue();
            softly.assertThat(vacation.getFromDate()).isEqualTo(Optional.of(ZonedDateTime.parse("2021-09-20T10:00:00Z")));
            softly.assertThat(vacation.getToDate()).isEqualTo(Optional.of(ZonedDateTime.parse("2021-09-27T18:00:00Z")));
            softly.assertThat(vacation.getSubject()).isEqualTo(Optional.of("On vacation again"));
            softly.assertThat(vacation.getTextBody()).isEqualTo(Optional.of("Need more vacation!"));
            softly.assertThat(vacation.getHtmlBody()).isEqualTo(Optional.of("<p>Need more vacation!</p>"));
        });
        Boolean registered = (Boolean)this.vacationService.isNotificationRegistered(bob, alice).block();
        Assertions.assertThat((Boolean)registered).isFalse();
    }

    @Test
    void postVacationUpdatesPartial() throws Exception {
        AccountId bob = AccountId.fromString((String)BOB);
        RecipientId alice = RecipientId.fromMailAddress((MailAddress)new MailAddress(ALICE));
        this.vacationService.modifyVacation(bob, VacationPatch.builderFrom((Vacation)VACATION).build()).then(this.vacationService.registerNotification(bob, alice, Optional.empty())).block();
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"enabled\":true,\"subject\":\"More vacation\"}").when().post("/vacation/bob@example.org", new Object[0])).then()).statusCode(204);
        Vacation vacation = (Vacation)this.vacationService.retrieveVacation(bob).block();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)vacation).isNotNull();
            softly.assertThat(vacation.isEnabled()).isTrue();
            softly.assertThat(vacation.getFromDate()).isEqualTo((Object)VACATION.getFromDate());
            softly.assertThat(vacation.getToDate()).isEqualTo((Object)VACATION.getToDate());
            softly.assertThat(vacation.getSubject()).isEqualTo(Optional.of("More vacation"));
            softly.assertThat(vacation.getTextBody()).isEqualTo((Object)VACATION.getTextBody());
            softly.assertThat(vacation.getHtmlBody()).isEqualTo((Object)VACATION.getHtmlBody());
        });
        Boolean registered = (Boolean)this.vacationService.isNotificationRegistered(bob, alice).block();
        Assertions.assertThat((Boolean)registered).isFalse();
    }

    @Test
    void postVacationFails() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"enabled\":true,\"subject\":\"On vacation again\"}").when().post("/vacation/carol@example.org", new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)"The user 'carol@example.org' does not exist"), new Object[0]);
    }

    @Test
    void postVacationHandlesBadJson() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{not really a JSON object}").when().post("/vacation/bob@example.org", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0]);
    }

    @Test
    void deleteVacation() throws Exception {
        AccountId bob = AccountId.fromString((String)BOB);
        RecipientId alice = RecipientId.fromMailAddress((MailAddress)new MailAddress(ALICE));
        this.vacationService.modifyVacation(bob, VacationPatch.builderFrom((Vacation)VACATION).build()).then(this.vacationService.registerNotification(bob, alice, Optional.empty())).block();
        ((ValidatableResponse)((Response)RestAssured.when().delete("/vacation/bob@example.org", new Object[0])).then()).statusCode(204);
        Vacation vacation = (Vacation)this.vacationService.retrieveVacation(bob).block();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)vacation).isNotNull();
            softly.assertThat(vacation.isEnabled()).isFalse();
            softly.assertThat(vacation.getFromDate()).isEmpty();
            softly.assertThat(vacation.getToDate()).isEmpty();
            softly.assertThat(vacation.getSubject()).isEmpty();
            softly.assertThat(vacation.getTextBody()).isEmpty();
            softly.assertThat(vacation.getHtmlBody()).isEmpty();
        });
        Boolean registered = (Boolean)this.vacationService.isNotificationRegistered(bob, alice).block();
        Assertions.assertThat((Boolean)registered).isFalse();
    }

    @Test
    void deleteVacationFails() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("/vacation/carol@example.org", new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)"The user 'carol@example.org' does not exist"), new Object[0]);
    }
}

