/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.api.mock.SimpleDomainList;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.memory.MemoryDelegationStore;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.UserRoutes;
import org.apache.james.webadmin.service.UserService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class UserRoutesTest {
    private static final String GET_DELEGATED_USERS_PATH = "/%s/authorizedUsers";
    private static final String CLEAR_DELEGATED_USERS_PATH = "/%s/authorizedUsers";
    private static final String ADD_DELEGATED_USER_PATH = "/%s/authorizedUsers/%s";
    private static final String REMOVE_DELEGATED_USER_PATH = "/%s/authorizedUsers/%s";
    private static final Domain DOMAIN = Domain.of((String)"domain");
    private static final Username USERNAME_WITHOUT_DOMAIN = Username.of((String)"username");
    private static final Username USERNAME_WITH_DOMAIN = Username.fromLocalPartWithDomain((String)USERNAME_WITHOUT_DOMAIN.asString(), (Domain)DOMAIN);
    private static final Username OTHER_USERNAME_WITH_DOMAIN = Username.fromLocalPartWithDomain((String)"other", (Domain)DOMAIN);
    private static final Username ALICE = Username.fromLocalPartWithDomain((String)"alice", (Domain)DOMAIN);
    private static final Username BOB = Username.fromLocalPartWithDomain((String)"bob", (Domain)DOMAIN);
    private static final Username ANDRE = Username.fromLocalPartWithDomain((String)"andre", (Domain)DOMAIN);
    private static final String PASSWORD = "password";

    UserRoutesTest() {
    }

    @Nested
    class WithoutVirtualHosting
    implements UserRoutesContract.AllContracts {
        @RegisterExtension
        UserRoutesExtension extension = UserRoutesExtension.withoutVirtualHosting();

        WithoutVirtualHosting(UserRoutesTest this$0) throws DomainListException {
        }

        @Test
        void headShouldReturnOKWhenUserExists() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().head(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(200);
        }

        @Test
        void headShouldReturnNotFoundWhenUserDoesNotExist() {
            ((ValidatableResponse)((Response)RestAssured.when().head(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(404);
        }

        @Test
        void puttingWithoutDomainPartInUsernameTwoTimesShouldNotBeAllowed() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(409);
            List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)users).containsExactly((Object[])new Map[]{ImmutableMap.of((Object)"username", (Object)USERNAME_WITHOUT_DOMAIN.asString())});
        }

        @Test
        void putWithoutDomainPartInUsernameShouldReturnOkWhenWithA255LongUsername() {
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(StringUtils.repeat((char)'j', (int)(255 - USERNAME_WITHOUT_DOMAIN.asString().length())) + USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
        }

        @Test
        void putWithoutDomainPartInUsernameShouldAddTheUser() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)users).containsExactly((Object[])new Map[]{ImmutableMap.of((Object)"username", (Object)USERNAME_WITHOUT_DOMAIN.asString())});
        }

        @Test
        void putWithoutDomainPartInUsernameWithExistingUsernameAndNonForceParamShouldNotBeAllowed() {
            RestAssured.given().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(409)).body("statusCode", Matchers.is((Object)409), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.WRONG_STATE.getType()), new Object[0])).body("message", Matchers.is((Object)"'username' user already exist"), new Object[0]);
        }

        @Test
        void putWithoutDomainPartInUsernameWithExistingUsernameAndForceParamShouldBeAllowed() {
            RestAssured.given().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").queryParam("force", new Object[0]).when().put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
        }

        @Test
        void putShouldReturnBadRequestWhenUsernameHasDomainPart() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Username supplied is invalid"), new Object[0])).body("details", Matchers.is((Object)"Given Username contains a @domainpart but virtualhosting support is disabled"), new Object[0]);
        }

        @Test
        void putWithoutDomainPartInUsernameShouldReturnOkWhenValidJsonBody() {
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
        }

        @Test
        void verifyShouldReturnOkWhenUserPasswordMatches() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().post(USERNAME_WITHOUT_DOMAIN.asString() + "/verify", new Object[0])).then()).statusCode(204);
        }

        @Test
        void verifyShouldReturnUnauthorizedWhenUserPasswordDoesntMatch() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"false\"}").when().post(USERNAME_WITHOUT_DOMAIN.asString() + "/verify", new Object[0])).then()).statusCode(401);
        }

        @Test
        void verifyShouldReturnUnauthorizedWhenUserDoesNotExist() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITHOUT_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().post("/NOTusername/verify", new Object[0])).then()).statusCode(401);
        }

        @Nested
        class IllegalCharacterErrorHandlingTest
        implements UserRoutesContract.IllegalCharactersErrorHandlingContract {
            IllegalCharacterErrorHandlingTest(WithoutVirtualHosting this$1) {
            }
        }
    }

    @Nested
    class WithVirtualHosting
    implements UserRoutesContract.AllContracts {
        @RegisterExtension
        UserRoutesExtension extension = UserRoutesExtension.withVirtualHosting();

        WithVirtualHosting(UserRoutesTest this$0) throws DomainListException {
        }

        @Test
        void headShouldReturnOKWhenUserExists() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().head(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(200);
        }

        @Test
        void headShouldReturnNotFoundWhenUserDoesNotExist() {
            ((ValidatableResponse)((Response)RestAssured.when().head(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(404);
        }

        @Test
        void puttingWithDomainPartInUsernameTwoTimesShouldNotBeAllowed() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(409);
            List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)users).containsExactly((Object[])new Map[]{ImmutableMap.of((Object)"username", (Object)USERNAME_WITH_DOMAIN.asString())});
        }

        @Test
        void putShouldFailWhenConflictWithAlias(RecipientRewriteTable recipientRewriteTable) throws Exception {
            recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)USERNAME_WITH_DOMAIN), OTHER_USERNAME_WITH_DOMAIN.asString());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(409)).body("statusCode", Matchers.is((Object)409), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.WRONG_STATE.getType()), new Object[0])).body("message", Matchers.is((Object)"'username@domain' already have associated mappings: alias:other@domain"), new Object[0]);
        }

        @Test
        void putShouldFailWhenConflictWithGroup(RecipientRewriteTable recipientRewriteTable) throws Exception {
            recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)USERNAME_WITH_DOMAIN), OTHER_USERNAME_WITH_DOMAIN.asString());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(409)).body("statusCode", Matchers.is((Object)409), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.WRONG_STATE.getType()), new Object[0])).body("message", Matchers.is((Object)"'username@domain' already have associated mappings: group:other@domain"), new Object[0]);
        }

        @Test
        void putWithDomainPartInUsernameShouldReturnOkWhenWithA255LongUsername() {
            String usernameTail = "@" + DOMAIN.name();
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(StringUtils.repeat((char)'j', (int)(255 - usernameTail.length())) + usernameTail, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putWithDomainPartInUsernameShouldAddTheUser() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)users).containsExactly((Object[])new Map[]{ImmutableMap.of((Object)"username", (Object)USERNAME_WITH_DOMAIN.asString())});
        }

        @Test
        void putShouldReturnBadRequestWhenUsernameDoesNotHaveDomainPart() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put("justLocalPart", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Username supplied is invalid"), new Object[0])).body("details", Matchers.is((Object)"Given Username needs to contain a @domainpart"), new Object[0]);
        }

        @Test
        void putWithDomainPartInUsernameWithExistingUsernameAndNonForceParamShouldNotBeAllowed() {
            RestAssured.given().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(409)).body("statusCode", Matchers.is((Object)409), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.WRONG_STATE.getType()), new Object[0])).body("message", Matchers.is((Object)"'username@domain' user already exist"), new Object[0]);
        }

        @Test
        void putWithDomainPartInUsernameWithExistingUsernameAndForceParamShouldBeAllowed() {
            RestAssured.given().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").queryParam("force", new Object[0]).when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
        }

        @Test
        void putWithDomainPartInUsernameShouldReturnOkWhenValidJsonBody() {
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
        }

        @Test
        void allowedFromHeadersShouldHaveUsersMailAddress() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            List allowedFroms = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(USERNAME_WITH_DOMAIN.asString() + "/allowedFromHeaders", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)allowedFroms).containsExactly((Object[])new String[]{USERNAME_WITH_DOMAIN.asString()});
        }

        @Test
        void allowedFromHeadersShouldHaveAllMailAddressesWhenAliasAdded(RecipientRewriteTable recipientRewriteTable) throws RecipientRewriteTableException {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            String aliasAddress = "alias@" + DOMAIN.asString();
            recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)aliasAddress)), USERNAME_WITH_DOMAIN.asString());
            List allowedFroms = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(USERNAME_WITH_DOMAIN.asString() + "/allowedFromHeaders", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)allowedFroms).containsExactly((Object[])new String[]{USERNAME_WITH_DOMAIN.asString(), aliasAddress});
        }

        @Test
        void allowedFromHeadersShouldReturn404WhenUserDoesNotExist() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(USERNAME_WITH_DOMAIN.asString() + "/allowedFromHeaders", new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"user 'username@domain' does not exist"), new Object[0]);
        }

        @Test
        void allowedFromHeadersShouldReturn404WhenUserIsInvalid() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("@@/allowedFromHeaders", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0]);
        }

        @Test
        void verifyShouldReturnOkWhenUserPasswordMatches() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().post(USERNAME_WITH_DOMAIN.asString() + "/verify", new Object[0])).then()).statusCode(204);
        }

        @Test
        void verifyShouldReturnUnauthorizedWhenUserPasswordDoesntMatch() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"false\"}").when().post(USERNAME_WITH_DOMAIN.asString() + "/verify", new Object[0])).then()).statusCode(401);
        }

        @Test
        void verifyShouldReturnUnauthorizedWhenUserDoesNotExist() {
            RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().post("/NOTusername@domain/verify", new Object[0])).then()).statusCode(401);
        }

        @Nested
        class IllegalCharacterErrorHandlingTest
        implements UserRoutesContract.IllegalCharactersErrorHandlingContract {
            IllegalCharacterErrorHandlingTest(WithVirtualHosting this$1) {
            }
        }
    }

    static interface UserRoutesContract {

        public static interface MockBehaviorErrorHandlingContract {
            @Test
            default public void deleteShouldStillBeOkWhenNoUser(UsersRepository usersRepository) throws Exception {
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new UsersRepositoryException("message")}).when((Object)usersRepository)).removeUser(USERNAME_WITH_DOMAIN);
                ((ValidatableResponse)((Response)RestAssured.when().delete(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
            }

            @Test
            default public void getShouldFailOnRepositoryException(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.list()).thenThrow(new Throwable[]{new UsersRepositoryException("message")});
                ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
            }

            @Test
            default public void putShouldFailOnRepositoryExceptionOnGetUserByName(UsersRepository usersRepository) throws Exception {
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new UsersRepositoryException("message")}).when((Object)usersRepository)).contains((Username)ArgumentMatchers.any(Username.class));
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void putShouldReturnInternalServerErrorWhenUserRepositoryAddingUserError(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.getUserByName(USERNAME_WITH_DOMAIN)).thenReturn(null);
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new UsersRepositoryException("message")}).when((Object)usersRepository)).addUser(USERNAME_WITH_DOMAIN, UserRoutesTest.PASSWORD);
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void putShouldReturnInternalServerErrorWhenUserRepositoryUpdatingUserError(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.getUserByName(USERNAME_WITH_DOMAIN)).thenReturn((Object)((User)Mockito.mock(User.class)));
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new UsersRepositoryException("message")}).when((Object)usersRepository)).updateUser((User)ArgumentMatchers.any());
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("force", new Object[0]).body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void deleteShouldFailOnUnknownException(UsersRepository usersRepository) throws Exception {
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)usersRepository)).removeUser(USERNAME_WITH_DOMAIN);
                ((ValidatableResponse)((Response)RestAssured.when().delete(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void getShouldFailOnUnknownException(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.list()).thenThrow(new Throwable[]{new RuntimeException()});
                ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
            }

            @Test
            default public void putShouldFailOnUnknownExceptionOnGetUserByName(UsersRepository usersRepository) throws Exception {
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)usersRepository)).contains((Username)ArgumentMatchers.any(Username.class));
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void putShouldFailOnUnknownExceptionOnAddUser(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.getUserByName(USERNAME_WITH_DOMAIN)).thenReturn(null);
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)usersRepository)).addUser(USERNAME_WITH_DOMAIN, UserRoutesTest.PASSWORD);
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }

            @Test
            default public void putShouldFailOnUnknownExceptionOnGetUpdateUser(UsersRepository usersRepository) throws Exception {
                Mockito.when((Object)usersRepository.getUserByName(USERNAME_WITH_DOMAIN)).thenReturn((Object)((User)Mockito.mock(User.class)));
                ((UsersRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)usersRepository)).updateUser((User)ArgumentMatchers.any());
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("force", new Object[0]).body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(500);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        public static interface IllegalCharactersErrorHandlingContract {
            default public Stream<Arguments> illegalCharacters() {
                return Stream.of(Arguments.of((Object[])new Object[]{URLEncoder.encode("\"")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("(")}), Arguments.of((Object[])new Object[]{URLEncoder.encode(")")}), Arguments.of((Object[])new Object[]{URLEncoder.encode(",")}), Arguments.of((Object[])new Object[]{URLEncoder.encode(":")}), Arguments.of((Object[])new Object[]{URLEncoder.encode(";")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("<")}), Arguments.of((Object[])new Object[]{URLEncoder.encode(">")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("@")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("[")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("\\")}), Arguments.of((Object[])new Object[]{URLEncoder.encode("]")}), Arguments.of((Object[])new Object[]{"%20"}));
            }

            @ParameterizedTest
            @MethodSource(value={"illegalCharacters"})
            default public void putShouldReturnBadRequestWhenUsernameContainsSpecialCharacter(String illegalCharacter) {
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put("user" + illegalCharacter + "name@" + DOMAIN.name(), new Object[0])).then()).statusCode(400);
            }
        }

        public static interface NormalBehaviourContract {
            @Test
            default public void getDelegatedUsersShouldReturnEmptyByDefault(UsersRepository usersRepository) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                List delegatedUserList = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)delegatedUserList).isEmpty();
            }

            @Test
            default public void getDelegatedUsersShouldReturnAddedUsers(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, BOB)).block();
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, ANDRE)).block();
                List delegatedUserList = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)delegatedUserList).containsOnly((Object[])new String[]{ANDRE.asString(), BOB.asString()});
            }

            @Test
            default public void getDelegatedUsersShouldReturn404NotFoundWhenBaseUserIsNotExisted() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)String.format("User '%s' does not exist", ALICE.asString())), new Object[0]);
            }

            @Test
            default public void addDelegatedUserShouldSucceed(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{BOB});
            }

            @Test
            default public void addDelegatedUserShouldReturn404NotFoundWhenBaseUserIsNotExisted() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)String.format("User '%s' does not exist", ALICE.asString())), new Object[0]);
            }

            @Test
            default public void addDelegatedUserShouldReturnOkWhenDelegatedUserIsNotExisted(UsersRepository usersRepository) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                ((ValidatableResponse)((Response)RestAssured.when().put(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200);
            }

            @Test
            default public void removeDelegatedUserShouldRemoveThatDelegatedUser(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(ANDRE)).thenReturn((Object)true);
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, BOB)).block();
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, ANDRE)).block();
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{ANDRE});
            }

            @Test
            default public void removeDelegatedUserShouldSucceedWhenEmptyAddedUsers(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).isEmpty();
            }

            @Test
            default public void removeDelegatedUserShouldReturn404NotFoundWhenBaseUserIsNotExisted() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)String.format("User '%s' does not exist", ALICE.asString())), new Object[0]);
            }

            @Test
            default public void removeDelegatedUserShouldReturnOkWhenDelegatedUserIsNotExisted(UsersRepository usersRepository) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                ((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200);
            }

            @Test
            default public void removeDelegatedUserShouldBeIdempotent(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, BOB)).block();
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers/%s", ALICE.asString(), BOB.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).isEmpty();
            }

            @Test
            default public void clearAllDelegatedUsersShouldSucceedWhenEmptyAddedUsers(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).isEmpty();
            }

            @Test
            default public void clearAllDelegatedUsersShouldBeIdempotent(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(ANDRE)).thenReturn((Object)true);
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, BOB)).block();
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, ANDRE)).block();
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).isEmpty();
            }

            @Test
            default public void clearAllDelegatedUsersShouldReturn404NotFoundWhenBaseUserIsNotExisted() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.is((Object)String.format("User '%s' does not exist", ALICE.asString())), new Object[0]);
            }

            @Test
            default public void clearAllDelegatedUsersShouldClearAllAddedUsers(UsersRepository usersRepository, DelegationStore delegationStore) throws UsersRepositoryException {
                Mockito.when((Object)usersRepository.contains(ALICE)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(BOB)).thenReturn((Object)true);
                Mockito.when((Object)usersRepository.contains(ANDRE)).thenReturn((Object)true);
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, BOB)).block();
                Mono.from((Publisher)delegationStore.addAuthorizedUser(ALICE, ANDRE)).block();
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(String.format("/%s/authorizedUsers", ALICE.asString()), new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
                Assertions.assertThat((List)((List)Flux.from((Publisher)delegationStore.authorizedUsers(ALICE)).collectList().block())).isEmpty();
            }

            @Test
            default public void getUsersShouldBeEmptyByDefault() {
                List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)users).isEmpty();
            }

            @Test
            default public void putShouldReturnUserErrorWhenNoBody() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0]);
            }

            @Test
            default public void postShouldReturnUserErrorWhenEmptyJsonBody() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0]);
            }

            @Test
            default public void putShouldReturnUserErrorWhenWrongJsonBody() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"bad\":\"any\"}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0]);
            }

            @Test
            default public void putShouldReturnRequireNonNullPassword() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":null}").when().put(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0]);
            }

            @Test
            default public void deleteShouldReturnOk() {
                ((ValidatableResponse)((Response)RestAssured.when().delete(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
            }

            @Test
            default public void deleteShouldReturnBadRequestWhenEmptyUserName() {
                ((ValidatableResponse)((Response)RestAssured.when().delete("/", new Object[0])).then()).statusCode(404);
            }

            @Test
            default public void headShouldReturnBadRequestWhenEmptyUserName() {
                ((ValidatableResponse)((Response)RestAssured.when().head("/", new Object[0])).then()).statusCode(404);
            }

            @Test
            default public void deleteShouldReturnBadRequestWhenUsernameIsTooLong() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(USERNAME_WITH_DOMAIN.asString() + "0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"username length should not be longer than 255 characters"), new Object[0]);
            }

            @Test
            default public void deleteShouldReturnNotFoundWhenUsernameContainsSlash() {
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString() + "/" + USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(404);
            }

            @Test
            default public void putShouldReturnBadRequestWhenEmptyUserName() {
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put("/", new Object[0])).then()).statusCode(404);
            }

            @Test
            default public void putShouldReturnBadRequestWhenUsernameIsTooLong() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString() + "0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.0123456789.", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"username length should not be longer than 255 characters"), new Object[0]);
            }

            @Test
            default public void putShouldReturnNotFoundWhenUsernameContainsSlash() {
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(USERNAME_WITH_DOMAIN.asString() + "/" + USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(404);
            }

            @Test
            default public void deleteShouldRemoveAssociatedUser() {
                RestAssured.with().body("{\"password\":\"password\"}").put(USERNAME_WITH_DOMAIN.asString(), new Object[0]);
                ((ValidatableResponse)((Response)RestAssured.when().delete(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
                List users = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)users).isEmpty();
            }

            @Test
            default public void deleteShouldStillBeValidWithExtraBody() {
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"bad\":\"any\"}").when().delete(USERNAME_WITH_DOMAIN.asString(), new Object[0])).then()).statusCode(204);
            }
        }

        public static interface AllContracts
        extends NormalBehaviourContract,
        MockBehaviorErrorHandlingContract {
        }
    }

    private static class UserRoutesExtension
    implements BeforeEachCallback,
    AfterEachCallback,
    ParameterResolver {
        final MemoryUsersRepository usersRepository;
        final SimpleDomainList domainList;
        final MemoryRecipientRewriteTable recipientRewriteTable;
        final AliasReverseResolver aliasReverseResolver;
        final CanSendFrom canSendFrom;
        final MemoryDelegationStore delegationStore;
        WebAdminServer webAdminServer;

        static UserRoutesExtension withVirtualHosting() throws DomainListException {
            SimpleDomainList domainList = UserRoutesExtension.setupDomainList();
            return new UserRoutesExtension(MemoryUsersRepository.withVirtualHosting((DomainList)domainList), domainList);
        }

        static UserRoutesExtension withoutVirtualHosting() throws DomainListException {
            SimpleDomainList domainList = UserRoutesExtension.setupDomainList();
            return new UserRoutesExtension(MemoryUsersRepository.withoutVirtualHosting((DomainList)domainList), domainList);
        }

        private static SimpleDomainList setupDomainList() throws DomainListException {
            SimpleDomainList domainList = new SimpleDomainList();
            domainList.addDomain(DOMAIN);
            return domainList;
        }

        UserRoutesExtension(MemoryUsersRepository usersRepository, SimpleDomainList domainList) {
            this.usersRepository = (MemoryUsersRepository)Mockito.spy((Object)usersRepository);
            this.domainList = domainList;
            this.recipientRewriteTable = new MemoryRecipientRewriteTable();
            this.recipientRewriteTable.setDomainList((DomainList)domainList);
            this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
            this.aliasReverseResolver = new AliasReverseResolverImpl((RecipientRewriteTable)this.recipientRewriteTable);
            this.canSendFrom = new CanSendFromImpl(this.aliasReverseResolver);
            UserEntityValidator validator = UserEntityValidator.aggregate((UserEntityValidator[])new UserEntityValidator[]{new DefaultUserEntityValidator((UsersRepository)this.usersRepository), new RecipientRewriteTableUserEntityValidator((RecipientRewriteTable)this.recipientRewriteTable)});
            this.usersRepository.setValidator(validator);
            this.recipientRewriteTable.setUsersRepository((UsersRepository)usersRepository);
            this.recipientRewriteTable.setUserEntityValidator(validator);
            this.delegationStore = new MemoryDelegationStore();
        }

        public void beforeEach(ExtensionContext extensionContext) {
            this.webAdminServer = this.startServer((UsersRepository)this.usersRepository);
        }

        public void afterEach(ExtensionContext extensionContext) {
            this.webAdminServer.destroy();
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            Class<Object> parameterType = parameterContext.getParameter().getType();
            return parameterType.isAssignableFrom(UsersRepository.class) || parameterType.isAssignableFrom(RecipientRewriteTable.class) || parameterType.isAssignableFrom(DelegationStore.class);
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            Class<Object> parameterType = parameterContext.getParameter().getType();
            if (parameterType.isAssignableFrom(UsersRepository.class)) {
                return this.usersRepository;
            }
            if (parameterType.isAssignableFrom(RecipientRewriteTable.class)) {
                return this.recipientRewriteTable;
            }
            if (parameterType.isAssignableFrom(DelegationStore.class)) {
                return this.delegationStore;
            }
            throw new RuntimeException("Unknown parameter type: " + String.valueOf(parameterType));
        }

        private WebAdminServer startServer(UsersRepository usersRepository) {
            WebAdminServer server = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new UserRoutes(new UserService(usersRepository), this.canSendFrom, new JsonTransformer(new JsonTransformerModule[0]), (DelegationStore)this.delegationStore)}).start();
            RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)server).setBasePath("/users").setUrlEncodingEnabled(false).build();
            return server;
        }
    }
}

