/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.junit.TemporaryFolderExtension;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.file.SieveFileRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.SieveScriptRoutes;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TemporaryFolderExtension.class})
class SieveScriptRoutesTest {
    private static final DomainList NO_DOMAIN_LIST = null;
    private WebAdminServer webAdminServer;
    private SieveRepository sieveRepository;
    private String sieveContent;

    SieveScriptRoutesTest() {
    }

    @BeforeEach
    void setUp(final TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        FileSystem fileSystem = new FileSystem(){

            public File getBasedir() {
                return temporaryFolder.getTempDir();
            }

            public InputStream getResource(String url) throws IOException {
                return new FileInputStream(this.getFile(url));
            }

            public File getFile(String fileURL) {
                return new File(this.getBasedir(), fileURL.substring("file://".length()));
            }
        };
        this.sieveRepository = new SieveFileRepository(fileSystem);
        MemoryUsersRepository usersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)NO_DOMAIN_LIST);
        usersRepository.addUser(Username.of((String)"userA"), "password");
        URL sieveResource = ClassLoader.getSystemResource("sieve/my_sieve");
        this.sieveContent = IOUtils.toString((URL)sieveResource, (Charset)StandardCharsets.UTF_8);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new SieveScriptRoutes(this.sieveRepository, (UsersRepository)usersRepository)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void defineAddActiveSieveScriptShouldReturnNotFoundWhenUserNotExisted() {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"unknown").pathParam("scriptName", (Object)"scriptA").body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(404);
    }

    @Test
    void defineAddActiveSieveScriptShouldReturnNotFoundWhenScriptNameIsWhiteSpace() {
        String errorBody = "{\"statusCode\": 400, \"type\":\"InvalidArgument\", \"message\":\"Invalid Sieve script name\", \"details\":null}";
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"%20").body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(400)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)body).isEqualTo((Object)errorBody);
    }

    @Test
    void defineAddActiveSieveScriptShouldReturnNotFoundWhenUserNameWhiteSpace() {
        String errorBody = "{\"statusCode\": 400, \"type\":\"InvalidArgument\", \"message\":\"Invalid username\", \"details\":null}";
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"%20").pathParam("scriptName", (Object)"scriptA").body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(400)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)body).isEqualTo((Object)errorBody);
    }

    @Test
    void defineAddActiveSieveScriptShouldReturnBadRequestWhenScriptIsNotSet() {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(400);
    }

    @Test
    void defineAddActiveSieveScriptShouldReturnSucceededWhenScriptIsWhiteSpace() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").body(" ").when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object)this.getScriptContent(this.sieveRepository.getScript(Username.of((String)"userA"), new ScriptName("scriptA")))).isEqualTo((Object)new ScriptContent(" "));
    }

    @Test
    void defineAddActiveSieveScriptAddScriptSucceededOneWhenNotAddActivateParam() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object)this.getScriptContent(this.sieveRepository.getScript(Username.of((String)"userA"), new ScriptName("scriptA")))).isEqualTo((Object)new ScriptContent(this.sieveContent));
    }

    @Test
    void defineAddActiveSieveScriptSetActiveTrueWhenAddActivateParamTrue() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").queryParam("activate", new Object[]{true}).body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object)this.getScriptContent(this.sieveRepository.getActive(Username.of((String)"userA")))).isEqualTo((Object)new ScriptContent(this.sieveContent));
    }

    @Test
    void defineAddActiveSieveScriptGetActiveShouldThrowsExceptionWhenAddActivateParamFalse() {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").queryParam("activate", new Object[]{false}).body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(204);
        Assertions.assertThatThrownBy(() -> this.sieveRepository.getActive(Username.of((String)"userA"))).isInstanceOf(ScriptNotFoundException.class);
    }

    @Test
    void defineAddActiveSieveScriptInvokeShouldReturnBadRequestWhenAddActivateParamWithNotBooleanValue() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("userName", (Object)"userA").pathParam("scriptName", (Object)"scriptA").queryParam("activate", new Object[]{"activate"}).body(this.sieveContent).when().put("sieve/{userName}/scripts/{scriptName}", new Object[0])).then()).statusCode(400)).body("message", Matchers.equalTo((Object)"Invalid activate query parameter"), new Object[0]);
    }

    ScriptContent getScriptContent(InputStream inputStream) throws IOException {
        return new ScriptContent(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
    }
}

