/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.memory.InMemorySieveQuotaRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.SieveQuotaRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SieveQuotaRoutesTest {
    private static final String USER_NAME_A = "userA";
    private static final String PASSWORD_A = "123456";
    private static final Username USERNAME_A = Username.of((String)"userA");
    private static final DomainList NO_DOMAIN_LIST = null;
    private WebAdminServer webAdminServer;
    private SieveQuotaRepository sieveRepository;

    SieveQuotaRoutesTest() {
    }

    @BeforeEach
    void setUp() throws UsersRepositoryException {
        this.sieveRepository = new InMemorySieveQuotaRepository();
        MemoryUsersRepository usersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)NO_DOMAIN_LIST);
        usersRepository.addUser(Username.of((String)USER_NAME_A), PASSWORD_A);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new SieveQuotaRoutes(this.sieveRepository, (UsersRepository)usersRepository, new JsonTransformer(new JsonTransformerModule[0]))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).build();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void getGlobalSieveQuotaShouldReturn204WhenNoQuotaSet() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/sieve/quota/default", new Object[0])).then()).statusCode(204);
    }

    @Test
    void getGlobalSieveQuotaShouldReturnStoredValue() throws Exception {
        QuotaSizeLimit value = QuotaSizeLimit.size((long)1000L);
        this.sieveRepository.setDefaultQuota(value);
        long actual = (Long)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/sieve/quota/default", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().as(Long.class);
        Assertions.assertThat((long)actual).isEqualTo(value.asLong());
    }

    @Test
    void updateGlobalSieveQuotaShouldUpdateStoredValue() throws Exception {
        this.sieveRepository.setDefaultQuota(QuotaSizeLimit.size((long)500L));
        long requiredSize = 1024L;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)requiredSize).put("/sieve/quota/default", new Object[0])).then()).statusCode(204);
        Assertions.assertThat((long)this.sieveRepository.getDefaultQuota().asLong()).isEqualTo(requiredSize);
    }

    @Test
    void updateGlobalSieveQuotaShouldReturn400WhenInvalidNumberFormatInTheBody() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("invalid").put("/sieve/quota/default", new Object[0])).then()).statusCode(400)).body("message", Matchers.is((Object)"unrecognized integer number 'invalid'"), new Object[0]);
    }

    @Test
    void updateGlobalSieveQuotaShouldReturn400WhenInvalidIntegerFormatInTheBody() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("1900.999").put("/sieve/quota/default", new Object[0])).then()).statusCode(400)).body("message", Matchers.is((Object)"unrecognized integer number '1900.999'"), new Object[0]);
    }

    @Test
    void updateGlobalSieveQuotaShouldReturn400WhenRequestedSizeNotPositiveInteger() {
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)-100L).put("/sieve/quota/default", new Object[0])).then()).statusCode(400);
    }

    @Test
    void removeGlobalSieveQuotaShouldReturn204WhenNoQuotaSet() {
        ((ValidatableResponse)((Response)RestAssured.given().delete("/sieve/quota/default", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removeGlobalSieveQuotaShouldRemoveGlobalSieveQuota() throws Exception {
        this.sieveRepository.setDefaultQuota(QuotaSizeLimit.size((long)1024L));
        ((ValidatableResponse)((Response)RestAssured.given().delete("/sieve/quota/default", new Object[0])).then()).statusCode(204);
    }

    @Test
    void getPerUserQuotaShouldReturn204WhenNoQuotaSetForUser() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/sieve/quota/users/userA", new Object[0])).then()).statusCode(204);
    }

    @Test
    void getPerUserSieveQuotaShouldReturnStoredValue() throws Exception {
        QuotaSizeLimit value = QuotaSizeLimit.size((long)1024L);
        this.sieveRepository.setQuota(USERNAME_A, value);
        long actual = (Long)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/sieve/quota/users/userA", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().as(Long.class);
        Assertions.assertThat((long)actual).isEqualTo(value.asLong());
    }

    @Test
    void getPerUserSieveQuotaShouldReturn404WhenUserDoesNotExist() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/sieve/quota/users/not_exist", new Object[0])).then()).statusCode(404);
    }

    @Test
    void updatePerUserSieveQuotaShouldUpdateStoredValue() throws Exception {
        this.sieveRepository.setQuota(USERNAME_A, QuotaSizeLimit.size((long)500L));
        long requiredSize = 1024L;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)requiredSize).put("/sieve/quota/users/userA", new Object[0])).then()).statusCode(204);
        Assertions.assertThat((long)this.sieveRepository.getQuota(USERNAME_A).asLong()).isEqualTo(requiredSize);
    }

    @Test
    void updatePerUserSieveQuotaShouldReturn400WhenInvalidNumberFormatInTheBody() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("invalid").put("/sieve/quota/users/userA", new Object[0])).then()).statusCode(400)).body("message", Matchers.is((Object)"unrecognized integer number 'invalid'"), new Object[0]);
    }

    @Test
    void updatePerUserSieveQuotaShouldReturn400WhenInvalidIntegerFormatInTheBody() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("89884743.9999").put("/sieve/quota/users/" + USERNAME_A.asString(), new Object[0])).then()).statusCode(400)).body("message", Matchers.is((Object)"unrecognized integer number '89884743.9999'"), new Object[0]);
    }

    @Test
    void updatePerUserSieveQuotaShouldReturn400WhenRequestedSizeNotPositiveInteger() {
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)-100L).put("/sieve/quota/users/userA", new Object[0])).then()).statusCode(400);
    }

    @Test
    void updatePerUserSieveQuotaShouldReturn404WhenUserDoesNotExist() {
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)500L).put("/sieve/quota/users/not_exist", new Object[0])).then()).statusCode(404);
    }

    @Test
    void removePerUserSieveQuotaShouldReturn204WhenNoQuotaSetForUser() {
        ((ValidatableResponse)((Response)RestAssured.given().delete("/sieve/quota/users/userA", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removePerUserSieveQuotaShouldRemoveQuotaForUser() throws Exception {
        this.sieveRepository.setQuota(USERNAME_A, QuotaSizeLimit.size((long)1024L));
        ((ValidatableResponse)((Response)RestAssured.given().delete("/sieve/quota/users/userA", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removePerUserSieveQuotaShouldReturn404WhenUserDoesNotExist() {
        ((ValidatableResponse)((Response)RestAssured.given().delete("/sieve/quota/users/not_exist", new Object[0])).then()).statusCode(404);
    }
}

