/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URLEncoder;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.RegexMappingRoutes;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RegexMappingRoutesTest {
    private WebAdminServer webAdminServer;
    private MemoryRecipientRewriteTable memoryRecipientRewriteTable;

    RegexMappingRoutesTest() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        this.memoryRecipientRewriteTable = new MemoryRecipientRewriteTable();
        this.memoryRecipientRewriteTable.setDomainList((DomainList)domainList);
        domainList.addDomain(Domain.of((String)"domain.tld"));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new RegexMappingRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/mappings/regex").setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Test
    void addRegexMappingShouldReturnNoContentWhenSuccess() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("james@domain.tld/targets/bis.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)Username.of((String)"james@domain.tld")))).containsOnly((Object[])new Mapping[]{Mapping.regex((String)"bis.*@apache.org")});
    }

    @Test
    void addRegexMappingShouldAllowUserWithoutDomain() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("jamesdomaintld/targets/bis.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)Username.of((String)"jamesdomaintld")))).containsOnly((Object[])new Mapping[]{Mapping.regex((String)"bis.*@apache.org")});
    }

    @Test
    void addRegexMappingShouldReturnNotFoundWhenSourceIsEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("/targets/bis.*@apache.org", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("type", Is.is((Object)"notFound"), new Object[0])).body("statusCode", Is.is((Object)404), new Object[0])).body("message", Is.is((Object)"POST /mappings/regex/targets/bis.*@apache.org can not be found"), new Object[0]);
    }

    @Test
    void addRegexMappingShouldReturnNotFoundWhenRegexIsEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("james@domain.tld/targets/", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("type", Is.is((Object)"notFound"), new Object[0])).body("statusCode", Is.is((Object)404), new Object[0])).body("message", Is.is((Object)"POST /mappings/regex/james@domain.tld/targets/ can not be found"), new Object[0]);
    }

    @Test
    void addRegexMappingShouldReturnNotFoundWhenSourceAndRegexEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("/targets/", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("type", Is.is((Object)"notFound"), new Object[0])).body("statusCode", Is.is((Object)404), new Object[0])).body("message", Is.is((Object)"POST /mappings/regex/targets/ can not be found"), new Object[0]);
    }

    @Test
    void addRegexMappingShouldReturnBadRequestWhenRegexIsInvalid() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("james@domain.tld/targets/" + URLEncoder.encode("O.*[]"), new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("type", Is.is((Object)"InvalidArgument"), new Object[0])).body("statusCode", Is.is((Object)400), new Object[0])).body("message", Is.is((Object)"Invalid regex: O.*[]"), new Object[0]);
    }

    @Test
    void addRegexMappingShouldReturnNoContentWhenRegexContainsQuestionMark() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("james@domain.tld/targets/" + URLEncoder.encode("^[aei?ou].*james@domain.tld"), new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)Username.of((String)"james@domain.tld")))).containsOnly((Object[])new Mapping[]{Mapping.regex((String)"^[aei?ou].*james@domain.tld")});
    }

    @Test
    void addRegexMappingShouldJustDecodeOneTime() {
        String originalRegex = "^[aei?ou].*james@domain.tld";
        String onceEncodedRegex = URLEncoder.encode(originalRegex);
        String twiceEncodedRegex = URLEncoder.encode(onceEncodedRegex);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().post("james@domain.tld/targets/" + twiceEncodedRegex, new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)Username.of((String)"james@domain.tld")))).containsOnly((Object[])new Mapping[]{Mapping.regex((String)onceEncodedRegex)});
    }

    @Test
    void removeRegexMappingShouldReturnNoContentWhenSuccess() throws Exception {
        MappingSource mappingSource = MappingSource.fromUser((Username)Username.of((String)"abc@domain.tld"));
        this.memoryRecipientRewriteTable.addRegexMapping(mappingSource, "valar.*@apache.org");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(mappingSource)).doesNotContain((Object[])new Mapping[]{Mapping.regex((String)"valar.*@apache.org")});
    }

    @Test
    void removeRegexMappingShouldAllowUserWithoutDomain() throws Exception {
        MappingSource mappingSource = MappingSource.fromUser((Username)Username.of((String)"abcdomaintld"));
        this.memoryRecipientRewriteTable.addRegexMapping(mappingSource, "valar.*@apache.org");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abcdomaintld/targets/valar.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(mappingSource)).doesNotContain((Object[])new Mapping[]{Mapping.regex((String)"valar.*@apache.org")});
    }

    @Test
    void removeRegexMappingShouldReturnNotFoundWhenSourceIsEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("/targets/valar.*@apache.org", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("statusCode", Is.is((Object)404), new Object[0])).body("type", Is.is((Object)"notFound"), new Object[0])).body("message", Is.is((Object)"DELETE /mappings/regex/targets/valar.*@apache.org can not be found"), new Object[0]);
    }

    @Test
    void removeRegexMappingShouldReturnNotFoundWhenRegexIsEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("statusCode", Is.is((Object)404), new Object[0])).body("type", Is.is((Object)"notFound"), new Object[0])).body("message", Is.is((Object)"DELETE /mappings/regex/abc@domain.tld/targets/ can not be found"), new Object[0]);
    }

    @Test
    void removeRegexMappingShouldReturnNotFoundWhenSourceAndRegexEmpty() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("/targets/", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("statusCode", Is.is((Object)404), new Object[0])).body("type", Is.is((Object)"notFound"), new Object[0])).body("message", Is.is((Object)"DELETE /mappings/regex/targets/ can not be found"), new Object[0]);
    }

    @Test
    void removeRegexMappingShouldReturnNoContentWhenTwoSameRequestArrive() throws Exception {
        MappingSource mappingSource = MappingSource.fromUser((Username)Username.of((String)"abc@domain.tld"));
        this.memoryRecipientRewriteTable.addRegexMapping(mappingSource, "valar.*@apache.org");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        Assertions.assertThat((Iterable)this.memoryRecipientRewriteTable.getStoredMappings(mappingSource)).doesNotContain((Object[])new Mapping[]{Mapping.regex((String)"valar.*@apache.org")});
    }

    @Test
    void removeRegexMappingShouldReturnNoContentDespiteTheSourceExistence() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
        MappingSource mappingSource = MappingSource.fromUser((Username)Username.of((String)"abc@domain.tld"));
        this.memoryRecipientRewriteTable.addRegexMapping(mappingSource, "valar.*@apache.org");
    }

    @Test
    void removeRegexMappingShouldReturnNotFoundWhenRegexContainsBackslash() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*/@apache.org", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("message", Is.is((Object)"DELETE /mappings/regex/abc@domain.tld/targets/valar.*/@apache.org can not be found"), new Object[0])).body("statusCode", Is.is((Object)404), new Object[0]);
    }

    @Test
    void removeRegexMappingShouldReturnNoContentWhenRegexContainsValidQuestionMark() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().delete("abc@domain.tld/targets/valar.*%3F@apache.org", new Object[0])).then()).statusCode(204)).contentType(ContentType.JSON);
    }
}

