/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.MappingRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MappingRoutesTest {
    public static final String ALICE_ADDRESS = "alice123@domain.tld";
    public static final String ALICE_USER = "user123@domain.tld";
    public static final String ALICE_ALIAS = "aliasuser123@domain.tld";
    public static final String ALICE_GROUP = "group123@domain.tld";
    public static final String BOB_ADDRESS = "bob456@domain.tld";
    public static final String BOB_USER = "user456@domain.tld";
    public static final String BOB_ALIAS = "aliasuser456@domain.tld";
    public static final String BOB_GROUP = "group456@domain.tld";
    private WebAdminServer webAdminServer;
    private MemoryRecipientRewriteTable recipientRewriteTable;

    MappingRoutesTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.recipientRewriteTable = new MemoryRecipientRewriteTable();
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(Domain.of((String)"domain.tld"));
        domainList.addDomain(Domain.of((String)"aliasdomain.tld"));
        domainList.addDomain(Domain.of((String)"domain.mapping.tld"));
        domainList.addDomain(Domain.of((String)"abc"));
        domainList.addDomain(Domain.of((String)"xyz"));
        this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        this.recipientRewriteTable.setDomainList((DomainList)domainList);
        MemoryUsersRepository usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
        this.recipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
        this.recipientRewriteTable.setUsersRepository((UsersRepository)usersRepository);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new MappingRoutes(jsonTransformer, (RecipientRewriteTable)this.recipientRewriteTable)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/mappings").build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Test
    void getMappingsShouldReturnEmptyWhenNoMappings() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"{}"), new Matcher[0]);
    }

    @Test
    void getMappingsShouldReturnAliasMappings() throws RecipientRewriteTableException {
        Username aliasDomain = Username.of((String)"alias@domain.tld");
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)aliasDomain), "user@domain.tld");
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)aliasDomain), "abc@domain.tld");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"alias@domain.tld\" : [    {      \"type\": \"Alias\",      \"mapping\": \"user@domain.tld\"    },    {      \"type\": \"Alias\",      \"mapping\" : \"abc@domain.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnDomainMappings() throws RecipientRewriteTableException {
        Domain domain = Domain.of((String)"aliasdomain.tld");
        this.recipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)domain), Domain.of((String)"domain1abc.tld"));
        this.recipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)domain), Domain.of((String)"domain2cde.tld"));
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"aliasdomain.tld\" : [    {      \"type\": \"Domain\",      \"mapping\": \"domain1abc.tld\"    },    {      \"type\": \"Domain\",      \"mapping\" : \"domain2cde.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnDomainAliases() throws RecipientRewriteTableException {
        Domain domain = Domain.of((String)"aliasdomain.tld");
        this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)domain), Domain.of((String)"domain1abc.tld"));
        this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)domain), Domain.of((String)"domain2cde.tld"));
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"aliasdomain.tld\" : [    {      \"type\": \"DomainAlias\",      \"mapping\": \"domain1abc.tld\"    },    {      \"type\": \"DomainAlias\",      \"mapping\" : \"domain2cde.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnAddressMappings() throws Exception {
        MailAddress mailAddress = new MailAddress("group@domain.tld");
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromMailAddress((MailAddress)mailAddress), ALICE_USER);
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromMailAddress((MailAddress)mailAddress), "user789@domain.tld");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"group@domain.tld\" : [    {      \"type\": \"Address\",      \"mapping\": \"user123@domain.tld\"    },    {      \"type\": \"Address\",      \"mapping\" : \"user789@domain.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnGroupMappings() throws Exception {
        MailAddress groupAddress = new MailAddress("group@domain.tld");
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromMailAddress((MailAddress)groupAddress), "member1@domain.tld");
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromMailAddress((MailAddress)groupAddress), "member2@domain.tld");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"group@domain.tld\": [    {      \"type\": \"Group\",      \"mapping\": \"member1@domain.tld\"    },    {      \"type\": \"Group\",      \"mapping\": \"member2@domain.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnForwardMappings() throws RecipientRewriteTableException {
        Username forwardUsername = Username.of((String)"forwarduser@domain.tld");
        this.recipientRewriteTable.addForwardMapping(MappingSource.fromUser((Username)forwardUsername), "person1@domain.tld");
        this.recipientRewriteTable.addForwardMapping(MappingSource.fromUser((Username)forwardUsername), "person2@domain.tld");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"forwarduser@domain.tld\": [    {      \"type\": \"Forward\",      \"mapping\": \"person1@domain.tld\"    },    {      \"type\": \"Forward\",      \"mapping\": \"person2@domain.tld\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnRegexMappings() throws RecipientRewriteTableException {
        Username regexUsername = Username.of((String)"regex@domain.tld");
        this.recipientRewriteTable.addRegexMapping(MappingSource.fromUser((Username)regexUsername), "abc");
        this.recipientRewriteTable.addRegexMapping(MappingSource.fromUser((Username)regexUsername), "def");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"regex@domain.tld\": [    {      \"type\": \"Regex\",      \"mapping\": \"abc\"    },    {      \"type\": \"Regex\",      \"mapping\": \"def\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnErrorMappings() throws RecipientRewriteTableException {
        Username errorUsername = Username.of((String)"error@domain.tld");
        this.recipientRewriteTable.addErrorMapping(MappingSource.fromUser((Username)errorUsername), "Error 123");
        this.recipientRewriteTable.addErrorMapping(MappingSource.fromUser((Username)errorUsername), "Error 456");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{  \"error@domain.tld\": [    {      \"type\": \"Error\",      \"mapping\": \"Error 123\"    },    {      \"type\": \"Error\",      \"mapping\": \"Error 456\"    }  ]}");
    }

    @Test
    void getMappingsShouldReturnAllMappings() throws Exception {
        MailAddress mailAddress = new MailAddress("address@domain.tld");
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)"alias@domain.tld")), "user@domain.tld");
        this.recipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)Domain.of((String)"domain.mapping.tld")), Domain.of((String)"realdomain.tld"));
        this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)Domain.of((String)"aliasdomain.tld")), Domain.of((String)"realdomain.tld"));
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromMailAddress((MailAddress)mailAddress), "user@domain.tld");
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)"group@domain.tld")), "member1@domain.tld");
        this.recipientRewriteTable.addForwardMapping(MappingSource.fromUser((Username)Username.of((String)"forward@domain.tld")), "abc@domain.tld");
        this.recipientRewriteTable.addRegexMapping(MappingSource.fromUser((Username)Username.of((String)"regex@domain.tld")), "abc");
        this.recipientRewriteTable.addErrorMapping(MappingSource.fromUser((Username)Username.of((String)"error@domain.tld")), "Error 456");
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).isEqualTo((Object)"{  \"alias@domain.tld\": [    {      \"type\": \"Alias\",      \"mapping\": \"user@domain.tld\"    }  ],  \"domain.mapping.tld\": [    {      \"type\": \"Domain\",      \"mapping\": \"realdomain.tld\"    }  ],  \"aliasdomain.tld\": [    {      \"type\": \"DomainAlias\",      \"mapping\": \"realdomain.tld\"    }  ],  \"address@domain.tld\": [    {      \"type\": \"Address\",      \"mapping\": \"user@domain.tld\"    }  ],  \"group@domain.tld\": [    {      \"type\": \"Group\",      \"mapping\": \"member1@domain.tld\"    }  ],  \"forward@domain.tld\": [    {      \"type\": \"Forward\",      \"mapping\": \"abc@domain.tld\"    }  ],  \"regex@domain.tld\": [    {      \"type\": \"Regex\",      \"mapping\": \"abc\"    }  ],  \"error@domain.tld\": [    {      \"type\": \"Error\",      \"mapping\": \"Error 456\"    }  ]}");
    }

    @Test
    void getUserMappingsShouldReturnNotFoundByDefault() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/", new Object[0])).then()).statusCode(404)).body("statusCode", CoreMatchers.is((Object)404), new Object[0]);
    }

    @Test
    void getUserMappingsShouldBeEmptyWhenUserIsNotFound() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/randomuser@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
    }

    @Test
    void getUserMappingsShouldReturnCorrespondingMappingsFromUsername() throws Exception {
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_USER);
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_ALIAS);
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_GROUP);
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_USER);
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_ALIAS);
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_GROUP);
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/alice123@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"[  {    \"type\": \"Address\",    \"mapping\": \"user123@domain.tld\"  },  {    \"type\": \"Alias\",    \"mapping\": \"aliasuser123@domain.tld\"  },  {    \"type\": \"Group\",    \"mapping\": \"group123@domain.tld\"  }]");
    }

    @Test
    void getUserMappingsShouldReturnSameMappingsWhenParametersInUpperCase() throws RecipientRewriteTableException {
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_USER);
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_ALIAS);
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_GROUP);
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_USER);
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_ALIAS);
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)BOB_ADDRESS)), BOB_GROUP);
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/AliCE123@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"[  {    \"type\": \"Address\",    \"mapping\": \"user123@domain.tld\"  },  {    \"type\": \"Alias\",    \"mapping\": \"aliasuser123@domain.tld\"  },  {    \"type\": \"Group\",    \"mapping\": \"group123@domain.tld\"  }]");
    }

    @Test
    void getUserMappingShouldReturnBadRequestWhenInvalidParameter() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/alice123@domain@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", CoreMatchers.is((Object)"Domain parts ASCII chars must be a-z A-Z 0-9 - or _"), new Object[0]);
    }

    @Test
    void getUserMappingShouldReturnEmptyWhenNoDomainOnUserParameter() throws RecipientRewriteTableException {
        this.recipientRewriteTable.addAddressMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_USER);
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_ALIAS);
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ADDRESS)), ALICE_GROUP);
        String jsonBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/user/alice", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)jsonBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"[]");
    }
}

