/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.dto.MappingSourceModule;
import org.apache.james.webadmin.routes.AddressMappingRoutes;
import org.apache.james.webadmin.routes.GroupsRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class GroupsRoutesTest {
    private static final Domain DOMAIN = Domain.of((String)"b.com");
    private static final Domain DOMAIN_MAPPING = Domain.of((String)"mapping");
    private static final Domain ALIAS_DOMAIN = Domain.of((String)"alias");
    private static final String GROUP1 = "group1@" + DOMAIN.name();
    private static final String GROUP2 = "group2@" + DOMAIN.name();
    private static final String GROUP_WITH_SLASH = "group10/10@" + DOMAIN.name();
    private static final String GROUP_WITH_ENCODED_SLASH = "group10%2F10@" + DOMAIN.name();
    private static final String USER_A = "a@" + DOMAIN.name();
    private static final String USER_B = "b@" + DOMAIN.name();
    private static final String USER_WITH_SLASH = "user/@" + DOMAIN.name();
    private static final String USER_WITH_ENCODED_SLASH = "user%2F@" + DOMAIN.name();
    private WebAdminServer webAdminServer;

    GroupsRoutesTest() {
    }

    private void createServer(GroupsRoutes groupsRoutes, AddressMappingRoutes addressMappingRoutes) {
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{groupsRoutes, addressMappingRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("address/groups").setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Nested
    class ExceptionHandling {
        private MemoryRecipientRewriteTable memoryRecipientRewriteTable;
        private DomainList domainList;

        ExceptionHandling() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = (MemoryRecipientRewriteTable)Mockito.spy((Object)new MemoryRecipientRewriteTable());
            UsersRepository userRepository = (UsersRepository)Mockito.mock(UsersRepository.class);
            this.domainList = (DomainList)Mockito.mock(DomainList.class);
            this.memoryRecipientRewriteTable.setDomainList(this.domainList);
            Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenReturn((Object)true);
            this.memoryRecipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
            this.memoryRecipientRewriteTable.setUsersRepository(userRepository);
            GroupsRoutesTest.this.createServer(new GroupsRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, new JsonTransformer(new JsonTransformerModule[0])), new AddressMappingRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable));
        }

        @Test
        void getMalformedGroupShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putMalformedGroupShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("not-an-address/" + USER_A, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putASourceContainingANotManagedDomainShouldReturnBadRequest() throws Exception {
            ((DomainList)Mockito.doReturn((Object)false).when((Object)this.domainList)).containsDomain((Domain)ArgumentMatchers.any());
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("userA@not-managed-domain.tld/" + USER_A, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Source domain 'not-managed-domain.tld' is not managed by the domainList");
        }

        @Test
        void putUserInGroupWithSlashShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP_WITH_SLASH + "/" + USER_A, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putUserWithSlashInGroupShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + USER_WITH_SLASH, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putMalformedAddressShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group member is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putRequiresTwoPathParams() {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(GROUP1, new Object[0])).then()).statusCode(400)).body(CoreMatchers.is((Object)""), new Matcher[0]);
        }

        @Test
        void deleteMalformedGroupShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("not-an-address/" + USER_A, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteMalformedAddressShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(GROUP1 + "/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group member is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteRequiresTwoPathParams() {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(GROUP1, new Object[0])).then()).statusCode(400)).body(CoreMatchers.is((Object)""), new Matcher[0]);
        }

        @Test
        void putShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).addGroupMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + GROUP2, new Object[0])).then()).statusCode(500);
        }

        @Test
        void putShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).addGroupMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + GROUP2, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).getSourcesForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).getSourcesForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).removeGroupMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(GROUP1 + "/" + GROUP2, new Object[0])).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).removeGroupMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(GROUP1 + "/" + GROUP2, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getShouldReturnErrorWhenRuntimeExceptionIsThrown() {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).getStoredMappings((MappingSource)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).statusCode(500);
        }
    }

    @Nested
    class FilteringOtherRewriteRuleTypes
    extends NormalBehaviour {
        FilteringOtherRewriteRuleTypes(GroupsRoutesTest this$0) {
        }

        @BeforeEach
        void setup() throws Exception {
            super.setUp();
            this.memoryRecipientRewriteTable.addErrorMapping(MappingSource.fromUser((String)"error", (Domain)DOMAIN), "disabled");
            this.memoryRecipientRewriteTable.addRegexMapping(MappingSource.fromUser((String)"regex", (Domain)DOMAIN), ".*@b\\.com");
            this.memoryRecipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)DOMAIN_MAPPING), DOMAIN);
            this.memoryRecipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)ALIAS_DOMAIN), DOMAIN);
        }
    }

    @Nested
    class NormalBehaviour {
        MemoryUsersRepository usersRepository;
        MemoryDomainList domainList;
        MemoryRecipientRewriteTable memoryRecipientRewriteTable;

        NormalBehaviour() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = new MemoryRecipientRewriteTable();
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            this.domainList = new MemoryDomainList(dnsService);
            this.domainList.configure(DomainListConfiguration.DEFAULT);
            this.domainList.addDomain(DOMAIN);
            this.domainList.addDomain(ALIAS_DOMAIN);
            this.domainList.addDomain(DOMAIN_MAPPING);
            this.memoryRecipientRewriteTable.setDomainList((DomainList)this.domainList);
            this.memoryRecipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
            this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.domainList);
            MappingSourceModule mappingSourceModule = new MappingSourceModule();
            UserEntityValidator validator = UserEntityValidator.aggregate((UserEntityValidator[])new UserEntityValidator[]{new DefaultUserEntityValidator((UsersRepository)this.usersRepository), new RecipientRewriteTableUserEntityValidator((RecipientRewriteTable)this.memoryRecipientRewriteTable)});
            this.memoryRecipientRewriteTable.setUserEntityValidator(validator);
            this.memoryRecipientRewriteTable.setUsersRepository((UsersRepository)this.usersRepository);
            GroupsRoutesTest.this.createServer(new GroupsRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, new JsonTransformer(new JsonTransformerModule[]{mappingSourceModule})), new AddressMappingRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable));
        }

        @Test
        void getGroupsShouldBeEmpty() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void getShouldNotResolveRecurseGroups() throws Exception {
            RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0]);
            this.memoryRecipientRewriteTable.addForwardMapping(MappingSource.fromUser((Username)Username.of((String)USER_A)), "b@" + DOMAIN.name());
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A});
        }

        @Test
        void getGroupsShouldListExistingGroupsInAlphabeticOrder() {
            RestAssured.given().put(GROUP2 + "/" + USER_A, new Object[0]);
            RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{GROUP1, GROUP2});
        }

        @Test
        void putShouldBeIdempotent() {
            RestAssured.with().put(GROUP1 + "/" + USER_A, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0])).then()).statusCode(204);
        }

        @Test
        void getNotRegisteredGroupShouldReturnNotFound() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("unknown@domain.travel", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group does not exist");
        }

        @Test
        void getGroupShouldReturnNotFoundWhenNonGroupMappings() {
            this.memoryRecipientRewriteTable.addMapping(MappingSource.fromDomain((Domain)DOMAIN), Mapping.domain((Domain)Domain.of((String)"target.tld")));
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group does not exist");
        }

        @Test
        void getGroupShouldReturnNotFoundWhenNoGroupMappings() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The group does not exist");
        }

        @Test
        void putUserInGroupShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserWithSlashInGroupShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + USER_WITH_ENCODED_SLASH, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserWithSlashInGroupShouldCreateUser() {
            RestAssured.when().put(GROUP1 + "/" + USER_WITH_ENCODED_SLASH, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_WITH_SLASH});
        }

        @Test
        void putUserInGroupShouldCreateGroup() {
            RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A});
        }

        @Test
        void putUserInGroupWithEncodedSlashShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(GROUP_WITH_ENCODED_SLASH + "/" + USER_A, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putShouldDetectLoops() {
            RestAssured.with().basePath("/mappings/address/").post(USER_A + "/targets/" + GROUP1, new Object[0]);
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"Creation of redirection of group1@b.com to group:a@b.com would lead to a loop, operation not performed");
        }

        @Test
        void putShouldNotConflictWithAlias() throws Exception {
            this.memoryRecipientRewriteTable.addAliasMapping(MappingSource.fromUser((Username)Username.of((String)GROUP1)), USER_A);
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"'group1@b.com' already have associated mappings: alias:a@b.com");
        }

        @Test
        void putUserInGroupWithEncodedSlashShouldCreateGroup() {
            RestAssured.when().put(GROUP_WITH_ENCODED_SLASH + "/" + USER_A, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP_WITH_ENCODED_SLASH, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A});
        }

        @Test
        void putSameUserInGroupTwiceShouldBeIdempotent() {
            RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0]);
            RestAssured.when().put(GROUP1 + "/" + USER_A, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A});
        }

        @Test
        void putUserInGroupShouldAllowSeveralUsers() {
            RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0]);
            RestAssured.given().put(GROUP1 + "/" + USER_B, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A, USER_B});
        }

        @Test
        void putUserInGroupShouldNotAllowUserShadowing() throws UsersRepositoryException {
            this.usersRepository.addUser(Username.of((String)USER_A), "whatever");
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(USER_A + "/" + USER_B, new Object[0])).then()).statusCode(409)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"'a@b.com' user already exist");
        }

        @Test
        void getGroupShouldReturnMembersInAlphabeticOrder() {
            RestAssured.given().put(GROUP1 + "/" + USER_B, new Object[0]);
            RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(GROUP1, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{USER_A, USER_B});
        }

        @Test
        void deleteUserNotInGroupShouldReturnOK() {
            ((ValidatableResponse)((Response)RestAssured.when().delete(GROUP1 + "/" + USER_A, new Object[0])).then()).statusCode(204);
        }

        @Test
        void deleteLastUserInGroupShouldDeleteGroup() {
            RestAssured.given().put(GROUP1 + "/" + USER_A, new Object[0]);
            RestAssured.given().delete(GROUP1 + "/" + USER_A, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }
    }
}

