/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.dto.MappingSourceModule;
import org.apache.james.webadmin.routes.ForwardRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ForwardRoutesTest {
    private static final Domain DOMAIN = Domain.of((String)"b.com");
    private static final Domain ALIAS_DOMAIN = Domain.of((String)"alias");
    private static final Domain DOMAIN_MAPPING = Domain.of((String)"mapping");
    public static final String CEDRIC = "cedric@" + DOMAIN.name();
    public static final String ALICE = "alice@" + DOMAIN.name();
    public static final String ALICE_WITH_SLASH = "alice/@" + DOMAIN.name();
    public static final String ALICE_WITH_ENCODED_SLASH = "alice%2F@" + DOMAIN.name();
    public static final String BOB = "bob@" + DOMAIN.name();
    public static final String BOB_PASSWORD = "123456";
    public static final String ALICE_PASSWORD = "789123";
    public static final String ALICE_SLASH_PASSWORD = "abcdef";
    public static final String CEDRIC_PASSWORD = "456789";
    private WebAdminServer webAdminServer;

    ForwardRoutesTest() {
    }

    private void createServer(ForwardRoutes forwardRoutes) {
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{forwardRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("address/forwards").setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Nested
    class ExceptionHandling {
        private MemoryRecipientRewriteTable memoryRecipientRewriteTable;
        private DomainList domainList;

        ExceptionHandling() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = (MemoryRecipientRewriteTable)Mockito.spy((Object)new MemoryRecipientRewriteTable());
            UsersRepository userRepository = (UsersRepository)Mockito.mock(UsersRepository.class);
            ((UsersRepository)Mockito.doReturn((Object)true).when((Object)userRepository)).contains((Username)ArgumentMatchers.any());
            this.domainList = (DomainList)Mockito.mock(DomainList.class);
            this.memoryRecipientRewriteTable.setDomainList(this.domainList);
            Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenReturn((Object)true);
            ForwardRoutesTest.this.createServer(new ForwardRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, userRepository, new JsonTransformer(new JsonTransformerModule[0])));
        }

        @Test
        void getMalformedForwardShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The base forward is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putMalformedForwardShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("not-an-address/targets/" + BOB, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The base forward is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putWithSourceDomainNotInDomainListShouldReturnBadRequest() throws Exception {
            ((DomainList)Mockito.doReturn((Object)false).when((Object)this.domainList)).containsDomain((Domain)ArgumentMatchers.any());
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("bob@not-managed-domain.tld/targets/" + BOB, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Source domain 'not-managed-domain.tld' is not managed by the domainList");
        }

        @Test
        void putUserInForwardWithSlashShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE_WITH_SLASH + "/targets/" + BOB, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putUserWithSlashInForwardShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/" + ALICE_WITH_SLASH, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putMalformedAddressShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The target forward is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putRequiresTwoPathParams() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(ALICE, new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"A destination address needs to be specified in the path"), new Object[0]);
        }

        @Test
        void deleteMalformedForwardShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("not-an-address/targets/" + ALICE, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The base forward is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteMalformedAddressShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(ALICE + "/targets/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The target forward is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteRequiresTwoPathParams() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(ALICE, new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"A destination address needs to be specified in the path"), new Object[0]);
        }

        @Test
        void putShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).addForwardMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(500);
        }

        @Test
        void putShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).addForwardMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).getSourcesForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).getSourcesForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).removeForwardMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).removeForwardMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).getStoredMappings((MappingSource)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).statusCode(500);
        }
    }

    @Nested
    class FilteringOtherRewriteRuleTypes
    extends NormalBehaviour {
        FilteringOtherRewriteRuleTypes(ForwardRoutesTest this$0) {
        }

        @BeforeEach
        void setup() throws Exception {
            super.setUp();
            this.memoryRecipientRewriteTable.addErrorMapping(MappingSource.fromUser((String)"error", (Domain)DOMAIN), "disabled");
            this.memoryRecipientRewriteTable.addRegexMapping(MappingSource.fromUser((String)"regex", (Domain)DOMAIN), ".*@b\\.com");
            this.memoryRecipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)DOMAIN_MAPPING), DOMAIN);
            this.memoryRecipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)ALIAS_DOMAIN), DOMAIN);
        }
    }

    @Nested
    class NormalBehaviour {
        MemoryUsersRepository usersRepository;
        MemoryDomainList domainList;
        MemoryRecipientRewriteTable memoryRecipientRewriteTable;

        NormalBehaviour() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = new MemoryRecipientRewriteTable();
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            this.domainList = new MemoryDomainList(dnsService);
            this.domainList.configure(DomainListConfiguration.DEFAULT);
            this.domainList.addDomain(DOMAIN);
            this.domainList.addDomain(ALIAS_DOMAIN);
            this.domainList.addDomain(DOMAIN_MAPPING);
            this.memoryRecipientRewriteTable.setDomainList((DomainList)this.domainList);
            this.memoryRecipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
            MappingSourceModule mappingSourceModule = new MappingSourceModule();
            this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.domainList);
            this.usersRepository.addUser(Username.of((String)BOB), ForwardRoutesTest.BOB_PASSWORD);
            this.usersRepository.addUser(Username.of((String)ALICE), ForwardRoutesTest.ALICE_PASSWORD);
            this.usersRepository.addUser(Username.of((String)ALICE_WITH_SLASH), ForwardRoutesTest.ALICE_SLASH_PASSWORD);
            this.usersRepository.addUser(Username.of((String)CEDRIC), ForwardRoutesTest.CEDRIC_PASSWORD);
            ForwardRoutesTest.this.createServer(new ForwardRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, (UsersRepository)this.usersRepository, new JsonTransformer(new JsonTransformerModule[]{mappingSourceModule})));
        }

        @Test
        void getForwardShouldBeEmpty() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void getForwardShouldListExistingForwardsInAlphabeticOrder() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().put(CEDRIC + "/targets/" + BOB, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{ALICE, CEDRIC});
        }

        @Test
        void shouldSupportSubAddressing() {
            RestAssured.with().put(ALICE + "/targets/" + URLEncoder.encode("bob+tag@" + DOMAIN.name(), StandardCharsets.UTF_8), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{"bob+tag@" + DOMAIN.name()}), new Object[0]);
        }

        @Test
        void getShouldNotResolveRecurseForwards() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().put(BOB + "/targets/" + CEDRIC, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB}), new Object[0]);
        }

        @Test
        void getNotRegisteredForwardShouldReturnNotFound() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("unknown@domain.travel", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The forward does not exist");
        }

        @Test
        void getForwardShouldReturnNotFoundWhenNonForwardMappings() {
            this.memoryRecipientRewriteTable.addMapping(MappingSource.fromDomain((Domain)DOMAIN), Mapping.domain((Domain)Domain.of((String)"target.tld")));
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The forward does not exist");
        }

        @Test
        void getForwardShouldReturnNotFoundWhenNoForwardMappings() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The forward does not exist");
        }

        @Test
        void putUserInForwardShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putShouldDetectLoops() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/targets/" + ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"Creation of redirection of bob@b.com to forward:alice@b.com would lead to a loop, operation not performed");
        }

        @Test
        void putUserShouldBeIdempotent() {
            RestAssured.given().put(ALICE + "/targets/" + BOB, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserWithSlashInForwardShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/targets/" + ALICE_WITH_ENCODED_SLASH, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserWithSlashInForwardShouldAddItAsADestination() {
            RestAssured.with().put(BOB + "/targets/" + ALICE_WITH_ENCODED_SLASH, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{ALICE_WITH_SLASH}), new Object[0]);
        }

        @Test
        void putUserInForwardShouldCreateForward() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB}), new Object[0]);
        }

        @Test
        void putUserInForwardWithEncodedSlashShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(ALICE_WITH_ENCODED_SLASH + "/targets/" + BOB, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserInForwardWithEncodedSlashShouldCreateForward() {
            RestAssured.with().put(ALICE_WITH_ENCODED_SLASH + "/targets/" + BOB, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE_WITH_ENCODED_SLASH, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB}), new Object[0]);
        }

        @Test
        void putSameUserInForwardTwiceShouldBeIdempotent() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB}), new Object[0]);
        }

        @Test
        void putUserInForwardShouldAllowSeveralDestinations() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().put(ALICE + "/targets/" + CEDRIC, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB, CEDRIC}), new Object[0]);
        }

        @Test
        void forwardShouldAllowIdentity() {
            RestAssured.with().put(ALICE + "/targets/" + ALICE, new Object[0]);
            RestAssured.with().put(ALICE + "/targets/" + CEDRIC, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{ALICE, CEDRIC}), new Object[0]);
        }

        @Test
        void putUserInForwardShouldRequireExistingBaseUser() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("notFound@" + DOMAIN.name() + "/targets/" + BOB, new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)404)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Requested base forward address does not correspond to a user");
        }

        @Test
        void addForwardWithOneTimeUrlEncodedAddressShouldSucceed() {
            RestAssured.with().put(ALICE + "/targets/" + URLEncoder.encode("alice+tag@james.org", StandardCharsets.UTF_8), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{"alice+tag@james.org"}), new Object[0]);
        }

        @Test
        void getForwardShouldReturnMembersInAlphabeticOrder() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().put(ALICE + "/targets/" + CEDRIC, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{BOB, CEDRIC}), new Object[0]);
        }

        @Test
        void forwardShouldAcceptExternalAddresses() {
            String externalAddress = "external@other.com";
            RestAssured.with().put(ALICE + "/targets/" + externalAddress, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("mailAddress", CoreMatchers.hasItems((Object[])new String[]{externalAddress}), new Object[0]);
        }

        @Test
        void deleteUserNotInForwardShouldReturnOK() {
            ((ValidatableResponse)((Response)RestAssured.when().delete(ALICE + "/targets/" + BOB, new Object[0])).then()).statusCode(204);
        }

        @Test
        void deleteLastUserInForwardShouldDeleteForward() {
            RestAssured.with().put(ALICE + "/targets/" + BOB, new Object[0]);
            RestAssured.with().delete(ALICE + "/targets/" + BOB, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }
    }
}

