/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.mail.internet.AddressException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.droplists.memory.MemoryDropList;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.DropListRoutes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

class DropListRoutesTest {
    private static final String DENIED_SENDER = "attacker@evil.com";
    private static final String OWNER_RECIPIENT = "owner@owner.com";
    private WebAdminServer webAdminServer;
    private DropList dropList;

    DropListRoutesTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.dropList = new MemoryDropList();
        DropListRoutes dropListRoutes = new DropListRoutes(this.dropList, new JsonTransformer(new JsonTransformerModule[0]));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{dropListRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        DropListRoutesTest.getDropListTestEntries().forEach(entry -> this.dropList.add(entry).block());
    }

    @AfterEach
    void tearDown() throws AddressException {
        this.webAdminServer.destroy();
        DropListRoutesTest.getDropListTestEntries().forEach(entry -> this.dropList.remove(entry).block());
    }

    @ParameterizedTest(name="{index} Owner: {0}")
    @ValueSource(strings={"global", "domain/owner.com", "user/owner@owner.com"})
    void shouldGetFullDropList(String pathParam) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/droplist/" + pathParam, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.containsInAnyOrder((Object[])new String[]{DENIED_SENDER, "evil.com"}), new Object[0]);
    }

    @ParameterizedTest(name="{index} Owner: {0}")
    @ValueSource(strings={"unknown", "unknown/owner.com", "unknown/owner@owner.com"})
    void shouldHandleWhenGetDropListWithInvalidOwnerScope(String pathParam) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/droplist/" + pathParam, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid OwnerScope"), new Object[0])).body("details", Matchers.is((Object)"OwnerScope 'unknown' is invalid. Supported values are [GLOBAL, DOMAIN, USER]"), new Object[0]);
    }

    @ParameterizedTest(name="{index} Owner: {0}, DeniedEntityType: {1}")
    @CsvSource(value={"global, domain, evil.com", "global, address, attacker@evil.com", "domain/owner.com, domain, evil.com", "domain/owner.com, address, attacker@evil.com", "user/owner@owner.com, domain, evil.com", "user/owner@owner.com, address, attacker@evil.com"})
    void shouldGetDropListWithQueryParams(String pathParam, String queryParam, String expected) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("deniedEntityType", new Object[]{queryParam}).when().get("/droplist/" + pathParam, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.containsInAnyOrder((Object[])new String[]{expected}), new Object[0]);
    }

    @Test
    void shouldHandleInvalidDeniedEntityType() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("deniedEntityType", new Object[]{"unknown"}).when().get("/droplist/global", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid DeniedEntityType"), new Object[0])).body("details", Matchers.is((Object)"DeniedEntityType 'unknown' is invalid. Supported values are [ADDRESS, DOMAIN]"), new Object[0]);
    }

    @ParameterizedTest(name="{index} OwnerScope: {0}, Owner: {1}, DeniedEntity: {2}")
    @CsvSource(value={"global, , devil.com", "global, , bad_guy@crime.com", "domain, owner.com, devil.com", "domain, owner.com, bad_guy@crime.com", "user, owner@owner.com, devil.com", "user, owner@owner.com, bad_guy@crime.com"})
    void shouldAddDropListEntry(String ownerScope, String owner, String newDeniedEntity) {
        ((ValidatableResponse)((Response)RestAssured.when().put("/droplist/" + ownerScope + "/" + owner + "/" + newDeniedEntity, new Object[0])).then()).statusCode(204);
        Assertions.assertThat(this.getResultDropList(ownerScope, owner)).contains((Object[])new String[]{newDeniedEntity});
    }

    @ParameterizedTest(name="{index} OwnerScope: {0}, Owner: {1}, DeniedEntity: {2}")
    @CsvSource(value={"global, , devil..com, Invalid domain devil..com", "global, , bad_guy@@crime.com, Invalid mail address bad_guy@@crime.com", "domain, owner.com, devil..com, Invalid domain devil..com", "domain, owner.com, bad_guy@@crime.com, Invalid mail address bad_guy@@crime.com", "user, owner@owner.com, devil..com, Invalid domain devil..com", "user, owner@owner.com, bad_guy@@crime.com, Invalid mail address bad_guy@@crime.com"})
    void shouldFailWhenAddInvalidDeniedEntity(String ownerScope, String owner, String newDeniedEntity, String message) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("/droplist/" + ownerScope + "/" + owner + "/" + newDeniedEntity, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)message), new Object[0]);
    }

    @ParameterizedTest(name="{index} Path: {0}")
    @CsvSource(value={"/global/evil.com", "/global/attacker@evil.com", "/domain/owner.com/evil.com", "/domain/owner.com/attacker@evil.com", "/user/owner@owner.com/evil.com", "/user/owner@owner.com/attacker@evil.com"})
    void headShouldReturnNoContentWhenDomainDeniedEntityExists(String path) {
        ((ValidatableResponse)((Response)RestAssured.when().head("/droplist" + path, new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest(name="{index} Path: {0}")
    @CsvSource(value={"global/devil.com", "global/bad_guy@crime.com", "/domain/owner.com/devil.com", "/domain/owner.com/bad_guy@crime.com", "/user/owner@owner.com/devil.com", "/user/owner@owner.com/bad_guy@crime.com"})
    void headShouldReturnNotFoundWhenDomainDeniedEntityNotExists(String path) {
        ((ValidatableResponse)((Response)RestAssured.when().head("/droplist" + path, new Object[0])).then()).statusCode(404);
    }

    @ParameterizedTest(name="{index} Path: {3}")
    @CsvSource(value={"global, , evil.com, /global/evil.com", "global, , attacker@evil.com, /global/attacker@evil.com", "domain, owner.com, evil.com, /domain/owner.com/evil.com", "domain, owner.com, attacker@evil.com, /domain/owner.com/attacker@evil.com", "user, owner@owner.com, evil.com, /user/owner@owner.com/evil.com", "user, owner@owner.com, attacker@evil.com, /user/owner@owner.com/attacker@evil.com"})
    void deleteShouldReturnNoContent(String ownerScope, String owner, String deniedEntity, String path) {
        ((ValidatableResponse)((Response)RestAssured.given().delete("/droplist" + path, new Object[0])).then()).statusCode(204);
        Assertions.assertThat(this.getResultDropList(ownerScope, owner)).doesNotContain((Object[])new String[]{deniedEntity});
    }

    @Test
    void deleteShouldReturnNotFoundWhenUsedWithEmptyEntry() {
        ((ValidatableResponse)((Response)RestAssured.given().delete("/", new Object[0])).then()).statusCode(404);
    }

    static Stream<DropListEntry> getDropListTestEntries() throws AddressException {
        return Stream.of(DropListEntry.builder().forAll().denyAddress(new MailAddress(DENIED_SENDER)).build(), DropListEntry.builder().forAll().denyDomain(new MailAddress(DENIED_SENDER).getDomain()).build(), DropListEntry.builder().forAll().denyAddress(new MailAddress(DENIED_SENDER)).build(), DropListEntry.builder().domainOwner(new MailAddress(OWNER_RECIPIENT).getDomain()).denyAddress(new MailAddress(DENIED_SENDER)).build(), DropListEntry.builder().domainOwner(new MailAddress(OWNER_RECIPIENT).getDomain()).denyDomain(new MailAddress(DENIED_SENDER).getDomain()).build(), DropListEntry.builder().userOwner(new MailAddress(OWNER_RECIPIENT)).denyAddress(new MailAddress(DENIED_SENDER)).build(), DropListEntry.builder().userOwner(new MailAddress(OWNER_RECIPIENT)).denyDomain(new MailAddress(DENIED_SENDER).getDomain()).build());
    }

    private List<String> getResultDropList(String ownerScope, String owner) {
        return (List)this.dropList.list(OwnerScope.valueOf((String)ownerScope.toUpperCase()), Optional.ofNullable(owner).orElse("")).map(DropListEntry::getDeniedEntity).collectList().block();
    }
}

