/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.DeleteUserDataRoutesTest;
import org.apache.james.webadmin.routes.DomainsRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.DomainAliasService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DomainsRoutesTest {
    private static final String DOMAIN = "domain";
    private static final String ALIAS_DOMAIN = "alias.domain";
    private static final String ALIAS_DOMAIN_2 = "alias.domain.bis";
    private static final String EXTERNAL_DOMAIN = "external.domain.tld";
    private WebAdminServer webAdminServer;
    private MemoryUsersRepository usersRepository;

    DomainsRoutesTest() {
    }

    private void createServer(DomainList domainList) {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        DomainAliasService domainAliasService = new DomainAliasService((RecipientRewriteTable)new MemoryRecipientRewriteTable(), domainList);
        this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new DomainsRoutes(domainList, domainAliasService, new JsonTransformer(new JsonTransformerModule[0]), new DeleteUserDataService(Set.of()), (UsersRepository)this.usersRepository, (TaskManager)taskManager), new TasksRoutes((TaskManager)taskManager, new JsonTransformer(new JsonTransformerModule[0]), DTOConverter.of((DTOModule[])new DTOModule[]{DeleteUsersDataOfDomainTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/domains").setUrlEncodingEnabled(false).build();
    }

    private void createServer(DomainList domainList, Set<DeleteUserDataTaskStep> steps) {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        DomainAliasService domainAliasService = new DomainAliasService((RecipientRewriteTable)new MemoryRecipientRewriteTable(), domainList);
        DeleteUserDataService deleteUserDataService = new DeleteUserDataService(steps);
        this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new DomainsRoutes(domainList, domainAliasService, new JsonTransformer(new JsonTransformerModule[0]), deleteUserDataService, (UsersRepository)this.usersRepository, (TaskManager)taskManager), new TasksRoutes((TaskManager)taskManager, new JsonTransformer(new JsonTransformerModule[0]), DTOConverter.of((DTOModule[])new DTOModule[]{DeleteUsersDataOfDomainTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/domains").build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Nested
    class DetectedDomainHandling {
        DetectedDomainHandling() {
        }

        @BeforeEach
        void setUp() throws Exception {
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            Mockito.when((Object)dnsService.getAllByName((String)ArgumentMatchers.any())).thenReturn((Object)ImmutableList.of((Object)InetAddress.getByName("172.45.62.13")));
            Mockito.when((Object)dnsService.getHostName((InetAddress)ArgumentMatchers.any())).thenReturn((Object)"james.local");
            MemoryDomainList domainList = new MemoryDomainList(dnsService);
            domainList.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(true).defaultDomain(Domain.of((String)"default.tld")).build());
            DomainsRoutesTest.this.createServer((DomainList)domainList);
        }

        @Test
        void deleteShouldFailWhenAutoDetectedDomain() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("james.local", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Can not remove domain"), new Object[0])).body("details", CoreMatchers.is((Object)"james.local is autodetected and cannot be removed"), new Object[0]);
        }

        @Test
        void deleteShouldFailWhenAutoDetectedIp() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("172.45.62.13", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Can not remove domain"), new Object[0])).body("details", CoreMatchers.is((Object)"172.45.62.13 is autodetected and cannot be removed"), new Object[0]);
        }

        @Test
        void deleteShouldFailWhenDefaultDomain() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("default.tld", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Can not remove domain"), new Object[0])).body("details", CoreMatchers.is((Object)"default.tld is autodetected and cannot be removed"), new Object[0]);
        }
    }

    @Nested
    class ExceptionHandling {
        private DomainList domainList;
        private Domain domain;

        ExceptionHandling() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.domainList = (DomainList)Mockito.mock(DomainList.class);
            DomainsRoutesTest.this.createServer(this.domainList);
            this.domain = Domain.of((String)DomainsRoutesTest.DOMAIN);
        }

        @Test
        void deleteShouldReturnErrorOnUnknownException() throws Exception {
            ((DomainList)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.domainList)).removeDomain(this.domain);
            ((ValidatableResponse)((Response)RestAssured.when().delete(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(500);
        }

        @Test
        void putShouldReturnErrorOnUnknownException() throws Exception {
            ((DomainList)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.domainList)).addDomain(this.domain);
            ((ValidatableResponse)((Response)RestAssured.when().put(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getDomainShouldReturnErrorOnUnknownException() throws Exception {
            Mockito.when((Object)this.domainList.containsDomain(this.domain)).thenThrow(new Throwable[]{new RuntimeException()});
            ((ValidatableResponse)((Response)RestAssured.when().get(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getDomainsShouldReturnErrorOnUnknownException() throws Exception {
            Mockito.when((Object)this.domainList.getDomains()).thenThrow(new Throwable[]{new RuntimeException()});
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnOkWhenDomainListException() throws Exception {
            ((DomainList)Mockito.doThrow((Throwable[])new Throwable[]{new DomainListException("message")}).when((Object)this.domainList)).removeDomain(this.domain);
            ((ValidatableResponse)((Response)RestAssured.when().delete(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putShouldReturnOkWhenDomainListException() throws Exception {
            ((DomainList)Mockito.doThrow((Throwable[])new Throwable[]{new DomainListException("message")}).when((Object)this.domainList)).addDomain(this.domain);
            ((ValidatableResponse)((Response)RestAssured.when().put(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void getDomainShouldReturnErrorOnDomainListException() throws Exception {
            Mockito.when((Object)this.domainList.containsDomain(this.domain)).thenThrow(new Throwable[]{new DomainListException("message")});
            ((ValidatableResponse)((Response)RestAssured.when().get(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getDomainsShouldReturnErrorOnDomainListException() throws Exception {
            Mockito.when((Object)this.domainList.getDomains()).thenThrow(new Throwable[]{new DomainListException("message")});
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }
    }

    @Nested
    class NormalBehaviour {
        NormalBehaviour() {
        }

        @BeforeEach
        void setUp() throws Exception {
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            Mockito.when((Object)dnsService.getHostName((InetAddress)ArgumentMatchers.any())).thenReturn((Object)"localhost");
            Mockito.when((Object)dnsService.getLocalHost()).thenReturn((Object)InetAddress.getByName("localhost"));
            MemoryDomainList domainList = new MemoryDomainList(dnsService);
            domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
            DomainsRoutesTest.this.createServer((DomainList)domainList);
        }

        @Test
        void getDomainsShouldBeEmptyByDefault() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get()).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.contains((Object[])new String[]{"localhost"}), new Object[0]);
        }

        @Test
        void putShouldReturnNotFoundWhenUsedWithEmptyDomain() {
            ((ValidatableResponse)((Response)RestAssured.given().put("/", new Object[0])).then()).statusCode(404);
        }

        @Test
        void deleteShouldReturnNotFoundWhenUsedWithEmptyDomain() {
            ((ValidatableResponse)((Response)RestAssured.given().delete("/", new Object[0])).then()).statusCode(404);
        }

        @Test
        void putShouldBeOk() {
            ((ValidatableResponse)((Response)RestAssured.given().put(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void getDomainsShouldDisplayAddedDomains() {
            RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(".", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.DOMAIN, "localhost"}), new Object[0]);
        }

        @Test
        void putShouldReturnBadRequestWhenDomainNameContainsAT() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("domain@domain", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation domain@domain"), new Object[0]);
        }

        @Test
        void putWithDomainNameContainsSlashEncodedShouldDecodeAndReturnError() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("domain%2Fdomain", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Invalid request for domain creation domain/domain");
        }

        @Test
        void putShouldReturnUserErrorWhenNameContainsUrlSeparator() {
            ((ValidatableResponse)((Response)RestAssured.when().put("domain/domain", new Object[0])).then()).statusCode(404);
        }

        @Test
        void putShouldReturnOkWhenWithA253LongDomainName() {
            ((ValidatableResponse)((Response)RestAssured.when().put(StringUtils.repeat((String)"123456789.", (int)25) + "com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void putShouldReturnBadRequestWhenDomainNameIsTooLong() {
            String longDomainName = StringUtils.repeat((char)'a', (int)256);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(longDomainName, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)("Invalid request for domain creation " + longDomainName)), new Object[0])).body("details", CoreMatchers.is((Object)"Domain name length should not exceed 253 characters"), new Object[0]);
        }

        @Test
        void putShouldWorkOnTheSecondTimeForAGivenValue() {
            RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().put(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void deleteShouldRemoveTheGivenDomain() {
            RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().delete(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(".", Matchers.contains((Object[])new String[]{"localhost"}), new Object[0]);
        }

        @Test
        void deleteShouldBeOkWhenTheDomainIsNotPresent() {
            ((ValidatableResponse)((Response)RestAssured.given().delete(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void getDomainShouldReturnOkWhenTheDomainIsPresent() {
            RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().get(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(204);
        }

        @Test
        void getDomainShouldReturnNotFoundWhenTheDomainIsAbsent() {
            ((ValidatableResponse)((Response)RestAssured.given().get(DomainsRoutesTest.DOMAIN, new Object[0])).then()).statusCode(404);
        }

        @Nested
        class DomainAlias {
            DomainAlias(NormalBehaviour this$1) {
            }

            @Test
            void getAliasesShouldReturnNotFoundWhenDomainDoesNotExist() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(404)).body("statusCode", CoreMatchers.is((Object)404), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"The following domain is not in the domain list and has no registered local aliases: domain"), new Object[0]);
            }

            @Test
            void getAliasesShouldReturnEmptyWhenNone() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(".", Matchers.hasSize((int)0), new Object[0]);
            }

            @Test
            void getAliasesShouldReturnCreatedAliases() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN_2, new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain.bis", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.ALIAS_DOMAIN, DomainsRoutesTest.ALIAS_DOMAIN_2}), new Object[0]);
            }

            @Test
            void putShouldBeIdempotent() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.ALIAS_DOMAIN}), new Object[0]);
            }

            @Test
            void deleteShouldNotFailOnNonExistingEvents() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().delete("domain/aliases/alias.domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
            }

            @Test
            void putShouldLowercaseDomain() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put("domain/aliases/Alias.Domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.ALIAS_DOMAIN}), new Object[0]);
            }

            @Test
            void getAliasesShouldNotReturnDeletedAliases() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                RestAssured.with().delete("domain/aliases/alias.domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(".", Matchers.hasSize((int)0), new Object[0]);
            }

            @Test
            void deleteShouldReturnNotFoundWhenAliasDomainDoesNotExist() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("domain/aliases/alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(404)).body("statusCode", CoreMatchers.is((Object)404), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"The domain list does not contain: alias.domain"), new Object[0]);
            }

            @Test
            void putShouldReturnNotFoundWhenAliasDomainDoesNotExist() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("domain/aliases/alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(404)).body("statusCode", CoreMatchers.is((Object)404), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"The domain list does not contain: alias.domain"), new Object[0]);
            }

            @Test
            void putShouldReturnBadRequestWhenSourceAndDestinationAreTheSame() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("domain/aliases/domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Source domain and destination domain can not have same value(domain)"), new Object[0]);
            }

            @Test
            void putShouldNotFailOnExternalDomainAlias() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("external.domain.tld/aliases/domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(204);
            }

            @Test
            void deleteShouldNotFailOnExternalDomainDestinationForAnAlias() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("external.domain.tld/aliases/domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(204);
            }

            @Test
            void getAliasesShouldListAliasesForExternalDomains() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put("external.domain.tld/aliases/domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("external.domain.tld/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.DOMAIN}), new Object[0]);
            }

            @Test
            void deleteShouldRemoveExternalDomainAlias() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put("external.domain.tld/aliases/domain", new Object[0]);
                RestAssured.with().delete("external.domain.tld/aliases/domain", new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.hasSize((int)0), new Object[0]);
            }

            @Test
            void putShouldReturnBadRequestWhenDestinationDomainIsInvalid() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("invalid@domain/aliases/alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation invalid@domain"), new Object[0]);
            }

            @Test
            void putShouldReturnBadRequestWhenSourceDomainIsInvalid() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("domain/aliases/invalid@alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation invalid@alias.domain"), new Object[0]);
            }

            @Test
            void deleteShouldReturnBadRequestWhenDestinationDomainIsInvalid() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("invalid@domain/aliases/alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation invalid@domain"), new Object[0]);
            }

            @Test
            void deleteShouldReturnBadRequestWhenSourceDomainIsInvalid() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("domain/aliases/invalid@alias.domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation invalid@alias.domain"), new Object[0]);
            }

            @Test
            void getAliasesShouldReturnBadRequestWhenDomainIsInvalid() {
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("invalid@domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid request for domain creation invalid@domain"), new Object[0]);
            }

            @Test
            void deleteShouldReturnBadRequestWhenSourceAndDestinationAreTheSame() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("domain/aliases/domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)"InvalidArgument"), new Object[0])).body("message", CoreMatchers.is((Object)"Source domain and destination domain can not have same value(domain)"), new Object[0]);
            }

            @Test
            void deleteSourceDomainShouldRemoveTheCorrespondingAlias() {
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN_2, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain.bis", new Object[0]);
                RestAssured.with().delete(DomainsRoutesTest.ALIAS_DOMAIN_2, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.ALIAS_DOMAIN}), new Object[0]);
            }

            @Test
            void deleteDestinationDomainShouldHaveNoImpactOnAliasesAliases() {
                RestAssured.with().put(DomainsRoutesTest.DOMAIN, new Object[0]);
                RestAssured.with().put(DomainsRoutesTest.ALIAS_DOMAIN, new Object[0]);
                RestAssured.with().put("domain/aliases/alias.domain", new Object[0]);
                RestAssured.with().delete(DomainsRoutesTest.DOMAIN, new Object[0]);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("domain/aliases", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", Matchers.containsInAnyOrder((Object[])new String[]{DomainsRoutesTest.ALIAS_DOMAIN}), new Object[0]);
            }
        }
    }

    @Nested
    class DeleteAllUsersDataTests {
        private RecordProcessedUsersStep recordProcessedUsersStep;

        DeleteAllUsersDataTests() {
        }

        @BeforeEach
        void setUp() throws Exception {
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            Mockito.when((Object)dnsService.getHostName((InetAddress)ArgumentMatchers.any())).thenReturn((Object)"localhost");
            Mockito.when((Object)dnsService.getLocalHost()).thenReturn((Object)InetAddress.getByName("localhost"));
            MemoryDomainList domainList = new MemoryDomainList(dnsService);
            domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
            domainList.addDomain(Domain.of((String)"domain.tld"));
            this.recordProcessedUsersStep = new RecordProcessedUsersStep();
            ImmutableSet steps = ImmutableSet.of((Object)new DeleteUserDataRoutesTest.StepImpl(new DeleteUserDataTaskStep.StepName("A"), 35, (Mono<Void>)Mono.empty()), (Object)this.recordProcessedUsersStep);
            DomainsRoutesTest.this.createServer((DomainList)domainList, (Set<DeleteUserDataTaskStep>)steps);
        }

        @Test
        void shouldDeleteAllUsersDataOfTheDomain() throws UsersRepositoryException {
            DomainsRoutesTest.this.usersRepository.addUser(Username.of((String)"user1@localhost"), "secret");
            DomainsRoutesTest.this.usersRepository.addUser(Username.of((String)"user2@localhost"), "secret");
            String taskId = (String)((Response)RestAssured.with().basePath("/domains").queryParam("action", new Object[]{"deleteData"}).post("/localhost", new Object[0])).jsonPath().get("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", CoreMatchers.is((Object)"DeleteUsersDataOfDomainTask"), new Object[0])).body("status", CoreMatchers.is((Object)"completed"), new Object[0])).body("additionalInformation.type", CoreMatchers.is((Object)"DeleteUsersDataOfDomainTask"), new Object[0])).body("additionalInformation.domain", CoreMatchers.is((Object)"localhost"), new Object[0])).body("additionalInformation.successfulUsersCount", CoreMatchers.is((Object)2), new Object[0])).body("additionalInformation.failedUsersCount", CoreMatchers.is((Object)0), new Object[0])).body("additionalInformation.failedUsers", Matchers.empty(), new Object[0]);
            Assertions.assertThat(this.recordProcessedUsersStep.processedUsers).containsExactlyInAnyOrder((Object[])new Username[]{Username.of((String)"user1@localhost"), Username.of((String)"user2@localhost")});
        }

        @Test
        void shouldFailWhenInvalidAction() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/domains").queryParam("action", new Object[]{"invalid"}).post("/localhost", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", CoreMatchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [deleteData]"), new Object[0]);
        }

        @Test
        void shouldFailWhenNonExistingDomain() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/domains").queryParam("action", new Object[]{"deleteData"}).post("/nonExistingDomain", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", CoreMatchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", CoreMatchers.is((Object)"'domainName' parameter should be an existing domain"), new Object[0]);
        }

        @Test
        void shouldNotDeleteUsersDataOfOtherDomains() throws UsersRepositoryException {
            DomainsRoutesTest.this.usersRepository.addUser(Username.of((String)"user1@localhost"), "secret");
            DomainsRoutesTest.this.usersRepository.addUser(Username.of((String)"user2@localhost"), "secret");
            DomainsRoutesTest.this.usersRepository.addUser(Username.of((String)"user3@domain.tld"), "secret");
            String taskId = (String)((Response)RestAssured.with().basePath("/domains").queryParam("action", new Object[]{"deleteData"}).post("/localhost", new Object[0])).jsonPath().get("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", CoreMatchers.is((Object)"DeleteUsersDataOfDomainTask"), new Object[0])).body("status", CoreMatchers.is((Object)"completed"), new Object[0])).body("additionalInformation.type", CoreMatchers.is((Object)"DeleteUsersDataOfDomainTask"), new Object[0])).body("additionalInformation.domain", CoreMatchers.is((Object)"localhost"), new Object[0])).body("additionalInformation.successfulUsersCount", CoreMatchers.is((Object)2), new Object[0])).body("additionalInformation.failedUsersCount", CoreMatchers.is((Object)0), new Object[0])).body("additionalInformation.failedUsers", Matchers.empty(), new Object[0]);
            Assertions.assertThat(this.recordProcessedUsersStep.processedUsers).doesNotContain((Object[])new Username[]{Username.of((String)"user3@domain.tld")});
        }
    }

    private static class RecordProcessedUsersStep
    implements DeleteUserDataTaskStep {
        private final Set<Username> processedUsers = ConcurrentHashMap.newKeySet();

        public DeleteUserDataTaskStep.StepName name() {
            return new DeleteUserDataTaskStep.StepName("RecordProcessedUsersStep");
        }

        public int priority() {
            return 0;
        }

        public Publisher<Void> deleteUserData(Username username) {
            this.processedUsers.add(username);
            return Mono.empty();
        }
    }
}

