/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.DomainMappingsRoutes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DomainMappingsRoutesTest {
    private MemoryRecipientRewriteTable recipientRewriteTable;
    private WebAdminServer webAdminServer;
    private DomainList domainList;

    DomainMappingsRoutesTest() {
    }

    private void createServer(DomainMappingsRoutes domainMappingsRoutes) {
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{domainMappingsRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/domainMappings").build();
    }

    @BeforeEach
    void setUp() throws Exception {
        this.recipientRewriteTable = (MemoryRecipientRewriteTable)Mockito.spy((Object)new MemoryRecipientRewriteTable());
        this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        this.domainList = (DomainList)Mockito.mock(DomainList.class);
        this.recipientRewriteTable.setDomainList(this.domainList);
        Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenReturn((Object)true);
        this.createServer(new DomainMappingsRoutes((RecipientRewriteTable)this.recipientRewriteTable, new JsonTransformer(new JsonTransformerModule[0])));
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Nested
    class IllegalInputs {
        IllegalInputs() {
        }

        @Test
        void addMappingContainingSourceDomainNotInDomainListShouldReturnBadRequest() throws Exception {
            ((DomainList)Mockito.doReturn((Object)false).when((Object)DomainMappingsRoutesTest.this.domainList)).containsDomain((Domain)ArgumentMatchers.any());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("destination.tld").when().put("not-managed-domain.tld", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", CoreMatchers.is((Object)"Source domain 'not-managed-domain.tld' is not managed by the domainList"), new Object[0]);
        }

        @Test
        void addDomainMappingShouldRespondWithNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put("", new Object[0])).then()).statusCode(404);
        }

        @Test
        void deleteDomainMappingShouldRespondWithNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().delete("", new Object[0])).then()).statusCode(404);
        }

        @Test
        void addDomainMappingWithInvalidDomainInBody() {
            this.assertBadRequest("abc@domain.com", spec -> RestAssured.put((String)"domain.com", (Object[])new Object[0]));
        }

        @Test
        void deleteDomainMappingWithInvalidDomainInBody() {
            this.assertBadRequest("abc@domain.com", spec -> RestAssured.put((String)"domain.com", (Object[])new Object[0]));
        }

        @Test
        void addDomainMappingWithInvalidDomainInPath() {
            this.assertBadRequest("domain.com", spec -> RestAssured.put((String)"abc@domain.com", (Object[])new Object[0]));
        }

        @Test
        void deleteDomainMappingWithInvalidDomainInPath() {
            this.assertBadRequest("domain.com", spec -> RestAssured.put((String)"abc@domain.com", (Object[])new Object[0]));
        }

        @Test
        void addDomainMappingWithEmptyAliasDomain() {
            this.assertBadRequest("", spec -> RestAssured.put((String)"domain.com", (Object[])new Object[0]));
        }

        @Test
        void deleteDomainMappingWithEmptyAliasDomain() {
            this.assertBadRequest("", spec -> RestAssured.delete((String)"domain.com", (Object[])new Object[0]));
        }

        @Test
        void addSpecificDomainMappingWithInvalidDomainInPath() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("abc@domain.com", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).hasEntrySatisfying((Object)"message", o -> Assertions.assertThat((String)((String)o)).matches((CharSequence)"^The domain .* is invalid\\.$"));
        }

        @Test
        void addDomainMappingShouldReturnBadRequestWhenDomainSourceTooLong() {
            String longDomainName = StringUtils.repeat((char)'a', (int)256);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("destination.tld").when().put(longDomainName, new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", CoreMatchers.is((Object)("The domain " + longDomainName + " is invalid.")), new Object[0])).body("details", CoreMatchers.is((Object)"Domain name length should not exceed 253 characters"), new Object[0]);
        }

        @Test
        void addDomainMappingShouldReturnBadRequestWhenDomainDestinationTooLong() {
            String longDomainName = StringUtils.repeat((char)'a', (int)256);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(longDomainName).when().put("source.tld", new Object[0])).then()).statusCode(400)).body("statusCode", CoreMatchers.is((Object)400), new Object[0])).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", CoreMatchers.is((Object)("The domain " + longDomainName + " is invalid.")), new Object[0])).body("details", CoreMatchers.is((Object)"Domain name length should not exceed 253 characters"), new Object[0]);
        }

        private void assertBadRequest(String toDomain, Function<RequestSpecification, Response> requestingFunction) {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)requestingFunction.apply(RestAssured.given().body(toDomain).when()).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).hasEntrySatisfying((Object)"message", o -> Assertions.assertThat((String)((String)o)).matches((CharSequence)"^The domain .* is invalid\\.$"));
        }
    }

    @Nested
    class NormalBehaviour {
        NormalBehaviour() {
        }

        @Test
        void addDomainMappingShouldRespondWithNoContent() {
            ((ValidatableResponse)((Response)RestAssured.given().body("to.com").when().put("from.com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void addDomainMappingShouldBeIdempotent() {
            RestAssured.with().body("to.com").put("from.com", new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().body("to.com").when().put("from.com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void addDomainMappingsShouldReturnOkWhenWithA253LongDomainSource() {
            ((ValidatableResponse)((Response)RestAssured.given().body("to.com").when().put(StringUtils.repeat((String)"123456789.", (int)25) + "com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void addDomainMappingsShouldReturnOkWhenWithA253LongDomainDestination() {
            ((ValidatableResponse)((Response)RestAssured.given().body(StringUtils.repeat((String)"123456789.", (int)25) + "com").when().put("from.com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void getDomainMappingsShouldReturnAllDomainMappings() throws RecipientRewriteTableException {
            String alias1 = "to_1.com";
            String alias2 = "to_2.com";
            String alias3 = "to_3.com";
            Domain expectedDomain = Domain.of((String)"abc.com");
            MappingSource mappingSource = MappingSource.fromDomain((Domain)expectedDomain);
            DomainMappingsRoutesTest.this.recipientRewriteTable.addDomainMapping(mappingSource, Domain.of((String)alias1));
            DomainMappingsRoutesTest.this.recipientRewriteTable.addDomainMapping(mappingSource, Domain.of((String)alias2));
            DomainMappingsRoutesTest.this.recipientRewriteTable.addDomainMapping(mappingSource, Domain.of((String)alias3));
            Map map = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getMap(".");
            Assertions.assertThat((Map)map).containsOnly(new Map.Entry[]{Assertions.entry((Object)expectedDomain.name(), (Object)ImmutableList.of((Object)alias1, (Object)alias2, (Object)alias3))});
        }

        @Test
        void getDomainMappingsEmptyMappingsAreFilteredOut() throws RecipientRewriteTableException {
            MappingSource nonEmptyMapping = MappingSource.fromDomain((Domain)Domain.of((String)"abc.com"));
            MappingSource emptyMapping = MappingSource.fromDomain((Domain)Domain.of((String)"def.com"));
            ImmutableMap mappings = ImmutableMap.of((Object)nonEmptyMapping, (Object)MappingsImpl.fromRawString((String)"domain:a.com"), (Object)emptyMapping, (Object)MappingsImpl.empty());
            Mockito.when((Object)DomainMappingsRoutesTest.this.recipientRewriteTable.getAllMappings()).thenReturn((Object)mappings);
            Map map = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getMap(".");
            ((MapAssert)Assertions.assertThat((Map)map).containsKey((Object)nonEmptyMapping.asString())).doesNotContainKey((Object)emptyMapping.asString());
        }

        @Test
        void getDomainMappingsShouldFilterNonDomainMappings() throws RecipientRewriteTableException {
            MappingSource mappingSource = MappingSource.fromDomain((Domain)Domain.of((String)"abc.com"));
            String address = "addr@domain.com";
            DomainMappingsRoutesTest.this.recipientRewriteTable.addAddressMapping(mappingSource, address);
            DomainMappingsRoutesTest.this.recipientRewriteTable.addForwardMapping(mappingSource, address);
            DomainMappingsRoutesTest.this.recipientRewriteTable.addErrorMapping(mappingSource, address);
            DomainMappingsRoutesTest.this.recipientRewriteTable.addGroupMapping(mappingSource, address);
            DomainMappingsRoutesTest.this.recipientRewriteTable.addRegexMapping(mappingSource, address);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"{}"), new Matcher[0]);
        }

        @Test
        void getDomainMappingsShouldBeEmptyByDefault() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"{}"), new Matcher[0]);
        }

        @Test
        void deleteDomainMappingShouldRespondWithNoContent() {
            ((ValidatableResponse)((Response)RestAssured.given().body("to.com").when().delete("from.com", new Object[0])).then()).statusCode(204);
        }

        @Test
        void deleteDomainMappingShouldRemoveMapping() throws RecipientRewriteTableException {
            MappingSource mappingSource = MappingSource.fromDomain((Domain)Domain.of((String)"from.com"));
            String alias = "to.com";
            DomainMappingsRoutesTest.this.recipientRewriteTable.addDomainMapping(mappingSource, Domain.of((String)alias));
            Assumptions.assumeTrue((DomainMappingsRoutesTest.this.recipientRewriteTable.getStoredMappings(mappingSource) != null ? 1 : 0) != 0);
            ((ValidatableResponse)((Response)RestAssured.given().body("to.com").when().delete("from.com", new Object[0])).then()).statusCode(204);
            Assertions.assertThat((Map)DomainMappingsRoutesTest.this.recipientRewriteTable.getAllMappings()).isEmpty();
        }

        @Test
        void getSpecificDomainMappingShouldRespondWithNotFoundWhenHasNoAliases() throws RecipientRewriteTableException {
            String domain = "from.com";
            Mockito.when((Object)DomainMappingsRoutesTest.this.recipientRewriteTable.getStoredMappings((MappingSource)ArgumentMatchers.any())).thenReturn((Object)MappingsImpl.empty());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(domain, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(404)).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("statusCode", CoreMatchers.is((Object)404), new Object[0])).body("message", CoreMatchers.is((Object)("Cannot find mappings for " + domain)), new Object[0]);
        }

        @Test
        void getSpecificDomainMappingShouldRespondWithNotFoundWhenHasEmptyAliases() throws RecipientRewriteTableException {
            String domain = "from.com";
            Mockito.when((Object)DomainMappingsRoutesTest.this.recipientRewriteTable.getStoredMappings((MappingSource)ArgumentMatchers.any())).thenReturn((Object)MappingsImpl.empty());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(domain, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(404)).body("type", CoreMatchers.is((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("statusCode", CoreMatchers.is((Object)404), new Object[0])).body("message", CoreMatchers.is((Object)("Cannot find mappings for " + domain)), new Object[0]);
        }

        @Test
        void getSpecificDomainMappingShouldFilterOutNonDomainMappings() throws RecipientRewriteTableException {
            String domain = "from.com";
            String aliasDomain = "to.com";
            MappingSource mappingSource = MappingSource.fromDomain((Domain)Domain.of((String)domain));
            DomainMappingsRoutesTest.this.recipientRewriteTable.addRegexMapping(mappingSource, "(.*)@localhost");
            DomainMappingsRoutesTest.this.recipientRewriteTable.addGroupMapping(mappingSource, "user@domain.com");
            DomainMappingsRoutesTest.this.recipientRewriteTable.addForwardMapping(mappingSource, "user@domain.com");
            DomainMappingsRoutesTest.this.recipientRewriteTable.addErrorMapping(mappingSource, "disabled");
            DomainMappingsRoutesTest.this.recipientRewriteTable.addDomainMapping(mappingSource, Domain.of((String)aliasDomain));
            List body = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(domain, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().jsonPath().getList(".");
            Assertions.assertThat((List)body).containsOnly((Object[])new String[]{aliasDomain});
        }

        @Test
        void getSpecificDomainMappingShouldReturnDomainMappings() throws RecipientRewriteTableException {
            String domain = "abc.com";
            String aliasDomain = "a.com";
            MappingsImpl mappings = MappingsImpl.fromMappings((Mapping[])new Mapping[]{Mapping.domain((Domain)Domain.of((String)aliasDomain))});
            Mockito.when((Object)DomainMappingsRoutesTest.this.recipientRewriteTable.getStoredMappings((MappingSource)ArgumentMatchers.any())).thenReturn((Object)mappings);
            List body = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(domain, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().jsonPath().getList(".");
            Assertions.assertThat((List)body).contains((Object[])new String[]{aliasDomain});
        }
    }
}

