/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.DeleteUserDataRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUserDataTaskAdditionalInformationDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DeleteUserDataRoutesTest {
    private static final Username USER = Username.of((String)"jessy.jones@domain.tld");
    private MemoryUsersRepository usersRepository;

    DeleteUserDataRoutesTest() {
    }

    WebAdminServer setUp(ImmutableSet<DeleteUserDataTaskStep> steps) {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        DeleteUserDataService service = new DeleteUserDataService(steps);
        WebAdminServer webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new DeleteUserDataRoutes((UsersRepository)this.usersRepository, service, (TaskManager)taskManager, new JsonTransformer(new JsonTransformerModule[0])), new TasksRoutes((TaskManager)taskManager, new JsonTransformer(new JsonTransformerModule[0]), DTOConverter.of((DTOModule[])new DTOModule[]{DeleteUserDataTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)webAdminServer).build();
        return webAdminServer;
    }

    @BeforeEach
    void setUpUsersRepo() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(Domain.of((String)"domain.tld"));
        this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
    }

    @Nested
    class ResumeFailureTests {
        private WebAdminServer webAdminServer;
        private AtomicBoolean behaviour1;
        private AtomicBoolean behaviour2;

        ResumeFailureTests() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.behaviour1 = new AtomicBoolean(false);
            this.behaviour2 = new AtomicBoolean(false);
            this.webAdminServer = DeleteUserDataRoutesTest.this.setUp((ImmutableSet<DeleteUserDataTaskStep>)ImmutableSet.of((Object)new StepImpl(new DeleteUserDataTaskStep.StepName("A"), 1, (Mono<Void>)Mono.fromRunnable(() -> this.behaviour1.set(true))), (Object)new StepImpl(new DeleteUserDataTaskStep.StepName("B"), 2, (Mono<Void>)Mono.error(RuntimeException::new)), (Object)new StepImpl(new DeleteUserDataTaskStep.StepName("C"), 3, (Mono<Void>)Mono.fromRunnable(() -> this.behaviour2.set(true)))));
            DeleteUserDataRoutesTest.this.usersRepository.addUser(USER, "pass");
        }

        @AfterEach
        void stop() {
            this.webAdminServer.destroy();
        }

        @Test
        void shouldReportFailures() {
            String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"deleteData"}).post("/users/" + USER.asString(), new Object[0])).jsonPath().get("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("status", Matchers.is((Object)"failed"), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)"jessy.jones@domain.tld"), new Object[0])).body("additionalInformation.status.A", Matchers.is((Object)"DONE"), new Object[0])).body("additionalInformation.status.B", Matchers.is((Object)"FAILED"), new Object[0])).body("additionalInformation.status.C", Matchers.is((Object)"ABORTED"), new Object[0]);
            Assertions.assertThat((boolean)this.behaviour1.get()).isTrue();
            Assertions.assertThat((boolean)this.behaviour2.get()).isFalse();
        }

        @Test
        void shouldSupportResumeWhenFailure() {
            String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"deleteData"}).queryParam("fromStep", new Object[]{"B"}).post("/users/" + USER.asString(), new Object[0])).jsonPath().get("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("status", Matchers.is((Object)"failed"), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)"jessy.jones@domain.tld"), new Object[0])).body("additionalInformation.status.A", Matchers.is((Object)"SKIPPED"), new Object[0])).body("additionalInformation.status.B", Matchers.is((Object)"FAILED"), new Object[0])).body("additionalInformation.status.C", Matchers.is((Object)"ABORTED"), new Object[0]);
            Assertions.assertThat((boolean)this.behaviour1.get()).isFalse();
            Assertions.assertThat((boolean)this.behaviour2.get()).isFalse();
        }

        @Test
        void shouldRejectInvalidFromStep() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"deleteData"}).queryParam("fromStep", new Object[]{"invalid"}).when().post("/users/" + USER.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Starting step not found: invalid"), new Object[0]);
        }
    }

    @Nested
    class BasicTests {
        private WebAdminServer webAdminServer;
        private AtomicBoolean behaviour1;
        private AtomicBoolean behaviour2;

        BasicTests() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.behaviour1 = new AtomicBoolean(false);
            this.behaviour2 = new AtomicBoolean(false);
            this.webAdminServer = DeleteUserDataRoutesTest.this.setUp((ImmutableSet<DeleteUserDataTaskStep>)ImmutableSet.of((Object)new StepImpl(new DeleteUserDataTaskStep.StepName("A"), 35, (Mono<Void>)Mono.fromRunnable(() -> this.behaviour1.set(true))), (Object)new StepImpl(new DeleteUserDataTaskStep.StepName("B"), 3, (Mono<Void>)Mono.fromRunnable(() -> this.behaviour2.set(true)))));
            DeleteUserDataRoutesTest.this.usersRepository.addUser(USER, "pass");
        }

        @AfterEach
        void stop() {
            this.webAdminServer.destroy();
        }

        @Test
        void shouldPerformDataDeletion() {
            String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"deleteData"}).post("/users/" + USER.asString(), new Object[0])).jsonPath().get("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"DeleteUserDataTask"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)"jessy.jones@domain.tld"), new Object[0])).body("additionalInformation.status.A", Matchers.is((Object)"DONE"), new Object[0])).body("additionalInformation.status.B", Matchers.is((Object)"DONE"), new Object[0]);
            Assertions.assertThat((boolean)this.behaviour1.get()).isTrue();
            Assertions.assertThat((boolean)this.behaviour2.get()).isTrue();
        }

        @Test
        void shouldFailWhenInvalidAction() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"invalid"}).post("/users/" + USER.asString(), new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Invalid value supplied for query parameter 'action': invalid. Supported values are [deleteData]"), new Object[0]);
        }

        @Test
        void shouldRejectUnknownUser() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"deleteData"}).when().post("/users/unknown@domain.tld", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'username' parameter should be an existing user"), new Object[0]);
        }

        @Test
        void shouldAcceptUnknownUserWhenForce() {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"deleteData"}).queryParam("force", new Object[0]).when().post("/users/unknown@domain.tld", new Object[0])).then()).statusCode(201);
        }
    }

    public static class StepImpl
    implements DeleteUserDataTaskStep {
        private final DeleteUserDataTaskStep.StepName name;
        private final int priority;
        private final Mono<Void> behaviour;

        public StepImpl(DeleteUserDataTaskStep.StepName name, int priority, Mono<Void> behaviour) {
            this.name = name;
            this.priority = priority;
            this.behaviour = behaviour;
        }

        public DeleteUserDataTaskStep.StepName name() {
            return this.name;
        }

        public int priority() {
            return this.priority;
        }

        public Publisher<Void> deleteUserData(Username username) {
            return this.behaviour;
        }
    }
}

