/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.net.InetAddress;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.eventsourcing.EventSourcingDLPConfigurationStore;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.memory.InMemoryEventStore;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.DLPConfigurationRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DLPConfigurationRoutesTest {
    private static final String DEFAULT_DOMAIN = "james.org";
    private static final Domain SENDER_DOMAIN = Domain.of((String)"james.org");
    private static final String DOMAIN_2 = "apache.org";
    private static final Domain SENDER_DOMAIN_2 = Domain.of((String)"apache.org");
    private WebAdminServer webAdminServer;
    private EventSourcingDLPConfigurationStore dlpStore;

    DLPConfigurationRoutesTest() {
    }

    private void createServer(DLPConfigurationStore dlpConfigurationStore, DomainList domainList) {
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new DLPConfigurationRoutes(dlpConfigurationStore, domainList, new JsonTransformer(new JsonTransformerModule[0]))}).start();
        RestAssured.requestSpecification = this.buildRequestSpecification(this.webAdminServer);
    }

    RequestSpecification buildRequestSpecification(WebAdminServer server) {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        return WebAdminUtils.buildRequestSpecification((WebAdminServer)server).setBasePath("/dlp/rules").build();
    }

    @BeforeEach
    void setup() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        Mockito.when((Object)dnsService.getHostName((InetAddress)ArgumentMatchers.any())).thenReturn((Object)"localhost");
        Mockito.when((Object)dnsService.getLocalHost()).thenReturn((Object)InetAddress.getByName("localhost"));
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
        domainList.addDomain(SENDER_DOMAIN);
        domainList.addDomain(SENDER_DOMAIN_2);
        this.dlpStore = new EventSourcingDLPConfigurationStore((EventStore)new InMemoryEventStore());
        this.createServer((DLPConfigurationStore)this.dlpStore, (DomainList)domainList);
    }

    @Nested
    class DefineFetch {
        DefineFetch(DLPConfigurationRoutesTest this$0) {
        }

        @Test
        void fetchShouldBeOK() {
            this.storeRules();
            String jsonAsString = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("james.org/rules/1", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)jsonAsString).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_FIELDS, new Option[0]).isEqualTo((Object)"{    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true}");
        }

        @Test
        void fetchOnUnknownDomainShouldBe404() {
            this.storeRules();
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("strange.com/rules/1", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'strange.com' is not managed by this James server"), new Object[0]);
        }

        @Test
        void fetchOnUnknownDomainAndRuleShouldBe404() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("strange.com/rules/666", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'strange.com' is not managed by this James server"), new Object[0]);
        }

        @Test
        void fetchOnUnknownRuleIdShouldBe404() {
            this.storeRules();
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("james.org/rules/666", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"There is no rule '666' for 'james.org' managed by this James server"), new Object[0]);
        }

        private void storeRules() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": true,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
        }
    }

    @Nested
    class DefineList {
        DefineList(DLPConfigurationRoutesTest this$0) {
        }

        @Test
        void getShouldReturnOK() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
        }

        @Test
        void getShouldReturnABody() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 2\",    \"targetsSender\": true,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String body = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)body).isEqualTo((Object)"{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 2\",    \"targetsSender\": true,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}");
        }

        @Test
        void getShouldReturnAnEmptyBodyWhenDLPStoreIsEmpty() {
            String storeBody = "{\"rules\": []}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String body = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)body).isEqualTo((Object)"{\"rules\":[]}");
        }

        @Test
        void getShouldReturnOnlyConfigurationsFromCorrespondingDomain() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String storeDomain2Body = "{\"rules\": [  {    \"id\": \"3\",    \"expression\": \"apache.org\",    \"targetsSender\": true  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeDomain2Body).when().put(DLPConfigurationRoutesTest.DOMAIN_2, new Object[0])).then()).statusCode(204);
            String body = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)body).isEqualTo((Object)"{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"james.org\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}");
        }

        @Test
        void getShouldReturnNotFoundWhenDomainNotInList() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("strange.com", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'strange.com' is not managed by this James server"), new Object[0]);
        }

        @Test
        void getShouldReturnBadRequestWhenDomainIsNotValid() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("dr@strange.com", new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Domain parts ASCII chars must be a-z A-Z 0-9 - or _"), new Object[0]);
        }
    }

    @Nested
    class DefineClear {
        DefineClear(DLPConfigurationRoutesTest this$0) {
        }

        @Test
        void deleteShouldRemoveTheConfigurations() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.when().delete(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)"{\"rules\":[]}");
        }

        @Test
        void deleteShouldRemoveOnlyConfigurationsFromCorrespondingDomain() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String storeDomain2Body = "{\"rules\": [  {    \"id\": \"3\",    \"expression\": \"apache.org\",    \"targetsSender\": true  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeDomain2Body).when().put(DLPConfigurationRoutesTest.DOMAIN_2, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.when().delete(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)"{\"rules\":[]}");
            String retrievedBodyDomain2 = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(DLPConfigurationRoutesTest.DOMAIN_2, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBodyDomain2).isEqualTo((Object)"{\"rules\": [    {        \"id\": \"3\",        \"expression\": \"apache.org\",        \"explanation\": null,        \"targetsSender\": true,        \"targetsRecipients\": false,        \"targetsContent\": false    }]}");
        }

        @Test
        void deleteShouldReturnNotFoundWhenDomainNotInList() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("strange.com", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'strange.com' is not managed by this James server"), new Object[0]);
        }

        @Test
        void deleteShouldReturnBadRequestWhenDomainIsNotValid() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("dr@strange.com", new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Domain parts ASCII chars must be a-z A-Z 0-9 - or _"), new Object[0]);
        }
    }

    @Nested
    class DefineStore {
        DefineStore(DLPConfigurationRoutesTest this$0) {
        }

        @Test
        void putShouldStoreTheConfigurations() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)storeBody);
        }

        @Test
        void putShouldStoreTheConfigurationsWhenTargetsAreNotSpecified() {
            String storeBody = "{\"rules\": [  {    \"id\": \"3\",    \"expression\": \"expression 3\",    \"explanation\": \"explanation 3\"  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)"{\"rules\": [  {    \"id\": \"3\",    \"expression\": \"expression 3\",    \"explanation\": \"explanation 3\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}");
        }

        @Test
        void putShouldStoreTheConfigurationsWhenExplanationNotSpecified() {
            String storeBody = "{\"rules\": [{  \"id\": \"3\",  \"expression\": \"expression 3\"}]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)"{\"rules\": [  {    \"id\": \"3\",    \"expression\": \"expression 3\",    \"explanation\": null,    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}");
        }

        @Test
        void putShouldReturnBadRequestWhenIdIsNotSpecified() {
            String body = "{\"rules\": [{  \"expression\": \"expression 4\",  \"explanation\": \"explanation 4\",  \"targetsSender\": false,  \"targetsRecipients\": false,  \"targetsContent\": false}]}";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0])).body("details", Matchers.containsString((String)"'id' is mandatory"), new Object[0]);
        }

        @Test
        void putShouldReturnBadRequestWhenExpressionIsNotSpecified() {
            String body = "{\"rules\": [{  \"id\": \"5\",  \"explanation\": \"explanation 5\",  \"targetsSender\": false,  \"targetsRecipients\": false,  \"targetsContent\": false}]}";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"JSON payload of the request is not valid"), new Object[0])).body("details", Matchers.containsString((String)"'expression' is mandatory"), new Object[0]);
        }

        @Test
        void putShouldReturnNotFoundWhenDomainNotInList() {
            String body = "[{  \"id\": \"1\",  \"expression\": \"expression 1\",  \"explanation\": \"explanation 1\",  \"targetsSender\": true,  \"targetsRecipients\": true,  \"targetsContent\": true},{  \"id\": \"2\",  \"expression\": \"expression 2\",  \"explanation\": \"explanation 2\",  \"targetsSender\": false,  \"targetsRecipients\": false,  \"targetsContent\": false}]";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).when().put("strange.com", new Object[0])).then()).statusCode(404)).contentType("application/json")).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'strange.com' is not managed by this James server"), new Object[0]);
        }

        @Test
        void putShouldReturnBadRequestWhenDomainIsNotValid() {
            String body = "[{  \"id\": \"1\",  \"expression\": \"expression 1\",  \"explanation\": \"explanation 1\",  \"targetsSender\": true,  \"targetsRecipients\": true,  \"targetsContent\": true},{  \"id\": \"2\",  \"expression\": \"expression 2\",  \"explanation\": \"explanation 2\",  \"targetsSender\": false,  \"targetsRecipients\": false,  \"targetsContent\": false}]";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).when().put("dr@strange.com", new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"Domain parts ASCII chars must be a-z A-Z 0-9 - or _"), new Object[0]);
        }

        @Test
        void putShouldUpdateTheConfigurations() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  },  {    \"id\": \"3\",    \"expression\": \"expression 3\",    \"explanation\": \"explanation 3\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": true  }]}";
            String updatedBody = "{\"rules\": [  {    \"id\": \"4\",    \"expression\": \"expression 4\",    \"explanation\": \"explanation 4\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  },  {    \"id\": \"3\",    \"expression\": \"expression 3 updated\",    \"explanation\": \"explanation 3 updated\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": true  }]}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().body(updatedBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)updatedBody);
        }

        @Test
        void putShouldRejectDuplicatedIds() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"1\",    \"expression\": \"expression 3\",    \"explanation\": \"explanation 3\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": true  }]}";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().body(storeBody).log().ifValidationFails()).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(400)).contentType("application/json")).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"'id' duplicates are not allowed in DLP rules"), new Object[0]);
        }

        @Test
        void putShouldClearTheConfigurationsWhenNoRule() {
            String storeBody = "{\"rules\": [  {    \"id\": \"1\",    \"expression\": \"expression 1\",    \"explanation\": \"explanation 1\",    \"targetsSender\": true,    \"targetsRecipients\": true,    \"targetsContent\": true  },  {    \"id\": \"2\",    \"expression\": \"expression 2\",    \"explanation\": \"explanation 2\",    \"targetsSender\": false,    \"targetsRecipients\": false,    \"targetsContent\": false  }]}";
            String updatedBody = "{\"rules\": []}";
            ((ValidatableResponse)((Response)RestAssured.given().body(storeBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().body(updatedBody).when().put(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(204);
            String retrievedBody = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().get(DLPConfigurationRoutesTest.DEFAULT_DOMAIN, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().asString();
            JsonAssertions.assertThatJson((Object)retrievedBody).isEqualTo((Object)updatedBody);
        }
    }
}

