/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.InputStream;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.PlainBlobId;
import org.apache.james.blob.memory.MemoryBlobStoreDAO;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.server.blob.deduplication.BlobGCTaskAdditionalInformationDTO;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.BlobRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.AssertionsForClassTypes;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class BlobRoutesTest {
    private static final String BASE_PATH = "/blobs";
    private static final PlainBlobId.Factory BLOB_ID_FACTORY = new PlainBlobId.Factory();
    private static final ZonedDateTime TIMESTAMP = ZonedDateTime.parse("2015-10-30T16:12:00Z");
    private static final BucketName DEFAULT_BUCKET = BucketName.of((String)"default");
    private static final GenerationAwareBlobId.Configuration GENERATION_AWARE_BLOB_ID_CONFIGURATION = GenerationAwareBlobId.Configuration.DEFAULT;
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await().atMost(Durations.TEN_SECONDS);
    private WebAdminServer webAdminServer;
    private MemoryTaskManager taskManager;
    private UpdatableTickingClock clock;
    private BlobReferenceSource blobReferenceSource;
    private BlobStore blobStore;

    BlobRoutesTest() {
    }

    @BeforeEach
    void setUp() {
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        this.clock = new UpdatableTickingClock(TIMESTAMP.toInstant());
        this.blobReferenceSource = (BlobReferenceSource)Mockito.mock(BlobReferenceSource.class);
        Mockito.when((Object)this.blobReferenceSource.listReferencedBlobs()).thenReturn((Object)Flux.empty());
        GenerationAwareBlobId.Factory generationAwareBlobIdFactory = new GenerationAwareBlobId.Factory((Clock)this.clock, (BlobId.Factory)BLOB_ID_FACTORY, GENERATION_AWARE_BLOB_ID_CONFIGURATION);
        MemoryBlobStoreDAO blobStoreDAO = new MemoryBlobStoreDAO();
        this.blobStore = new DeDuplicationBlobStore((BlobStoreDAO)blobStoreDAO, DEFAULT_BUCKET, (BlobId.Factory)generationAwareBlobIdFactory);
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        TasksRoutes tasksRoutes = new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{BlobGCTaskAdditionalInformationDTO.SERIALIZATION_MODULE}));
        BlobRoutes blobRoutes = new BlobRoutes((TaskManager)this.taskManager, jsonTransformer, (Clock)this.clock, (BlobStoreDAO)blobStoreDAO, DEFAULT_BUCKET, (Set)ImmutableSet.of((Object)this.blobReferenceSource), GENERATION_AWARE_BLOB_ID_CONFIGURATION, generationAwareBlobIdFactory);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{blobRoutes, tasksRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath(BASE_PATH).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void deleteUnReferencedShouldReturnErrorWhenScopeInvalid() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("scope", new Object[]{"invalid"}).delete()).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'scope' is missing or must be 'unreferenced'"), new Object[0]);
    }

    @Test
    void deleteUnReferencedShouldReturnErrorWhenMissingScope() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().delete()).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"'scope' is missing or must be 'unreferenced'"), new Object[0]);
    }

    @Test
    void deleteUnReferencedShouldReturnTaskId() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void gcTaskShouldReturnDetail() {
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.deletionWindowSize", Matchers.is((Object)1000), new Object[0])).body("additionalInformation.bloomFilterExpectedBlobCount", Matchers.is((Object)1000000), new Object[0])).body("additionalInformation.bloomFilterAssociatedProbability", Matchers.is((Object)Float.valueOf(0.01f)), new Object[0]);
    }

    @Test
    void deleteUnReferencedShouldAcceptBloomFilterExpectedBlobCountParam() {
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).queryParam("expectedBlobCount", new Object[]{99}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("additionalInformation.bloomFilterExpectedBlobCount", Matchers.is((Object)99), new Object[0]);
    }

    @Test
    void deleteUnReferencedShouldAcceptDeletionWindowSizeParam() {
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).queryParam("deletionWindowSize", new Object[]{99}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("additionalInformation.deletionWindowSize", Matchers.is((Object)99), new Object[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"expectedBlobCountParameters"})
    void deleteUnReferencedShouldReturnErrorWhenExpectedBlobCountInvalid(Object expectedBlobCount) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).queryParam("expectedBlobCount", new Object[]{expectedBlobCount}).delete()).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.containsString((String)"expectedBlobCount"), new Object[0]);
    }

    private static Stream<Arguments> expectedBlobCountParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{-1}), Arguments.of((Object[])new Object[]{0}), Arguments.of((Object[])new Object[]{"invalid"}));
    }

    @Test
    void deleteUnReferencedShouldAcceptBloomFilterAssociatedProbabilityParam() {
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).queryParam("associatedProbability", new Object[]{0.2}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("additionalInformation.bloomFilterAssociatedProbability", Matchers.is((Object)Float.valueOf(0.2f)), new Object[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"associatedProbabilityParameters"})
    void deleteUnReferencedShouldReturnErrorWhenAssociatedProbabilityInvalid(Object associatedProbability) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).queryParam("associatedProbability", new Object[]{associatedProbability}).delete()).then()).statusCode(400)).contentType(ContentType.JSON)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.containsString((String)"associatedProbability"), new Object[0]);
    }

    private static Stream<Arguments> associatedProbabilityParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{-1}), Arguments.of((Object[])new Object[]{Float.valueOf(-0.1f)}), Arguments.of((Object[])new Object[]{1.1}), Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"invalid"}), Arguments.of((Object[])new Object[]{""}));
    }

    @Test
    void gcTaskShouldRemoveOrphanBlob() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block();
        this.clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
        AssertionsForClassTypes.assertThatThrownBy(() -> this.blobStore.read(DEFAULT_BUCKET, blobId)).isInstanceOf(ObjectNotFoundException.class);
    }

    @Test
    void gcTaskShouldNotRemoveUnExpireBlob() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
        AssertionsForClassTypes.assertThat((InputStream)this.blobStore.read(DEFAULT_BUCKET, blobId)).isNotNull();
    }

    @Test
    void gcTaskShouldNotRemoveReferencedBlob() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block();
        Mockito.when((Object)this.blobReferenceSource.listReferencedBlobs()).thenReturn((Object)Flux.just((Object)blobId));
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
        AssertionsForClassTypes.assertThat((InputStream)this.blobStore.read(DEFAULT_BUCKET, blobId)).isNotNull();
    }

    @Test
    void gcTaskShouldSuccessWhenMixCase() {
        List<BlobId> referencedBlobIds = IntStream.range(0, 100).mapToObj(index -> (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block()).collect(Collectors.toList());
        List orphanBlobIds = IntStream.range(0, 50).mapToObj(index -> (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block()).collect(Collectors.toList());
        Mockito.when((Object)this.blobReferenceSource.listReferencedBlobs()).thenReturn((Object)Flux.fromIterable(referencedBlobIds));
        this.clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        List<BlobId> unExpiredBlobIds = IntStream.range(0, 30).mapToObj(index -> (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block()).collect(Collectors.toList());
        String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)referencedBlobIds.size()), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)(referencedBlobIds.size() + orphanBlobIds.size() + unExpiredBlobIds.size())), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(orphanBlobIds.size())), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
        referencedBlobIds.forEach(blobId -> AssertionsForClassTypes.assertThat((InputStream)this.blobStore.read(DEFAULT_BUCKET, blobId)).isNotNull());
        unExpiredBlobIds.forEach(blobId -> AssertionsForClassTypes.assertThat((InputStream)this.blobStore.read(DEFAULT_BUCKET, blobId)).isNotNull());
    }

    @Test
    void allOrphanBlobIdsShouldRemovedAfterMultipleCallDeleteUnreferenced() {
        List referencedBlobIds = IntStream.range(0, 100).mapToObj(index -> (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block()).collect(Collectors.toList());
        List orphanBlobIds = IntStream.range(0, 50).mapToObj(index -> (BlobId)Mono.from((Publisher)this.blobStore.save(DEFAULT_BUCKET, UUID.randomUUID().toString(), BlobStore.StoragePolicy.HIGH_PERFORMANCE)).block()).collect(Collectors.toList());
        Mockito.when((Object)this.blobReferenceSource.listReferencedBlobs()).thenReturn((Object)Flux.fromIterable(referencedBlobIds));
        this.clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        CALMLY_AWAIT.untilAsserted(() -> {
            String taskId = (String)((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete()).jsonPath().get("taskId");
            RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0]);
            orphanBlobIds.forEach(blobId -> AssertionsForClassTypes.assertThatThrownBy(() -> this.blobStore.read(DEFAULT_BUCKET, blobId)).isInstanceOf(ObjectNotFoundException.class));
        });
    }
}

