/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.dto.MappingSourceModule;
import org.apache.james.webadmin.routes.AddressMappingRoutes;
import org.apache.james.webadmin.routes.AliasRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class AliasRoutesTest {
    private static final Domain DOMAIN = Domain.of((String)"b.com");
    private static final Domain ALIAS_DOMAIN = Domain.of((String)"alias");
    private static final Domain DOMAIN_MAPPING = Domain.of((String)"mapping");
    public static final String BOB = "bob@" + DOMAIN.name();
    public static final String BOB_WITH_SLASH = "bob/@" + DOMAIN.name();
    public static final String BOB_WITH_ENCODED_SLASH = "bob%2F@" + DOMAIN.name();
    public static final String BOB_ALIAS = "bob-alias@" + DOMAIN.name();
    public static final String BOB_ALIAS_2 = "bob-alias2@" + DOMAIN.name();
    public static final String BOB_ALIAS_WITH_SLASH = "bob-alias/@" + DOMAIN.name();
    public static final String BOB_ALIAS_WITH_ENCODED_SLASH = "bob-alias%2F@" + DOMAIN.name();
    public static final String ALICE = "alice@" + DOMAIN.name();
    public static final String ALICE_ALIAS = "alice-alias@" + DOMAIN.name();
    public static final String BOB_PASSWORD = "123456";
    public static final String BOB_WITH_SLASH_PASSWORD = "abcdef";
    public static final String ALICE_PASSWORD = "789123";
    private WebAdminServer webAdminServer;

    AliasRoutesTest() {
    }

    private void createServer(AliasRoutes aliasRoutes, AddressMappingRoutes addressMappingRoutes) {
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{aliasRoutes, addressMappingRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("address/aliases").setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Nested
    class ExceptionHandling {
        private MemoryRecipientRewriteTable memoryRecipientRewriteTable;
        private DomainList domainList;

        ExceptionHandling() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = (MemoryRecipientRewriteTable)Mockito.spy((Object)new MemoryRecipientRewriteTable());
            UsersRepository userRepository = (UsersRepository)Mockito.mock(UsersRepository.class);
            this.domainList = (DomainList)Mockito.mock(DomainList.class);
            this.memoryRecipientRewriteTable.setDomainList(this.domainList);
            this.memoryRecipientRewriteTable.setUsersRepository(userRepository);
            this.memoryRecipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
            Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenReturn((Object)true);
            AliasRoutesTest.this.createServer(new AliasRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, this.domainList, new JsonTransformer(new JsonTransformerModule[0])), new AddressMappingRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable));
        }

        @Test
        void putAliasSourceContainingNotManagedDomainShouldReturnBadRequest() throws Exception {
            Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenAnswer(invocation -> ((Domain)invocation.getArgument(0, Domain.class)).equals((Object)DOMAIN));
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/bob@not-managed-domain.tld", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Source domain 'not-managed-domain.tld' is not managed by the domainList");
        }

        @Test
        void putAliasDestinationContainingNotManagedDomainShouldReturnBadRequest() throws Exception {
            Mockito.when((Object)this.domainList.containsDomain((Domain)ArgumentMatchers.any())).thenAnswer(invocation -> ((Domain)invocation.getArgument(0, Domain.class)).equals((Object)DOMAIN));
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("bob@not-managed-domain.tld/sources/" + BOB, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Domain in the destination is not managed by the DomainList");
        }

        @Test
        void putMalformedUserDestinationShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put("not-an-address/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The alias is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putMalformedAliasSourceShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The alias is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void putUserDestinationInAliasWithSlashShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB_WITH_SLASH + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putAliasSourceWithSlashShouldReturnNotFound() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS_WITH_SLASH, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putRequiresTwoPathParams() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB, new Object[0])).then()).statusCode(404);
        }

        @Test
        void deleteMalformedUserDestinationShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("not-an-address/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The alias is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteMalformedAliasShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete(BOB + "/sources/not-an-address", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"The alias is not an email address")).containsEntry((Object)"details", (Object)"Out of data at position 1 in 'not-an-address'");
        }

        @Test
        void deleteRequiresTwoPathParams() {
            ((ValidatableResponse)((Response)RestAssured.when().delete(BOB, new Object[0])).then()).statusCode(404);
        }

        @Test
        void putShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).addAliasMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(500);
        }

        @Test
        void putShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).addAliasMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).getMappingsForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void getAllShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).getMappingsForType((Mapping.Type)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).removeAliasMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(500);
        }

        @Test
        void deleteShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).removeAliasMapping((MappingSource)ArgumentMatchers.any(), ArgumentMatchers.anyString());
            ((ValidatableResponse)((Response)RestAssured.when().delete(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getShouldReturnErrorWhenRecipientRewriteTableExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RecipientRewriteTableException.class).when((Object)this.memoryRecipientRewriteTable)).listSources((Mapping)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).statusCode(500);
        }

        @Test
        void getShouldReturnErrorWhenRuntimeExceptionIsThrown() throws Exception {
            ((MemoryRecipientRewriteTable)Mockito.doThrow(RuntimeException.class).when((Object)this.memoryRecipientRewriteTable)).listSources((Mapping)ArgumentMatchers.any());
            ((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).statusCode(500);
        }
    }

    @Nested
    class FilteringOtherRewriteRuleTypes
    extends NormalBehaviour {
        FilteringOtherRewriteRuleTypes(AliasRoutesTest this$0) {
        }

        @BeforeEach
        void setup() throws Exception {
            super.setUp();
            this.memoryRecipientRewriteTable.addErrorMapping(MappingSource.fromUser((String)"error", (Domain)DOMAIN), "disabled");
            this.memoryRecipientRewriteTable.addRegexMapping(MappingSource.fromUser((String)"regex", (Domain)DOMAIN), ".*@b\\.com");
            this.memoryRecipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)ALIAS_DOMAIN), DOMAIN);
            this.memoryRecipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)DOMAIN_MAPPING), DOMAIN);
        }
    }

    @Nested
    class NormalBehaviour {
        MemoryUsersRepository usersRepository;
        MemoryDomainList domainList;
        MemoryRecipientRewriteTable memoryRecipientRewriteTable;

        NormalBehaviour() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.memoryRecipientRewriteTable = new MemoryRecipientRewriteTable();
            DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
            this.domainList = new MemoryDomainList(dnsService);
            this.domainList.configure(DomainListConfiguration.DEFAULT);
            this.domainList.addDomain(DOMAIN);
            this.domainList.addDomain(ALIAS_DOMAIN);
            this.domainList.addDomain(DOMAIN_MAPPING);
            MappingSourceModule module = new MappingSourceModule();
            this.memoryRecipientRewriteTable.setDomainList((DomainList)this.domainList);
            this.memoryRecipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
            this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.domainList);
            this.usersRepository.addUser(Username.of((String)BOB), AliasRoutesTest.BOB_PASSWORD);
            this.usersRepository.addUser(Username.of((String)BOB_WITH_SLASH), AliasRoutesTest.BOB_WITH_SLASH_PASSWORD);
            this.usersRepository.addUser(Username.of((String)ALICE), AliasRoutesTest.ALICE_PASSWORD);
            UserEntityValidator validator = UserEntityValidator.aggregate((UserEntityValidator[])new UserEntityValidator[]{new DefaultUserEntityValidator((UsersRepository)this.usersRepository), new RecipientRewriteTableUserEntityValidator((RecipientRewriteTable)this.memoryRecipientRewriteTable)});
            this.memoryRecipientRewriteTable.setUserEntityValidator(validator);
            this.memoryRecipientRewriteTable.setUsersRepository((UsersRepository)this.usersRepository);
            AliasRoutesTest.this.createServer(new AliasRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable, (DomainList)this.domainList, new JsonTransformer(new JsonTransformerModule[]{module})), new AddressMappingRoutes((RecipientRewriteTable)this.memoryRecipientRewriteTable));
        }

        @Test
        void getAliasesShouldBeEmpty() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void getAliasesShouldListExistingAliasesInAlphabeticOrder() {
            RestAssured.with().put(ALICE + "/sources/" + ALICE_ALIAS, new Object[0]);
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            List addresses = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath().getList(".");
            Assertions.assertThat((List)addresses).containsExactly((Object[])new String[]{ALICE, BOB});
        }

        @Test
        void putShouldDetectConflicts() {
            RestAssured.with().basePath("/mappings/address/").post(ALICE + "/targets/" + ALICE_ALIAS, new Object[0]);
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/sources/" + ALICE_ALIAS, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"Creation of redirection of alice-alias@b.com to alias:alice@b.com would lead to a loop, operation not performed");
        }

        @Test
        void putShouldDetectConflictsWithGroups() throws Exception {
            this.memoryRecipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)ALICE_ALIAS)), BOB);
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(ALICE + "/sources/" + ALICE_ALIAS, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"'alice-alias@b.com' already have associated mappings: group:bob@b.com");
        }

        @Test
        void getNotRegisteredAliasesShouldReturnEmptyList() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("unknown@domain.travel", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void getAliasesShouldReturnEmptyListWhenNoAliasMappings() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void putAliasForUserShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putAliasShouldBeIdempotent() {
            RestAssured.given().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putAliasWithSlashForUserShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + BOB_ALIAS_WITH_ENCODED_SLASH, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putUserForAliasWithEncodedSlashShouldReturnNoContent() {
            ((ValidatableResponse)((Response)RestAssured.when().put(BOB_WITH_ENCODED_SLASH + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(204);
        }

        @Test
        void putExistingUserAsAliasSourceShouldNotBePossible() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(BOB + "/sources/" + ALICE, new Object[0])).then()).statusCode(409)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"'alice@b.com' user already exist");
        }

        @Test
        void putSameSourceAndDestinationShouldReturnBadRequest() {
            Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().put(BOB_ALIAS + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Source and destination can't be the same!");
        }

        @Test
        void putAliasForUserShouldCreateAlias() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
        }

        @Test
        void putAliasWithEncodedSlashForUserShouldAddItAsADestination() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS_WITH_ENCODED_SLASH, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS_WITH_SLASH}), new Object[0]);
        }

        @Test
        void putAliasForUserWithEncodedSlashShouldCreateAlias() {
            RestAssured.with().put(BOB_WITH_ENCODED_SLASH + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB_WITH_ENCODED_SLASH, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
        }

        @Test
        void putSameAliasForUserTwiceShouldBeIdempotent() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
        }

        @Test
        void putAliasForUserShouldAllowSeveralSourcesAndReturnThemInAlphabeticalOrder() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS_2, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS, BOB_ALIAS_2}), new Object[0]);
        }

        @Test
        void putAliasForUserShouldAllowSeveralDestinations() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            RestAssured.with().put(ALICE + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(ALICE, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
        }

        @Test
        void putAliasForUserShouldNotRequireExistingBaseUser() {
            String notExistingAddress = "notFound@" + DOMAIN.name();
            RestAssured.with().put(notExistingAddress + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(notExistingAddress, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{BOB_ALIAS}), new Object[0]);
        }

        @Test
        void deleteAliasNotInAliasesShouldReturnOK() {
            ((ValidatableResponse)((Response)RestAssured.when().delete(BOB + "/sources/" + BOB_ALIAS, new Object[0])).then()).statusCode(204);
        }

        @Test
        void deleteAliasInAliasesShouldDeleteAliasForUser() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            RestAssured.with().delete(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(BOB_ALIAS, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }

        @Test
        void deleteLastAliasOfUserInAliasesShouldDeleteUserFromAliasList() {
            RestAssured.with().put(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            RestAssured.with().delete(BOB + "/sources/" + BOB_ALIAS, new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).contentType(ContentType.JSON)).statusCode(200)).body(CoreMatchers.is((Object)"[]"), new Matcher[0]);
        }
    }
}

