/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.AddressMappingRoutes;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AddressMappingRoutesTest {
    private static final String MAPPING_SOURCE = "source@domain.tld";
    private static final String ALICE_ADDRESS = "alice@domain.tld";
    private static final String ALICE_WITH_SLASH = "alice/@domain.tld";
    private static final String ALICE_WITH_ENCODED_SLASH = "alice%2F@domain.tld";
    private static final String BOB_ADDRESS = "bob@domain.tld";
    private WebAdminServer webAdminServer;
    private MemoryRecipientRewriteTable recipientRewriteTable;

    AddressMappingRoutesTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.recipientRewriteTable = new MemoryRecipientRewriteTable();
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(Domain.of((String)"domain.tld"));
        this.recipientRewriteTable.setDomainList((DomainList)domainList);
        this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new AddressMappingRoutes((RecipientRewriteTable)this.recipientRewriteTable)}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/mappings/address/").setUrlEncodingEnabled(false).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
    }

    @Test
    void addAddressMappingShouldAddMappingOnRecipientRewriteTable() {
        RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        Assertions.assertThat((Iterable)this.recipientRewriteTable.getStoredMappings(MappingSource.parse((String)MAPPING_SOURCE))).containsAnyOf((Object[])new Mapping[]{Mapping.of((String)ALICE_ADDRESS)});
    }

    @Test
    void addAddressMappingShouldSupportOneTimeEncodedAddress() {
        RestAssured.when().post("source@domain.tld/targets/alice%2F@domain.tld", new Object[0]);
        Assertions.assertThat((Iterable)this.recipientRewriteTable.getStoredMappings(MappingSource.parse((String)MAPPING_SOURCE))).containsAnyOf((Object[])new Mapping[]{Mapping.of((String)ALICE_WITH_SLASH)});
    }

    @Test
    void postShouldDetectLoops() {
        RestAssured.with().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().post("alice@domain.tld/targets/source@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(409)).extract().body().jsonPath().getMap(".");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)409)).containsEntry((Object)"type", (Object)"WrongState")).containsEntry((Object)"message", (Object)"Creation of redirection of alice@domain.tld to source@domain.tld would lead to a loop, operation not performed");
    }

    @Test
    void addAddressMappingShouldReturnNotFoundWhenOneParameterIsEmpty() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain.tld/targets/", new Object[0])).then()).statusCode(404);
    }

    @Test
    void addAddressMappingShouldReturnNoContentWhenValidParameter() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0])).then()).statusCode(204);
    }

    @Test
    void addAddressMappingShouldReturnBadRequestWhenInvalidMappingSource() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain@domain/targets/alice@domain.tld", new Object[0])).then()).statusCode(400);
    }

    @Test
    void addAddressMappingShouldReturnBadRequestWhenInvalidDestinationAddress() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain.tld/targets/alice", new Object[0])).then()).statusCode(400);
    }

    @Test
    void addAddressMappingShouldReturnNoContentWithDuplicatedAddress() throws Exception {
        MappingSource mappingSource = MappingSource.fromMailAddress((MailAddress)new MailAddress(MAPPING_SOURCE));
        this.recipientRewriteTable.addAddressMapping(mappingSource, ALICE_ADDRESS);
        this.recipientRewriteTable.addAddressMapping(mappingSource, BOB_ADDRESS);
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0])).then()).statusCode(204);
    }

    @Test
    void addAddressMappingShouldReturnBadRequestWhenSourceAndDestinationIsTheSame() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@domain.tld/targets/source@domain.tld", new Object[0])).then()).statusCode(400);
    }

    @Test
    void addAddressMappingShouldReturnBadRequestWhenSourceDomainNotInDomainList() {
        ((ValidatableResponse)((Response)RestAssured.when().post("source@example/targets/alice@domain.tld", new Object[0])).then()).statusCode(400);
    }

    @Test
    void removeAddressMappingShouldRemoveDestinationAddress() {
        RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        RestAssured.when().delete("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        Assertions.assertThat((Iterable)this.recipientRewriteTable.getStoredMappings(MappingSource.parse((String)MAPPING_SOURCE))).doesNotContain((Object[])new Mapping[]{Mapping.of((String)ALICE_ADDRESS)});
    }

    @Test
    void removeAddressMappingShouldReturnNoContentWhenValidParameter() {
        RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().delete("source@domain.tld/targets/alice@domain.tld", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removeAddressMappingShouldReturnNoContentWhenDestinationAddressIsNotFound() {
        RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().delete("source@domain.tld/targets/bob@domain.tld", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removeAddressMappingShouldBeIdempotent() {
        RestAssured.when().post("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        RestAssured.when().delete("source@domain.tld/targets/alice@domain.tld", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().delete("source@domain.tld/targets/alice@domain.tld", new Object[0])).then()).statusCode(204);
    }

    @Test
    void removeAddressMappingShouldReturnBadRequestWhenMappingSourceIsInvalid() {
        ((ValidatableResponse)((Response)RestAssured.when().delete("random@domain@domain/targets/alice@domain.tld", new Object[0])).then()).statusCode(400);
    }

    @Test
    void removeAddressMappingShouldReturnNotFoundWhenOneParameterIsEmpty() {
        ((ValidatableResponse)((Response)RestAssured.when().delete("source@domain.tld/targets/", new Object[0])).then()).statusCode(404);
    }
}

