/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import java.time.ZonedDateTime;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.webadmin.dto.VacationDTO;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class VacationDTOTest {
    VacationDTOTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(VacationDTO.class).verify();
    }

    @Test
    void fromShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> VacationDTO.from(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldSetAllFields() {
        Vacation vacation = Vacation.builder().enabled(false).fromDate(Optional.of(ZonedDateTime.parse("2021-09-13T10:00:00Z"))).toDate(Optional.of(ZonedDateTime.parse("2021-09-20T19:00:00Z"))).subject(Optional.of("I am on vacation")).textBody(Optional.of("I am on vacation, will be back soon.")).htmlBody(Optional.of("<p>I am on vacation, will be back soon.</p>")).build();
        VacationDTO dto = VacationDTO.from((Vacation)vacation);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dto.getEnabled()).isNotEmpty();
            softly.assertThat((Boolean)dto.getEnabled().get()).isEqualTo(vacation.isEnabled());
            softly.assertThat(dto.getFromDate()).isEqualTo((Object)vacation.getFromDate());
            softly.assertThat(dto.getToDate()).isEqualTo((Object)vacation.getToDate());
            softly.assertThat(dto.getSubject()).isEqualTo((Object)vacation.getSubject());
            softly.assertThat(dto.getTextBody()).isEqualTo((Object)vacation.getTextBody());
            softly.assertThat(dto.getHtmlBody()).isEqualTo((Object)vacation.getHtmlBody());
        });
    }
}

