/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import java.util.Optional;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.webadmin.dto.DLPConfigurationItemDTO;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class DLPConfigurationItemDTOTest {
    private static final String ID = "id";
    private static final String EXPRESSION = "expression";
    private static final String EXPLANATION = "explanation";
    private static final String NULL_ID = null;
    private static final String NULL_EXPRESSION = null;

    DLPConfigurationItemDTOTest() {
    }

    @Test
    void toDTOsShouldSetAllFields() {
        DLPConfigurationItemDTO dto = DLPConfigurationItemDTO.toDTO((DLPConfigurationItem)DLPConfigurationItem.builder().id(DLPConfigurationItem.Id.of((String)ID)).expression(EXPRESSION).explanation(EXPLANATION).targetsSender(true).targetsRecipients(true).targetsContent(false).build());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dto.getId()).isEqualTo(ID);
            softly.assertThat(dto.getExpression()).isEqualTo(EXPRESSION);
            softly.assertThat((String)dto.getExplanation().get()).isEqualTo(EXPLANATION);
            softly.assertThat(dto.getTargetsSender()).isTrue();
            softly.assertThat(dto.getTargetsRecipients()).isTrue();
            softly.assertThat(dto.getTargetsContent()).isFalse();
        });
    }

    @Test
    void toDLPConfigurationsShouldSetAllFields() {
        DLPConfigurationItemDTO itemDTO = new DLPConfigurationItemDTO(ID, EXPRESSION, Optional.of(EXPLANATION), true, true, true);
        DLPConfigurationItem item = itemDTO.toDLPConfiguration();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(item.getId().asString()).isEqualTo(ID);
            softly.assertThat(item.getRegexp().pattern()).isEqualTo(EXPRESSION);
            softly.assertThat((String)item.getExplanation().get()).isEqualTo(EXPLANATION);
            softly.assertThat(item.getTargets().isSenderTargeted()).isTrue();
            softly.assertThat(item.getTargets().isRecipientTargeted()).isTrue();
            softly.assertThat(item.getTargets().isContentTargeted()).isTrue();
        });
    }

    @Test
    void constructorShouldThrowWhenIdIsNull() {
        Assertions.assertThatThrownBy(() -> new DLPConfigurationItemDTO(NULL_ID, EXPRESSION, Optional.of(EXPLANATION), true, true, true)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowWhenExpressionIsNull() {
        Assertions.assertThatThrownBy(() -> new DLPConfigurationItemDTO(ID, NULL_EXPRESSION, Optional.of(EXPLANATION), true, true, true)).isInstanceOf(NullPointerException.class);
    }
}

