/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model;

import com.google.common.annotations.VisibleForTesting;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.james.core.Username;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity(name="Mailbox")
@Table(name="JAMES_MAILBOX")
@NamedQueries(value={@NamedQuery(name="findMailboxById", query="SELECT mailbox FROM Mailbox mailbox WHERE mailbox.mailboxId = :idParam"), @NamedQuery(name="findMailboxByName", query="SELECT mailbox FROM Mailbox mailbox WHERE mailbox.name = :nameParam and mailbox.user is NULL and mailbox.namespace= :namespaceParam"), @NamedQuery(name="findMailboxByNameWithUser", query="SELECT mailbox FROM Mailbox mailbox WHERE mailbox.name = :nameParam and mailbox.user= :userParam and mailbox.namespace= :namespaceParam"), @NamedQuery(name="findMailboxWithNameLikeWithUser", query="SELECT mailbox FROM Mailbox mailbox WHERE mailbox.name LIKE :nameParam and mailbox.user= :userParam and mailbox.namespace= :namespaceParam"), @NamedQuery(name="findMailboxWithNameLike", query="SELECT mailbox FROM Mailbox mailbox WHERE mailbox.name LIKE :nameParam and mailbox.user is NULL and mailbox.namespace= :namespaceParam"), @NamedQuery(name="countMailboxesWithNameLikeWithUser", query="SELECT COUNT(mailbox) FROM Mailbox mailbox WHERE mailbox.name LIKE :nameParam and mailbox.user= :userParam and mailbox.namespace= :namespaceParam"), @NamedQuery(name="countMailboxesWithNameLike", query="SELECT COUNT(mailbox) FROM Mailbox mailbox WHERE mailbox.name LIKE :nameParam and mailbox.user is NULL and mailbox.namespace= :namespaceParam"), @NamedQuery(name="listMailboxes", query="SELECT mailbox FROM Mailbox mailbox"), @NamedQuery(name="findHighestModSeq", query="SELECT mailbox.highestModSeq FROM Mailbox mailbox WHERE mailbox.mailboxId = :idParam"), @NamedQuery(name="findLastUid", query="SELECT mailbox.lastUid FROM Mailbox mailbox WHERE mailbox.mailboxId = :idParam")})
public class JPAMailbox
implements PersistenceCapable {
    private static final String TAB = " ";
    @Id
    @GeneratedValue
    @Column(name="MAILBOX_ID")
    private long mailboxId;
    @Basic(optional=false)
    @Column(name="MAILBOX_NAME", nullable=false, length=200)
    private String name;
    @Basic(optional=false)
    @Column(name="MAILBOX_UID_VALIDITY", nullable=false)
    private long uidValidity;
    @Basic(optional=true)
    @Column(name="USER_NAME", nullable=true, length=200)
    private String user;
    @Basic(optional=false)
    @Column(name="MAILBOX_NAMESPACE", nullable=false, length=200)
    private String namespace;
    @Basic(optional=false)
    @Column(name="MAILBOX_LAST_UID", nullable=true)
    private long lastUid;
    @Basic(optional=false)
    @Column(name="MAILBOX_HIGHEST_MODSEQ", nullable=true)
    private long highestModSeq;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    public static JPAMailbox from(Mailbox mailbox) {
        return new JPAMailbox(mailbox);
    }

    @Deprecated
    public JPAMailbox() {
    }

    public JPAMailbox(MailboxPath path, UidValidity uidValidity) {
        this(path, uidValidity.asLong());
    }

    @VisibleForTesting
    public JPAMailbox(MailboxPath path, long uidValidity) {
        this.name = path.getName();
        this.user = path.getUser().asString();
        this.namespace = path.getNamespace();
        this.uidValidity = uidValidity;
    }

    public JPAMailbox(Mailbox mailbox) {
        this(mailbox.generateAssociatedPath(), mailbox.getUidValidity());
    }

    public JPAId getMailboxId() {
        return JPAId.of(JPAMailbox.pcGetmailboxId(this));
    }

    public long consumeUid() {
        JPAMailbox jPAMailbox = this;
        long l = JPAMailbox.pcGetlastUid(jPAMailbox) + 1L;
        JPAMailbox.pcSetlastUid(jPAMailbox, l);
        return l;
    }

    public long consumeModSeq() {
        JPAMailbox jPAMailbox = this;
        long l = JPAMailbox.pcGethighestModSeq(jPAMailbox) + 1L;
        JPAMailbox.pcSethighestModSeq(jPAMailbox, l);
        return l;
    }

    public Mailbox toMailbox() {
        MailboxPath path = new MailboxPath(JPAMailbox.pcGetnamespace(this), Username.of((String)JPAMailbox.pcGetuser(this)), JPAMailbox.pcGetname(this));
        return new Mailbox(path, this.sanitizeUidValidity(), (MailboxId)new JPAId(JPAMailbox.pcGetmailboxId(this)));
    }

    private UidValidity sanitizeUidValidity() {
        if (UidValidity.isValid((long)JPAMailbox.pcGetuidValidity(this))) {
            return UidValidity.of((long)JPAMailbox.pcGetuidValidity(this));
        }
        UidValidity sanitizedUidValidity = UidValidity.generate();
        this.setUidValidity(sanitizedUidValidity.asLong());
        return sanitizedUidValidity;
    }

    public void setMailboxId(long mailboxId) {
        JPAMailbox.pcSetmailboxId(this, mailboxId);
    }

    public String getName() {
        return JPAMailbox.pcGetname(this);
    }

    public void setName(String name) {
        JPAMailbox.pcSetname(this, name);
    }

    public String getUser() {
        return JPAMailbox.pcGetuser(this);
    }

    public void setUser(String user) {
        JPAMailbox.pcSetuser(this, user);
    }

    public void setNamespace(String namespace) {
        JPAMailbox.pcSetnamespace(this, namespace);
    }

    public void setUidValidity(long uidValidity) {
        JPAMailbox.pcSetuidValidity(this, uidValidity);
    }

    public String toString() {
        return "Mailbox ( mailboxId = " + JPAMailbox.pcGetmailboxId(this) + " name = " + JPAMailbox.pcGetname(this) + " uidValidity = " + JPAMailbox.pcGetuidValidity(this) + "  )";
    }

    public final boolean equals(Object o) {
        if (o instanceof JPAMailbox) {
            JPAMailbox that = (JPAMailbox)o;
            return Objects.equals(JPAMailbox.pcGetmailboxId(this), JPAMailbox.pcGetmailboxId(that));
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(JPAMailbox.pcGetmailboxId(this));
    }

    public int pcGetEnhancementContractVersion() {
        return 106714633;
    }

    static {
        pcFieldNames = new String[]{"highestModSeq", "lastUid", "mailboxId", "name", "namespace", "uidValidity", "user"};
        pcFieldTypes = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPAMailbox.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Mailbox", (PersistenceCapable)new JPAMailbox());
    }

    protected void pcClearFields() {
        this.highestModSeq = 0L;
        this.lastUid = 0L;
        this.mailboxId = 0L;
        this.name = null;
        this.namespace = null;
        this.uidValidity = 0L;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMailbox jPAMailbox = new JPAMailbox();
        if (bl) {
            jPAMailbox.pcClearFields();
        }
        jPAMailbox.pcStateManager = stateManager;
        jPAMailbox.pcCopyKeyFieldsFromObjectId(object);
        return jPAMailbox;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMailbox jPAMailbox = new JPAMailbox();
        if (bl) {
            jPAMailbox.pcClearFields();
        }
        jPAMailbox.pcStateManager = stateManager;
        return jPAMailbox;
    }

    protected static int pcGetManagedFieldCount() {
        return 7;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.highestModSeq = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.lastUid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.mailboxId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.namespace = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.uidValidity = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.highestModSeq);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.lastUid);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.mailboxId);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.namespace);
                return;
            }
            case 5: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.uidValidity);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAMailbox jPAMailbox, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.highestModSeq = jPAMailbox.highestModSeq;
                return;
            }
            case 1: {
                this.lastUid = jPAMailbox.lastUid;
                return;
            }
            case 2: {
                this.mailboxId = jPAMailbox.mailboxId;
                return;
            }
            case 3: {
                this.name = jPAMailbox.name;
                return;
            }
            case 4: {
                this.namespace = jPAMailbox.namespace;
                return;
            }
            case 5: {
                this.uidValidity = jPAMailbox.uidValidity;
                return;
            }
            case 6: {
                this.user = jPAMailbox.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAMailbox jPAMailbox = (JPAMailbox)object;
        if (jPAMailbox.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAMailbox, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(2 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.mailboxId = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(JPAMailbox.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new LongId(JPAMailbox.class, this.mailboxId);
    }

    private static final long pcGethighestModSeq(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.highestModSeq;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.highestModSeq;
    }

    private static final void pcSethighestModSeq(JPAMailbox jPAMailbox, long l) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.highestModSeq = l;
            return;
        }
        jPAMailbox.pcStateManager.settingLongField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 0, jPAMailbox.highestModSeq, l, 0);
    }

    private static final long pcGetlastUid(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.lastUid;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.lastUid;
    }

    private static final void pcSetlastUid(JPAMailbox jPAMailbox, long l) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.lastUid = l;
            return;
        }
        jPAMailbox.pcStateManager.settingLongField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 1, jPAMailbox.lastUid, l, 0);
    }

    private static final long pcGetmailboxId(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.mailboxId;
        }
        int n = pcInheritedFieldCount + 2;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.mailboxId;
    }

    private static final void pcSetmailboxId(JPAMailbox jPAMailbox, long l) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.mailboxId = l;
            return;
        }
        jPAMailbox.pcStateManager.settingLongField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 2, jPAMailbox.mailboxId, l, 0);
    }

    private static final String pcGetname(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.name;
        }
        int n = pcInheritedFieldCount + 3;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.name;
    }

    private static final void pcSetname(JPAMailbox jPAMailbox, String string) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.name = string;
            return;
        }
        jPAMailbox.pcStateManager.settingStringField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 3, jPAMailbox.name, string, 0);
    }

    private static final String pcGetnamespace(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.namespace;
        }
        int n = pcInheritedFieldCount + 4;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.namespace;
    }

    private static final void pcSetnamespace(JPAMailbox jPAMailbox, String string) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.namespace = string;
            return;
        }
        jPAMailbox.pcStateManager.settingStringField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 4, jPAMailbox.namespace, string, 0);
    }

    private static final long pcGetuidValidity(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.uidValidity;
        }
        int n = pcInheritedFieldCount + 5;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.uidValidity;
    }

    private static final void pcSetuidValidity(JPAMailbox jPAMailbox, long l) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.uidValidity = l;
            return;
        }
        jPAMailbox.pcStateManager.settingLongField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 5, jPAMailbox.uidValidity, l, 0);
    }

    private static final String pcGetuser(JPAMailbox jPAMailbox) {
        if (jPAMailbox.pcStateManager == null) {
            return jPAMailbox.user;
        }
        int n = pcInheritedFieldCount + 6;
        jPAMailbox.pcStateManager.accessingField(n);
        return jPAMailbox.user;
    }

    private static final void pcSetuser(JPAMailbox jPAMailbox, String string) {
        if (jPAMailbox.pcStateManager == null) {
            jPAMailbox.user = string;
            return;
        }
        jPAMailbox.pcStateManager.settingStringField((PersistenceCapable)jPAMailbox, pcInheritedFieldCount + 6, jPAMailbox.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.mailboxId != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

