/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.DifferentDomainException;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import reactor.core.publisher.Mono;

public class StoreRightManager
implements RightManager {
    private final EventBus eventBus;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxACLResolver aclResolver;

    @Inject
    public StoreRightManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, MailboxACLResolver aclResolver, EventBus eventBus) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.aclResolver = aclResolver;
        this.eventBus = eventBus;
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.myRights(mailboxPath, session).contains(right);
    }

    public Mono<Boolean> hasRightReactive(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) {
        return this.myRightsReactive(mailboxPath, session).filter(rights -> rights.contains(right)).hasElement();
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return ((MailboxACL.Rfc4314Rights)MailboxReactorUtils.block(Mono.from(this.myRights(mailboxId, session)))).contains(right);
    }

    public boolean hasRight(Mailbox mailbox, MailboxACL.Right right, MailboxSession session) {
        return this.myRights(mailbox, session).contains(right);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.myRightsReactive(mailboxPath, session));
    }

    public Mono<MailboxACL.Rfc4314Rights> myRightsReactive(MailboxPath mailboxPath, MailboxSession session) {
        return this.mailboxSessionMapperFactory.getMailboxMapper(session).findMailboxByPath(mailboxPath).map(mailbox -> {
            if (mailboxPath.belongsTo(session)) {
                return MailboxACL.FULL_RIGHTS;
            }
            return this.myRights((Mailbox)mailbox, session);
        }).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath)));
    }

    public Mono<MailboxACL.Rfc4314Rights> myRights(MailboxId mailboxId, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxById(mailboxId).map((Function)Throwing.function(mailbox -> this.myRights((Mailbox)mailbox, session)));
    }

    public MailboxACL.Rfc4314Rights myRights(Mailbox mailbox, MailboxSession session) {
        Username username = session.getUser();
        return Optional.ofNullable(username).map(Throwing.function(value -> this.aclResolver.resolveRights(username, mailbox.getACL(), mailbox.getUser().asString())).sneakyThrow()).orElse(MailboxACL.NO_RIGHTS);
    }

    public List<MailboxACL.Rfc4314Rights> listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = MailboxReactorUtils.blockOptional(mapper.findMailboxByPath(mailboxPath)).orElseThrow(() -> new MailboxNotFoundException(mailboxPath));
        return this.aclResolver.listRights(key, mailbox.getUser().asString());
    }

    public List<MailboxACL.Rfc4314Rights> listRights(Mailbox mailbox, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.aclResolver.listRights(key, mailbox.getUser().asString());
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.listRightsReactive(mailboxPath, session));
    }

    public Mono<MailboxACL> listRightsReactive(MailboxPath mailboxPath, MailboxSession session) {
        return Mono.fromCallable(() -> this.mailboxSessionMapperFactory.getMailboxMapper(session)).flatMap(mapper -> mapper.findMailboxByPath(mailboxPath)).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).map(Mailbox::getACL);
    }

    public MailboxACL listRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.listRightsReactive(mailboxId, session));
    }

    public Mono<MailboxACL> listRightsReactive(MailboxId mailboxId, MailboxSession session) {
        return Mono.fromCallable(() -> this.mailboxSessionMapperFactory.getMailboxMapper(session)).flatMap(mapper -> mapper.findMailboxById(mailboxId)).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxId))).map(Mailbox::getACL);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        MailboxReactorUtils.block(this.applyRightsCommandReactive(mailboxPath, mailboxACLCommand, session));
    }

    public Mono<Void> applyRightsCommandReactive(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) {
        return Mono.just((Object)this.mailboxSessionMapperFactory.getMailboxMapper(session)).doOnNext((Consumer)Throwing.consumer(mapper -> this.assertSharesBelongsToUserDomain(mailboxPath.getUser(), mailboxACLCommand))).flatMap(mapper -> mapper.findMailboxByPath(mailboxPath).doOnNext((Consumer)Throwing.consumer(mailbox -> this.assertHaveAccessTo((Mailbox)mailbox, session))).flatMap(mailbox -> mapper.updateACL((Mailbox)mailbox, mailboxACLCommand).flatMap(aclDiff -> this.dispatchACLUpdateEvent(session, (Mailbox)mailbox, (ACLDiff)aclDiff))));
    }

    private Mono<Void> dispatchACLUpdateEvent(MailboxSession session, Mailbox mailbox, ACLDiff aclDiff) {
        return this.eventBus.dispatch((Event)((EventFactory.MailboxAclUpdatedFinalStage)((EventFactory.RequireAclDiff)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.aclUpdated().randomEventId()).mailboxSession(session)).mailbox(mailbox)).aclDiff(aclDiff)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId()));
    }

    public void applyRightsCommand(MailboxId mailboxId, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = MailboxReactorUtils.blockOptional(mapper.findMailboxById(mailboxId)).orElseThrow(() -> new MailboxNotFoundException(mailboxId));
        this.applyRightsCommand(mailbox.generateAssociatedPath(), mailboxACLCommand, session);
    }

    private void assertSharesBelongsToUserDomain(Username user, MailboxACL.ACLCommand mailboxACLCommand) throws DifferentDomainException {
        this.assertSharesBelongsToUserDomain(user, (Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>)ImmutableMap.of((Object)mailboxACLCommand.getEntryKey(), (Object)mailboxACLCommand.getRights()));
    }

    public boolean isReadWrite(MailboxSession session, Mailbox mailbox, Flags sharedPermanentFlags) {
        if (mailbox.getUser().equals((Object)session.getUser())) {
            return true;
        }
        MailboxACL.Rfc4314Rights rights = this.myRights(mailbox, session);
        return rights.contains(MailboxACL.Right.Insert) || rights.contains(MailboxACL.Right.PerformExpunge) || this.checkDeleteFlag(rights, sharedPermanentFlags) || this.checkSeenFlag(rights, sharedPermanentFlags) || this.checkWriteFlag(rights, sharedPermanentFlags);
    }

    private boolean checkWriteFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return rights.contains(MailboxACL.Right.Write) && (sharedPermanentFlags.contains(Flags.Flag.ANSWERED) || sharedPermanentFlags.contains(Flags.Flag.DRAFT) || sharedPermanentFlags.contains(Flags.Flag.FLAGGED) || sharedPermanentFlags.contains(Flags.Flag.RECENT) || sharedPermanentFlags.contains(Flags.Flag.USER));
    }

    private boolean checkSeenFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return sharedPermanentFlags.contains(Flags.Flag.SEEN) && rights.contains(MailboxACL.Right.WriteSeenFlag);
    }

    private boolean checkDeleteFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return sharedPermanentFlags.contains(Flags.Flag.DELETED) && rights.contains(MailboxACL.Right.DeleteMessages);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = MailboxReactorUtils.blockOptional(mapper.findMailboxById(mailboxId)).orElseThrow(() -> new MailboxNotFoundException(mailboxId));
        this.setRights(mailbox.generateAssociatedPath(), mailboxACL, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.assertSharesBelongsToUserDomain(mailboxPath.getUser(), mailboxACL.getEntries());
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        MailboxReactorUtils.block(mapper.findMailboxByPath(mailboxPath).flatMap(Throwing.function(mailbox -> {
            this.assertHaveAccessTo((Mailbox)mailbox, session);
            return this.setRights(mailboxACL, mapper, (Mailbox)mailbox, session);
        }).sneakyThrow()));
    }

    private void assertHaveAccessTo(Mailbox mailbox, MailboxSession session) throws InsufficientRightsException, MailboxNotFoundException {
        if (!mailbox.generateAssociatedPath().belongsTo(session)) {
            if (mailbox.getACL().getEntries().containsKey(MailboxACL.EntryKey.createUserEntryKey((Username)session.getUser()))) {
                throw new InsufficientRightsException("Setting ACL is only permitted to the owner of the mailbox");
            }
            throw new MailboxNotFoundException(mailbox.getMailboxId());
        }
    }

    @VisibleForTesting
    void assertSharesBelongsToUserDomain(Username user, Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entries) throws DifferentDomainException {
        if (entries.keySet().stream().filter(entry -> !entry.getNameType().equals((Object)MailboxACL.NameType.special)).map(MailboxACL.EntryKey::getName).anyMatch(name -> this.areDomainsDifferent((String)name, user))) {
            throw new DifferentDomainException();
        }
    }

    @VisibleForTesting
    boolean areDomainsDifferent(String user, Username otherUser) {
        Optional otherDomain;
        Optional domain = Username.of((String)user).getDomainPart();
        return !domain.equals(otherDomain = otherUser.getDomainPart());
    }

    private Mono<Void> setRights(MailboxACL mailboxACL, MailboxMapper mapper, Mailbox mailbox, MailboxSession session) {
        return mapper.setACL(mailbox, mailboxACL).flatMap(aclDiff -> this.dispatchACLUpdateEvent(session, mailbox, (ACLDiff)aclDiff));
    }

    public MailboxACL getResolvedMailboxACL(Mailbox mailbox, MailboxSession mailboxSession) throws UnsupportedRightException {
        MailboxACL acl = this.aclResolver.applyGlobalACL(mailbox.getACL());
        return StoreRightManager.filteredForSession(mailbox, acl, mailboxSession);
    }

    @VisibleForTesting
    static MailboxACL filteredForSession(Mailbox mailbox, MailboxACL acl, MailboxSession mailboxSession) {
        if (mailbox.generateAssociatedPath().belongsTo(mailboxSession)) {
            return acl;
        }
        MailboxACL.EntryKey userAsKey = MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
        MailboxACL.Rfc4314Rights rights = acl.getEntries().getOrDefault(userAsKey, new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]));
        if (rights.contains(MailboxACL.Right.Administer)) {
            return acl;
        }
        return new MailboxACL((Map)ImmutableMap.of((Object)userAsKey, (Object)rights));
    }
}

