/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.MoveRequest;
import org.apache.james.imap.processor.AbstractMessageRangeProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class MoveProcessor
extends AbstractMessageRangeProcessor<MoveRequest>
implements CapabilityImplementingProcessor {
    private final boolean moveCapabilitySupported;

    @Inject
    public MoveProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(MoveRequest.class, mailboxManager, factory, metricFactory);
        this.moveCapabilitySupported = mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move);
    }

    @Override
    protected Flux<MessageRange> process(MailboxId targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MessageRange messageSet) {
        return Flux.from((Publisher)this.getMailboxManager().moveMessagesReactive(messageSet, currentMailbox.getMailboxId(), targetMailbox, mailboxSession));
    }

    @Override
    protected String getOperationName() {
        return "Move";
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (this.moveCapabilitySupported) {
            return ImmutableList.of((Object)ImapConstants.SUPPORTS_MOVE);
        }
        return ImmutableList.of();
    }

    @Override
    protected MDCBuilder mdc(MoveRequest request) {
        return MDCBuilder.create().addToContext("action", "MOVE").addToContext("targetMailbox", request.getMailboxName()).addToContext("uidEnabled", Boolean.toString(request.isUseUids())).addToContext("idSet", IdRange.toString(request.getIdSet()));
    }
}

