/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.util.function.Function;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CloseRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CloseProcessor
extends AbstractMailboxProcessor<CloseRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseProcessor.class);

    @Inject
    public CloseProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CloseRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(CloseRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        return this.getSelectedMailboxReactive(session).flatMap((Function)Throwing.function(mailbox -> {
            if (this.getMailboxManager().hasRight(mailbox.getMailboxEntity(), MailboxACL.Right.PerformExpunge, mailboxSession)) {
                return mailbox.expungeReactive(MessageRange.all(), mailboxSession).then(session.deselect()).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
            }
            return Mono.empty();
        })).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Close failed for mailbox {}", (Object)session.getSelected().getMailboxId(), e));
        }).then();
    }

    @Override
    protected MDCBuilder mdc(CloseRequest request) {
        return MDCBuilder.create().addToContext("action", "CLOSE");
    }
}

